/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.shaded.influxdb.com.squareup.moshi;

import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import org.apache.kylin.shaded.influxdb.com.squareup.moshi.FromJson;
import org.apache.kylin.shaded.influxdb.com.squareup.moshi.JsonAdapter;
import org.apache.kylin.shaded.influxdb.com.squareup.moshi.JsonDataException;
import org.apache.kylin.shaded.influxdb.com.squareup.moshi.JsonReader;
import org.apache.kylin.shaded.influxdb.com.squareup.moshi.JsonWriter;
import org.apache.kylin.shaded.influxdb.com.squareup.moshi.Moshi;
import org.apache.kylin.shaded.influxdb.com.squareup.moshi.ToJson;
import org.apache.kylin.shaded.influxdb.com.squareup.moshi.Types;
import org.apache.kylin.shaded.influxdb.com.squareup.moshi.Util;

final class AdapterMethodsFactory
implements JsonAdapter.Factory {
    private final List<AdapterMethod> toAdapters;
    private final List<AdapterMethod> fromAdapters;

    AdapterMethodsFactory(List<AdapterMethod> toAdapters, List<AdapterMethod> fromAdapters) {
        this.toAdapters = toAdapters;
        this.fromAdapters = fromAdapters;
    }

    @Override
    @Nullable
    public JsonAdapter<?> create(final Type type, final Set<? extends Annotation> annotations, final Moshi moshi) {
        JsonAdapter delegate;
        final AdapterMethod toAdapter = AdapterMethodsFactory.get(this.toAdapters, type, annotations);
        final AdapterMethod fromAdapter = AdapterMethodsFactory.get(this.fromAdapters, type, annotations);
        if (toAdapter == null && fromAdapter == null) {
            return null;
        }
        if (toAdapter == null || fromAdapter == null) {
            try {
                delegate = moshi.nextAdapter(this, type, annotations);
            }
            catch (IllegalArgumentException e) {
                String missingAnnotation = toAdapter == null ? "@ToJson" : "@FromJson";
                throw new IllegalArgumentException("No " + missingAnnotation + " adapter for " + type + " annotated " + annotations);
            }
        } else {
            delegate = null;
        }
        if (toAdapter != null) {
            toAdapter.bind(moshi, this);
        }
        if (fromAdapter != null) {
            fromAdapter.bind(moshi, this);
        }
        return new JsonAdapter<Object>(){

            @Override
            public void toJson(JsonWriter writer, @Nullable Object value) throws IOException {
                if (toAdapter == null) {
                    delegate.toJson(writer, value);
                } else if (!toAdapter.nullable && value == null) {
                    writer.nullValue();
                } else {
                    try {
                        toAdapter.toJson(moshi, writer, value);
                    }
                    catch (InvocationTargetException e) {
                        Throwable cause = e.getCause();
                        if (cause instanceof IOException) {
                            throw (IOException)cause;
                        }
                        throw new JsonDataException(cause + " at " + writer.getPath(), cause);
                    }
                }
            }

            @Override
            @Nullable
            public Object fromJson(JsonReader reader) throws IOException {
                if (fromAdapter == null) {
                    return delegate.fromJson(reader);
                }
                if (!fromAdapter.nullable && reader.peek() == JsonReader.Token.NULL) {
                    reader.nextNull();
                    return null;
                }
                try {
                    return fromAdapter.fromJson(moshi, reader);
                }
                catch (InvocationTargetException e) {
                    Throwable cause = e.getCause();
                    if (cause instanceof IOException) {
                        throw (IOException)cause;
                    }
                    throw new JsonDataException(cause + " at " + reader.getPath(), cause);
                }
            }

            public String toString() {
                return "JsonAdapter" + annotations + "(" + type + ")";
            }
        };
    }

    public static AdapterMethodsFactory get(Object adapter) {
        ArrayList<AdapterMethod> toAdapters = new ArrayList<AdapterMethod>();
        ArrayList<AdapterMethod> fromAdapters = new ArrayList<AdapterMethod>();
        for (Class<?> c = adapter.getClass(); c != Object.class; c = c.getSuperclass()) {
            for (Method m : c.getDeclaredMethods()) {
                AdapterMethod conflicting;
                if (m.isAnnotationPresent(ToJson.class)) {
                    AdapterMethod toAdapter = AdapterMethodsFactory.toAdapter(adapter, m);
                    conflicting = AdapterMethodsFactory.get(toAdapters, toAdapter.type, toAdapter.annotations);
                    if (conflicting != null) {
                        throw new IllegalArgumentException("Conflicting @ToJson methods:\n    " + conflicting.method + "\n" + "    " + toAdapter.method);
                    }
                    toAdapters.add(toAdapter);
                }
                if (!m.isAnnotationPresent(FromJson.class)) continue;
                AdapterMethod fromAdapter = AdapterMethodsFactory.fromAdapter(adapter, m);
                conflicting = AdapterMethodsFactory.get(fromAdapters, fromAdapter.type, fromAdapter.annotations);
                if (conflicting != null) {
                    throw new IllegalArgumentException("Conflicting @FromJson methods:\n    " + conflicting.method + "\n" + "    " + fromAdapter.method);
                }
                fromAdapters.add(fromAdapter);
            }
        }
        if (toAdapters.isEmpty() && fromAdapters.isEmpty()) {
            throw new IllegalArgumentException("Expected at least one @ToJson or @FromJson method on " + adapter.getClass().getName());
        }
        return new AdapterMethodsFactory(toAdapters, fromAdapters);
    }

    static AdapterMethod toAdapter(Object adapter, Method method) {
        method.setAccessible(true);
        final Type returnType = method.getGenericReturnType();
        Type[] parameterTypes = method.getGenericParameterTypes();
        Annotation[][] parameterAnnotations = method.getParameterAnnotations();
        if (parameterTypes.length >= 2 && parameterTypes[0] == JsonWriter.class && returnType == Void.TYPE && AdapterMethodsFactory.parametersAreJsonAdapters(2, parameterTypes)) {
            Set<? extends Annotation> qualifierAnnotations = Util.jsonAnnotations(parameterAnnotations[1]);
            return new AdapterMethod(parameterTypes[1], (Set)qualifierAnnotations, adapter, method, parameterTypes.length, 2, true){

                @Override
                public void toJson(Moshi moshi, JsonWriter writer, @Nullable Object value) throws IOException, InvocationTargetException {
                    this.invoke(writer, value);
                }
            };
        }
        if (parameterTypes.length == 1 && returnType != Void.TYPE) {
            final Set<? extends Annotation> returnTypeAnnotations = Util.jsonAnnotations(method);
            Set<? extends Annotation> qualifierAnnotations = Util.jsonAnnotations(parameterAnnotations[0]);
            boolean nullable = Util.hasNullable(parameterAnnotations[0]);
            return new AdapterMethod(parameterTypes[0], qualifierAnnotations, adapter, method, parameterTypes.length, 1, nullable){
                private JsonAdapter<Object> delegate;

                @Override
                public void bind(Moshi moshi, JsonAdapter.Factory factory) {
                    super.bind(moshi, factory);
                    this.delegate = moshi.adapter(returnType, returnTypeAnnotations);
                }

                @Override
                public void toJson(Moshi moshi, JsonWriter writer, @Nullable Object value) throws IOException, InvocationTargetException {
                    Object intermediate = this.invoke(value);
                    this.delegate.toJson(writer, intermediate);
                }
            };
        }
        throw new IllegalArgumentException("Unexpected signature for " + method + ".\n" + "@ToJson method signatures may have one of the following structures:\n" + "    <any access modifier> void toJson(JsonWriter writer, T value) throws <any>;\n" + "    <any access modifier> void toJson(JsonWriter writer," + " JsonAdapter<any> delegate, <any more delegates>) throws <any>;\n" + "    <any access modifier> void toJson(JsonWriter writer, T value" + " JsonAdapter<any> delegate, <any more delegates>) throws <any>;\n" + "    <any access modifier> R toJson(T value) throws <any>;\n");
    }

    private static boolean parametersAreJsonAdapters(int offset, Type[] parameterTypes) {
        int length = parameterTypes.length;
        for (int i = offset; i < length; ++i) {
            if (!(parameterTypes[i] instanceof ParameterizedType)) {
                return false;
            }
            if (((ParameterizedType)parameterTypes[i]).getRawType() == JsonAdapter.class) continue;
            return false;
        }
        return true;
    }

    static AdapterMethod fromAdapter(Object adapter, Method method) {
        method.setAccessible(true);
        Type returnType = method.getGenericReturnType();
        Set<? extends Annotation> returnTypeAnnotations = Util.jsonAnnotations(method);
        final Type[] parameterTypes = method.getGenericParameterTypes();
        Annotation[][] parameterAnnotations = method.getParameterAnnotations();
        if (parameterTypes.length >= 1 && parameterTypes[0] == JsonReader.class && returnType != Void.TYPE && AdapterMethodsFactory.parametersAreJsonAdapters(1, parameterTypes)) {
            return new AdapterMethod(returnType, (Set)returnTypeAnnotations, adapter, method, parameterTypes.length, 1, true){

                @Override
                public Object fromJson(Moshi moshi, JsonReader reader) throws IOException, InvocationTargetException {
                    return this.invoke(reader);
                }
            };
        }
        if (parameterTypes.length == 1 && returnType != Void.TYPE) {
            final Set<? extends Annotation> qualifierAnnotations = Util.jsonAnnotations(parameterAnnotations[0]);
            boolean nullable = Util.hasNullable(parameterAnnotations[0]);
            return new AdapterMethod(returnType, returnTypeAnnotations, adapter, method, parameterTypes.length, 1, nullable){
                JsonAdapter<Object> delegate;

                @Override
                public void bind(Moshi moshi, JsonAdapter.Factory factory) {
                    super.bind(moshi, factory);
                    this.delegate = moshi.adapter(parameterTypes[0], qualifierAnnotations);
                }

                @Override
                public Object fromJson(Moshi moshi, JsonReader reader) throws IOException, InvocationTargetException {
                    Object intermediate = this.delegate.fromJson(reader);
                    return this.invoke(intermediate);
                }
            };
        }
        throw new IllegalArgumentException("Unexpected signature for " + method + ".\n" + "@FromJson method signatures may have one of the following structures:\n" + "    <any access modifier> R fromJson(JsonReader jsonReader) throws <any>;\n" + "    <any access modifier> R fromJson(JsonReader jsonReader," + " JsonAdapter<any> delegate, <any more delegates>) throws <any>;\n" + "    <any access modifier> R fromJson(T value) throws <any>;\n");
    }

    @Nullable
    private static AdapterMethod get(List<AdapterMethod> adapterMethods, Type type, Set<? extends Annotation> annotations) {
        int size = adapterMethods.size();
        for (int i = 0; i < size; ++i) {
            AdapterMethod adapterMethod = adapterMethods.get(i);
            if (!adapterMethod.type.equals(type) || !adapterMethod.annotations.equals(annotations)) continue;
            return adapterMethod;
        }
        return null;
    }

    static abstract class AdapterMethod {
        final Type type;
        final Set<? extends Annotation> annotations;
        final Object adapter;
        final Method method;
        final int adaptersOffset;
        final JsonAdapter<?>[] jsonAdapters;
        final boolean nullable;

        AdapterMethod(Type type, Set<? extends Annotation> annotations, Object adapter, Method method, int parameterCount, int adaptersOffset, boolean nullable) {
            this.type = Types.canonicalize(type);
            this.annotations = annotations;
            this.adapter = adapter;
            this.method = method;
            this.adaptersOffset = adaptersOffset;
            this.jsonAdapters = new JsonAdapter[parameterCount - adaptersOffset];
            this.nullable = nullable;
        }

        public void bind(Moshi moshi, JsonAdapter.Factory factory) {
            if (this.jsonAdapters.length > 0) {
                Type[] parameterTypes = this.method.getGenericParameterTypes();
                Annotation[][] parameterAnnotations = this.method.getParameterAnnotations();
                int size = parameterTypes.length;
                for (int i = this.adaptersOffset; i < size; ++i) {
                    Type type = ((ParameterizedType)parameterTypes[i]).getActualTypeArguments()[0];
                    Set<? extends Annotation> jsonAnnotations = Util.jsonAnnotations(parameterAnnotations[i]);
                    this.jsonAdapters[i - this.adaptersOffset] = Types.equals(this.type, type) && this.annotations.equals(jsonAnnotations) ? moshi.nextAdapter(factory, type, jsonAnnotations) : moshi.adapter(type, jsonAnnotations);
                }
            }
        }

        public void toJson(Moshi moshi, JsonWriter writer, @Nullable Object value) throws IOException, InvocationTargetException {
            throw new AssertionError();
        }

        @Nullable
        public Object fromJson(Moshi moshi, JsonReader reader) throws IOException, InvocationTargetException {
            throw new AssertionError();
        }

        @Nullable
        protected Object invoke(@Nullable Object a1) throws InvocationTargetException {
            Object[] args = new Object[1 + this.jsonAdapters.length];
            args[0] = a1;
            System.arraycopy(this.jsonAdapters, 0, args, 1, this.jsonAdapters.length);
            try {
                return this.method.invoke(this.adapter, args);
            }
            catch (IllegalAccessException e) {
                throw new AssertionError();
            }
        }

        protected Object invoke(@Nullable Object a1, @Nullable Object a2) throws InvocationTargetException {
            Object[] args = new Object[2 + this.jsonAdapters.length];
            args[0] = a1;
            args[1] = a2;
            System.arraycopy(this.jsonAdapters, 0, args, 2, this.jsonAdapters.length);
            try {
                return this.method.invoke(this.adapter, args);
            }
            catch (IllegalAccessException e) {
                throw new AssertionError();
            }
        }
    }
}

