/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.rel.core;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import org.apache.calcite.linq4j.Ord;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptCost;
import org.apache.calcite.plan.RelOptPlanner;
import org.apache.calcite.plan.RelOptUtil;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.RelInput;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.RelWriter;
import org.apache.calcite.rel.SingleRel;
import org.apache.calcite.rel.core.AggregateCall;
import org.apache.calcite.rel.hint.Hintable;
import org.apache.calcite.rel.hint.RelHint;
import org.apache.calcite.rel.metadata.RelMetadataQuery;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.calcite.runtime.CalciteException;
import org.apache.calcite.runtime.Resources;
import org.apache.calcite.sql.SqlAggFunction;
import org.apache.calcite.sql.SqlOperatorBinding;
import org.apache.calcite.sql.SqlUtil;
import org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.calcite.sql.validate.SqlValidatorException;
import org.apache.calcite.util.ImmutableBitSet;
import org.apache.calcite.util.Litmus;
import org.apache.calcite.util.Pair;
import org.apache.calcite.util.Util;
import org.apache.kylin.guava30.shaded.common.base.Preconditions;
import org.apache.kylin.guava30.shaded.common.base.Predicate;
import org.apache.kylin.guava30.shaded.common.collect.ImmutableList;
import org.apache.kylin.guava30.shaded.common.math.IntMath;
import org.checkerframework.checker.nullness.qual.Nullable;

public abstract class Aggregate
extends SingleRel
implements Hintable {
    protected final ImmutableList<RelHint> hints;
    @Deprecated
    public static final Predicate<Aggregate> IS_SIMPLE = Aggregate::isSimple;
    @Deprecated
    public static final Predicate<Aggregate> NO_INDICATOR = Aggregate::noIndicator;
    @Deprecated
    public static final Predicate<Aggregate> IS_NOT_GRAND_TOTAL = Aggregate::isNotGrandTotal;
    @Deprecated
    public final boolean indicator = false;
    protected final List<AggregateCall> aggCalls;
    protected final ImmutableBitSet groupSet;
    public final ImmutableList<ImmutableBitSet> groupSets;

    public static boolean isSimple(Aggregate aggregate) {
        return aggregate.getGroupType() == Group.SIMPLE;
    }

    public static void checkIndicator(boolean indicator) {
        Preconditions.checkArgument((!indicator ? 1 : 0) != 0, (Object)"indicator is no longer supported; use GROUPING function instead");
    }

    protected Aggregate(RelOptCluster cluster, RelTraitSet traitSet, List<RelHint> hints, RelNode input, ImmutableBitSet groupSet, @Nullable List<ImmutableBitSet> groupSets, List<AggregateCall> aggCalls) {
        super(cluster, traitSet, input);
        this.hints = ImmutableList.copyOf(hints);
        this.aggCalls = ImmutableList.copyOf(aggCalls);
        this.groupSet = Objects.requireNonNull(groupSet, "groupSet");
        if (groupSets == null) {
            this.groupSets = ImmutableList.of((Object)groupSet);
        } else {
            this.groupSets = ImmutableList.copyOf(groupSets);
            assert (ImmutableBitSet.ORDERING.isStrictlyOrdered(groupSets)) : groupSets;
            for (ImmutableBitSet set : groupSets) {
                assert (groupSet.contains(set));
            }
        }
        assert (groupSet.length() <= input.getRowType().getFieldCount());
        for (AggregateCall aggCall : aggCalls) {
            assert (this.typeMatchesInferred(aggCall, Litmus.THROW));
            Preconditions.checkArgument((aggCall.filterArg < 0 || Aggregate.isPredicate(input, aggCall.filterArg) ? 1 : 0) != 0, (Object)"filter must be BOOLEAN NOT NULL");
        }
    }

    @Deprecated
    protected Aggregate(RelOptCluster cluster, RelTraitSet traitSet, RelNode input, ImmutableBitSet groupSet, List<ImmutableBitSet> groupSets, List<AggregateCall> aggCalls) {
        this(cluster, traitSet, new ArrayList<RelHint>(), input, groupSet, groupSets, aggCalls);
    }

    @Deprecated
    protected Aggregate(RelOptCluster cluster, RelTraitSet traits, RelNode child, boolean indicator, ImmutableBitSet groupSet, List<ImmutableBitSet> groupSets, List<AggregateCall> aggCalls) {
        this(cluster, traits, (List<RelHint>)ImmutableList.of(), child, groupSet, groupSets, aggCalls);
        Aggregate.checkIndicator(indicator);
    }

    public static boolean isNotGrandTotal(Aggregate aggregate) {
        return aggregate.getGroupCount() > 0;
    }

    @Deprecated
    public static boolean noIndicator(Aggregate aggregate) {
        return true;
    }

    private static boolean isPredicate(RelNode input, int index) {
        RelDataType type = input.getRowType().getFieldList().get(index).getType();
        return type.getSqlTypeName() == SqlTypeName.BOOLEAN && !type.isNullable();
    }

    protected Aggregate(RelInput input) {
        this(input.getCluster(), input.getTraitSet(), new ArrayList<RelHint>(), input.getInput(), input.getBitSet("group"), input.getBitSetList("groups"), input.getAggregateCalls("aggs"));
    }

    @Override
    public final RelNode copy(RelTraitSet traitSet, List<RelNode> inputs) {
        return this.copy(traitSet, Aggregate.sole(inputs), this.groupSet, (List<ImmutableBitSet>)this.groupSets, this.aggCalls);
    }

    public abstract Aggregate copy(RelTraitSet var1, RelNode var2, ImmutableBitSet var3, @Nullable List<ImmutableBitSet> var4, List<AggregateCall> var5);

    @Deprecated
    public Aggregate copy(RelTraitSet traitSet, RelNode input, boolean indicator, ImmutableBitSet groupSet, List<ImmutableBitSet> groupSets, List<AggregateCall> aggCalls) {
        Aggregate.checkIndicator(indicator);
        return this.copy(traitSet, input, groupSet, groupSets, aggCalls);
    }

    public List<AggregateCall> getAggCallList() {
        return this.aggCalls;
    }

    public List<Pair<AggregateCall, String>> getNamedAggCalls() {
        int offset = this.getGroupCount();
        return Pair.zip(this.aggCalls, Util.skip(this.getRowType().getFieldNames(), offset));
    }

    public int getGroupCount() {
        return this.groupSet.cardinality();
    }

    @Deprecated
    public int getIndicatorCount() {
        return 0;
    }

    public ImmutableBitSet getGroupSet() {
        return this.groupSet;
    }

    public ImmutableList<ImmutableBitSet> getGroupSets() {
        return this.groupSets;
    }

    @Override
    public RelWriter explainTerms(RelWriter pw) {
        super.explainTerms(pw).item("group", this.groupSet).itemIf("groups", this.groupSets, this.getGroupType() != Group.SIMPLE).itemIf("aggs", this.aggCalls, pw.nest());
        if (!pw.nest()) {
            for (Ord ord : Ord.zip(this.aggCalls)) {
                pw.item(Util.first(((AggregateCall)ord.e).name, "agg#" + ord.i), ord.e);
            }
        }
        return pw;
    }

    @Override
    public double estimateRowCount(RelMetadataQuery mq) {
        int groupCount = this.groupSet.cardinality();
        if (groupCount == 0) {
            return 1.0;
        }
        double rowCount = super.estimateRowCount(mq);
        return rowCount *= 1.0 - Math.pow(0.5, groupCount);
    }

    @Override
    public @Nullable RelOptCost computeSelfCost(RelOptPlanner planner, RelMetadataQuery mq) {
        double rowCount = mq.getRowCount(this);
        float multiplier = 1.0f + (float)this.aggCalls.size() * 0.125f;
        for (AggregateCall aggCall : this.aggCalls) {
            if (!aggCall.getAggregation().getName().equals("SUM")) continue;
            multiplier += 0.0125f;
        }
        return planner.getCostFactory().makeCost(rowCount * (double)multiplier, 0.0, 0.0);
    }

    @Override
    protected RelDataType deriveRowType() {
        return Aggregate.deriveRowType(this.getCluster().getTypeFactory(), this.getInput().getRowType(), false, this.groupSet, this.groupSets, this.aggCalls);
    }

    public static RelDataType deriveRowType(RelDataTypeFactory typeFactory, RelDataType inputRowType, boolean indicator, ImmutableBitSet groupSet, @Nullable List<ImmutableBitSet> groupSets, List<AggregateCall> aggCalls) {
        List<Integer> groupList = groupSet.asList();
        assert (groupList.size() == groupSet.cardinality());
        RelDataTypeFactory.FieldInfoBuilder builder = typeFactory.builder();
        List<RelDataTypeField> fieldList = inputRowType.getFieldList();
        HashSet<String> containedNames = new HashSet<String>();
        for (int groupKey : groupList) {
            RelDataTypeField field = fieldList.get(groupKey);
            containedNames.add(field.getName());
            ((RelDataTypeFactory.Builder)builder).add(field);
            if (groupSets == null || ImmutableBitSet.allContain(groupSets, groupKey)) continue;
            ((RelDataTypeFactory.Builder)builder).nullable(true);
        }
        Aggregate.checkIndicator(indicator);
        for (Ord aggCall : Ord.zip(aggCalls)) {
            String base = ((AggregateCall)aggCall.e).name != null ? ((AggregateCall)aggCall.e).name : "$f" + (groupList.size() + aggCall.i);
            String name = base;
            int i = 0;
            while (containedNames.contains(name)) {
                name = base + "_" + i++;
            }
            containedNames.add(name);
            ((RelDataTypeFactory.Builder)builder).add(name, ((AggregateCall)aggCall.e).type);
        }
        return builder.build();
    }

    @Override
    public boolean isValid(Litmus litmus, @Nullable RelNode.Context context) {
        return super.isValid(litmus, context) && litmus.check(Util.isDistinct(this.getRowType().getFieldNames()), "distinct field names: {}", this.getRowType());
    }

    private boolean typeMatchesInferred(AggregateCall aggCall, Litmus litmus) {
        SqlAggFunction aggFunction = aggCall.getAggregation();
        AggCallBinding callBinding = aggCall.createBinding(this);
        RelDataType type = aggFunction.inferReturnType(callBinding);
        RelDataType expectedType = aggCall.type;
        return RelOptUtil.eq("aggCall type", expectedType, "inferred type", type, litmus);
    }

    public boolean containsDistinctCall() {
        for (AggregateCall call : this.aggCalls) {
            if (!call.isDistinct()) continue;
            return true;
        }
        return false;
    }

    @Override
    public ImmutableList<RelHint> getHints() {
        return this.hints;
    }

    public Group getGroupType() {
        return Group.induce(this.groupSet, this.groupSets);
    }

    public static class AggCallBinding
    extends SqlOperatorBinding {
        private final List<RelDataType> operands;
        private final int groupCount;
        private final boolean filter;

        public AggCallBinding(RelDataTypeFactory typeFactory, SqlAggFunction aggFunction, List<RelDataType> operands, int groupCount, boolean filter) {
            super(typeFactory, aggFunction);
            this.operands = operands;
            this.groupCount = groupCount;
            this.filter = filter;
            assert (operands != null) : "operands of aggregate call should not be null";
            assert (groupCount >= 0) : "number of group by columns should be greater than zero in aggregate call. Got " + groupCount;
        }

        @Override
        public int getGroupCount() {
            return this.groupCount;
        }

        @Override
        public boolean hasFilter() {
            return this.filter;
        }

        @Override
        public int getOperandCount() {
            return this.operands.size();
        }

        @Override
        public RelDataType getOperandType(int ordinal) {
            return this.operands.get(ordinal);
        }

        @Override
        public CalciteException newError(Resources.ExInst<SqlValidatorException> e) {
            return SqlUtil.newContextException(SqlParserPos.ZERO, e);
        }
    }

    public static final class Group
    extends Enum<Group> {
        public static final /* enum */ Group SIMPLE = new Group();
        public static final /* enum */ Group ROLLUP = new Group();
        public static final /* enum */ Group CUBE = new Group();
        public static final /* enum */ Group OTHER = new Group();
        private static final /* synthetic */ Group[] $VALUES;

        public static Group[] values() {
            return (Group[])$VALUES.clone();
        }

        public static Group valueOf(String name) {
            return Enum.valueOf(Group.class, name);
        }

        public static Group induce(ImmutableBitSet groupSet, List<ImmutableBitSet> groupSets) {
            if (!ImmutableBitSet.ORDERING.isStrictlyOrdered(groupSets)) {
                throw new IllegalArgumentException("must be sorted: " + groupSets);
            }
            if (groupSets.size() == 1 && groupSets.get(0).equals(groupSet)) {
                return SIMPLE;
            }
            if (groupSets.size() == IntMath.pow((int)2, (int)groupSet.cardinality())) {
                return CUBE;
            }
            if (Group.isRollup(groupSet, groupSets)) {
                return ROLLUP;
            }
            return OTHER;
        }

        public static boolean isRollup(ImmutableBitSet groupSet, List<ImmutableBitSet> groupSets) {
            if (groupSets.size() != groupSet.cardinality() + 1) {
                return false;
            }
            ImmutableBitSet g = null;
            for (ImmutableBitSet bitSet : groupSets) {
                if (g == null ? !bitSet.equals(groupSet) : !g.contains(bitSet) || g.cardinality() - bitSet.cardinality() != 1) {
                    return false;
                }
                g = bitSet;
            }
            assert (g != null) : "groupSet must not be empty";
            assert (g.isEmpty());
            return true;
        }

        public static List<Integer> getRollup(List<ImmutableBitSet> groupSets) {
            ArrayList<Integer> rollUpBits = new ArrayList<Integer>(groupSets.size() - 1);
            ImmutableBitSet g = null;
            for (ImmutableBitSet bitSet : groupSets) {
                if (g != null) {
                    ImmutableBitSet diff = g.except(bitSet);
                    assert (diff.cardinality() == 1);
                    rollUpBits.add(diff.nth(0));
                }
                g = bitSet;
            }
            Collections.reverse(rollUpBits);
            return ImmutableList.copyOf(rollUpBits);
        }

        static {
            $VALUES = new Group[]{SIMPLE, ROLLUP, CUBE, OTHER};
        }
    }
}

