/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.rel.externalize;

import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import org.apache.calcite.plan.hep.HepRelVertex;
import org.apache.calcite.plan.volcano.RelSubset;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.RelWriter;
import org.apache.calcite.rel.externalize.ImmutableRelDotWriter;
import org.apache.calcite.rel.externalize.RelWriterImpl;
import org.apache.calcite.rel.metadata.RelMetadataQuery;
import org.apache.calcite.sql.SqlExplainLevel;
import org.apache.calcite.util.Pair;
import org.apache.calcite.util.Util;
import org.apache.kylin.guava30.shaded.common.collect.HashMultimap;
import org.apache.kylin.guava30.shaded.common.collect.Multimap;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.immutables.value.Value;

@Value.Enclosing
public class RelDotWriter
extends RelWriterImpl {
    private final Map<RelNode, List<RelNode>> outArcTable = new LinkedHashMap<RelNode, List<RelNode>>();
    private Map<RelNode, String> nodeLabels = new HashMap<RelNode, String>();
    private Multimap<RelNode, String> nodeStyles = HashMultimap.create();
    private final WriteOption option;

    public RelDotWriter(PrintWriter pw, SqlExplainLevel detailLevel, boolean withIdPrefix) {
        this(pw, detailLevel, withIdPrefix, WriteOption.DEFAULT);
    }

    public RelDotWriter(PrintWriter pw, SqlExplainLevel detailLevel, boolean withIdPrefix, WriteOption option) {
        super(pw, detailLevel, withIdPrefix);
        this.option = option;
    }

    @Override
    protected void explain_(RelNode rel, List<Pair<String, @Nullable Object>> values) {
        List<RelNode> inputs = RelDotWriter.getInputs(rel);
        this.outArcTable.put(rel, inputs);
        String label = this.getRelNodeLabel(rel, values);
        this.nodeLabels.put(rel, label);
        if (this.highlightNode(rel)) {
            this.nodeStyles.put((Object)rel, (Object)"bold");
        }
        this.explainInputs(inputs);
    }

    protected String getRelNodeLabel(RelNode rel, List<Pair<String, @Nullable Object>> values) {
        ArrayList<String> labels = new ArrayList<String>();
        StringBuilder sb = new StringBuilder();
        RelMetadataQuery mq = rel.getCluster().getMetadataQuery();
        if (this.withIdPrefix) {
            sb.append(rel.getId()).append(":");
        }
        sb.append(rel.getRelTypeName());
        labels.add(sb.toString());
        sb.setLength(0);
        if (this.detailLevel != SqlExplainLevel.NO_ATTRIBUTES) {
            for (Pair<String, Object> value : values) {
                if (value.right instanceof RelNode) continue;
                sb.append((String)value.left).append(" = ").append(value.right);
                labels.add(sb.toString());
                sb.setLength(0);
            }
        }
        switch (this.detailLevel) {
            case ALL_ATTRIBUTES: {
                sb.append("rowcount = ").append(mq.getRowCount(rel)).append(" cumulative cost = ").append(mq.getCumulativeCost(rel)).append(" ");
                break;
            }
        }
        switch (this.detailLevel) {
            case ALL_ATTRIBUTES: 
            case NON_COST_ATTRIBUTES: {
                if (this.withIdPrefix) break;
                sb.append("id = ").append(rel.getId());
                break;
            }
        }
        labels.add(sb.toString().trim());
        sb.setLength(0);
        int leftSpace = this.option.maxNodeLabelLength();
        ArrayList<String> newlabels = new ArrayList<String>();
        for (int i = 0; i < labels.size(); ++i) {
            if (this.option.maxNodeLabelLength() != -1 && leftSpace <= 0) {
                if (i >= labels.size() - 1) break;
                newlabels.add("...");
                break;
            }
            String formatted = this.formatNodeLabel((String)labels.get(i), this.option.maxNodeLabelLength());
            newlabels.add(formatted);
            leftSpace -= formatted.length();
        }
        return "\"" + String.join((CharSequence)"\\n", newlabels) + "\"";
    }

    private static List<RelNode> getInputs(RelNode parent) {
        return Util.transform(parent.getInputs(), child -> {
            if (child instanceof HepRelVertex) {
                return ((HepRelVertex)child).getCurrentRel();
            }
            if (child instanceof RelSubset) {
                RelSubset subset = (RelSubset)child;
                return subset.getBestOrOriginal();
            }
            return child;
        });
    }

    private void explainInputs(List<? extends @Nullable RelNode> inputs) {
        for (RelNode relNode : inputs) {
            if (relNode == null || this.nodeLabels.containsKey(relNode)) continue;
            relNode.explain(this);
        }
    }

    @Override
    public RelWriter done(RelNode node) {
        int numOfVisitedNodes = this.nodeLabels.size();
        super.done(node);
        if (numOfVisitedNodes == 0) {
            this.pw.println("digraph {");
            for (RelNode relNode : this.nodeStyles.keySet()) {
                String style = String.join((CharSequence)",", this.nodeStyles.get((Object)relNode));
                this.pw.println(this.nodeLabels.get(relNode) + " [style=\"" + style + "\"]");
            }
            for (Map.Entry entry : this.outArcTable.entrySet()) {
                RelNode src = (RelNode)entry.getKey();
                String srcDesc = this.nodeLabels.get(src);
                for (int i = 0; i < ((List)entry.getValue()).size(); ++i) {
                    RelNode dst = (RelNode)((List)entry.getValue()).get(i);
                    this.pw.println(this.nodeLabels.get(dst) + " -> " + srcDesc + " [label=\"" + i + "\"]");
                }
            }
            this.pw.println("}");
            this.pw.flush();
        }
        return this;
    }

    private String formatNodeLabel(String label, int limit) {
        label = label.trim();
        label = label.replace("\"", "\\\"");
        boolean trimmed = false;
        if (limit != -1 && label.length() > limit) {
            label = label.substring(0, limit);
            trimmed = true;
        }
        if (this.option.maxNodeLabelPerLine() == -1) {
            return label + (trimmed ? "..." : "");
        }
        ArrayList<String> descParts = new ArrayList<String>();
        for (int idx = 0; idx < label.length(); idx += this.option.maxNodeLabelPerLine()) {
            int endIdx = idx + this.option.maxNodeLabelPerLine() > label.length() ? label.length() : idx + this.option.maxNodeLabelPerLine();
            descParts.add(label.substring(idx, endIdx));
        }
        return String.join((CharSequence)"\\n", descParts) + (trimmed ? "..." : "");
    }

    boolean highlightNode(RelNode node) {
        Predicate<RelNode> predicate = this.option.nodePredicate();
        return predicate != null && predicate.test(node);
    }

    @Value.Immutable
    public static interface WriteOption {
        public static final WriteOption DEFAULT = ImmutableRelDotWriter.WriteOption.of();

        @Value.Default
        default public int maxNodeLabelLength() {
            return 100;
        }

        @Value.Default
        default public int maxNodeLabelPerLine() {
            return 20;
        }

        public @Nullable Predicate<RelNode> nodePredicate();
    }
}

