/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.rel.rules;

import java.util.ArrayList;
import java.util.Objects;
import org.apache.calcite.plan.RelOptRuleCall;
import org.apache.calcite.plan.RelOptUtil;
import org.apache.calcite.plan.RelRule;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.Join;
import org.apache.calcite.rel.core.Project;
import org.apache.calcite.rel.logical.LogicalJoin;
import org.apache.calcite.rel.logical.LogicalProject;
import org.apache.calcite.rel.rules.ImmutableProjectJoinTransposeRule;
import org.apache.calcite.rel.rules.PushProjector;
import org.apache.calcite.rel.rules.TransformationRule;
import org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.calcite.rex.RexCall;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexOver;
import org.apache.calcite.rex.RexShuttle;
import org.apache.calcite.tools.RelBuilderFactory;
import org.immutables.value.Value;

@Value.Enclosing
public class ProjectJoinTransposeRule
extends RelRule<Config>
implements TransformationRule {
    protected ProjectJoinTransposeRule(Config config) {
        super(config);
    }

    @Deprecated
    public ProjectJoinTransposeRule(Class<? extends Project> projectClass, Class<? extends Join> joinClass, PushProjector.ExprCondition preserveExprCondition, RelBuilderFactory relBuilderFactory) {
        this(Config.DEFAULT.withRelBuilderFactory(relBuilderFactory).as(Config.class).withOperandFor(projectClass, joinClass).withPreserveExprCondition(preserveExprCondition));
    }

    @Override
    public void onMatch(final RelOptRuleCall call) {
        Join join;
        RexNode joinFilter;
        Project origProject = (Project)call.rel(0);
        PushProjector pushProjector = new PushProjector(origProject, joinFilter = (join = (Join)call.rel(1)).getCondition().accept(new RexShuttle(){

            @Override
            public RexNode visitCall(RexCall rexCall) {
                RexNode node = super.visitCall(rexCall);
                if (!(node instanceof RexCall)) {
                    return node;
                }
                return RelOptUtil.collapseExpandedIsNotDistinctFromExpr((RexCall)node, call.builder().getRexBuilder());
            }
        }), join, ((Config)this.config).preserveExprCondition(), call.builder());
        if (pushProjector.locateAllRefs()) {
            return;
        }
        Project leftProject = pushProjector.createProjectRefsAndExprs(join.getLeft(), true, false);
        Project rightProject = pushProjector.createProjectRefsAndExprs(join.getRight(), true, true);
        RexNode newJoinFilter = null;
        int[] adjustments = pushProjector.getAdjustments();
        if (joinFilter != null) {
            ArrayList<RelDataTypeField> projectJoinFieldList = new ArrayList<RelDataTypeField>();
            projectJoinFieldList.addAll(join.getSystemFieldList());
            projectJoinFieldList.addAll(leftProject.getRowType().getFieldList());
            projectJoinFieldList.addAll(rightProject.getRowType().getFieldList());
            newJoinFilter = pushProjector.convertRefsAndExprs(joinFilter, projectJoinFieldList, adjustments);
        }
        Join newJoin = join.copy(join.getTraitSet(), Objects.requireNonNull(newJoinFilter, "newJoinFilter must not be null"), leftProject, rightProject, join.getJoinType(), join.isSemiJoinDone());
        RelNode topProject = pushProjector.createNewProject(newJoin, adjustments);
        call.transformTo(topProject);
    }

    @Value.Immutable(singleton=false)
    public static interface Config
    extends RelRule.Config {
        public static final Config DEFAULT = ImmutableProjectJoinTransposeRule.Config.builder().withPreserveExprCondition(expr -> !(expr instanceof RexOver)).build().withOperandFor(LogicalProject.class, LogicalJoin.class);

        @Override
        default public ProjectJoinTransposeRule toRule() {
            return new ProjectJoinTransposeRule(this);
        }

        public PushProjector.ExprCondition preserveExprCondition();

        public Config withPreserveExprCondition(PushProjector.ExprCondition var1);

        default public Config withOperandFor(Class<? extends Project> projectClass, Class<? extends Join> joinClass) {
            return this.withOperandSupplier(b0 -> b0.operand(projectClass).oneInput(b1 -> b1.operand(joinClass).anyInputs())).as(Config.class);
        }
    }
}

