/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.rel.rules;

import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptRuleCall;
import org.apache.calcite.plan.RelOptRuleOperand;
import org.apache.calcite.plan.RelOptUtil;
import org.apache.calcite.plan.RelRule;
import org.apache.calcite.rel.RelCollation;
import org.apache.calcite.rel.RelCollationTraitDef;
import org.apache.calcite.rel.RelCollations;
import org.apache.calcite.rel.RelFieldCollation;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.Project;
import org.apache.calcite.rel.core.Sort;
import org.apache.calcite.rel.logical.LogicalProject;
import org.apache.calcite.rel.rules.ImmutableSortProjectTransposeRule;
import org.apache.calcite.rel.rules.TransformationRule;
import org.apache.calcite.rex.RexCall;
import org.apache.calcite.rex.RexCallBinding;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexUtil;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.validate.SqlMonotonicity;
import org.apache.calcite.tools.RelBuilderFactory;
import org.apache.calcite.util.mapping.Mappings;
import org.apache.kylin.guava30.shaded.common.collect.ImmutableList;
import org.apache.kylin.guava30.shaded.common.collect.ImmutableMap;
import org.immutables.value.Value;

@Value.Enclosing
public class SortProjectTransposeRule
extends RelRule<Config>
implements TransformationRule {
    protected SortProjectTransposeRule(Config config) {
        super(config);
    }

    @Deprecated
    public SortProjectTransposeRule(Class<? extends Sort> sortClass, Class<? extends Project> projectClass) {
        this(Config.DEFAULT.withOperandFor(sortClass, projectClass));
    }

    @Deprecated
    public SortProjectTransposeRule(Class<? extends Sort> sortClass, Class<? extends Project> projectClass, String description) {
        this(Config.DEFAULT.withDescription(description).as(Config.class).withOperandFor(sortClass, projectClass));
    }

    @Deprecated
    public SortProjectTransposeRule(Class<? extends Sort> sortClass, Class<? extends Project> projectClass, RelBuilderFactory relBuilderFactory, String description) {
        this(Config.DEFAULT.withRelBuilderFactory(relBuilderFactory).withDescription(description).as(Config.class).withOperandFor(sortClass, projectClass));
    }

    @Deprecated
    protected SortProjectTransposeRule(RelOptRuleOperand operand, RelBuilderFactory relBuilderFactory, String description) {
        this(Config.DEFAULT.withRelBuilderFactory(relBuilderFactory).withDescription(description).withOperandSupplier(b -> b.exactly(operand)).as(Config.class));
    }

    @Deprecated
    protected SortProjectTransposeRule(RelOptRuleOperand operand) {
        this(Config.DEFAULT.withOperandSupplier(b -> b.exactly(operand)).as(Config.class));
    }

    @Override
    public void onMatch(RelOptRuleCall call) {
        Sort sort = (Sort)call.rel(0);
        Project project = (Project)call.rel(1);
        RelOptCluster cluster = project.getCluster();
        if (sort.getConvention() != project.getConvention()) {
            return;
        }
        Mappings.TargetMapping map = RelOptUtil.permutationIgnoreCast(project.getProjects(), project.getInput().getRowType());
        for (RelFieldCollation fc : sort.getCollation().getFieldCollations()) {
            if (map.getTargetOpt(fc.getFieldIndex()) < 0) {
                return;
            }
            RexNode node = project.getProjects().get(fc.getFieldIndex());
            if (!node.isA(SqlKind.CAST)) continue;
            RexCall cast = (RexCall)node;
            RelFieldCollation newFc = Objects.requireNonNull(RexUtil.apply(map, fc));
            RexCallBinding binding = RexCallBinding.create(cluster.getTypeFactory(), cast, (List<RelCollation>)ImmutableList.of((Object)RelCollations.of(newFc)));
            if (cast.getOperator().getMonotonicity(binding) != SqlMonotonicity.NOT_MONOTONIC) continue;
            return;
        }
        RelCollation newCollation = cluster.traitSet().canonize(RexUtil.apply(map, sort.getCollation()));
        Sort newSort = sort.copy(sort.getTraitSet().replace(newCollation), project.getInput(), newCollation, sort.offset, sort.fetch);
        RelNode newProject = project.copy(sort.getTraitSet(), (List<RelNode>)ImmutableList.of((Object)newSort));
        ImmutableMap equiv = sort.offset == null && sort.fetch == null && cluster.getPlanner().getRelTraitDefs().contains(RelCollationTraitDef.INSTANCE) ? ImmutableMap.of((Object)newSort, (Object)project.getInput()) : ImmutableMap.of();
        call.transformTo(newProject, (Map<RelNode, RelNode>)equiv);
    }

    @Value.Immutable
    public static interface Config
    extends RelRule.Config {
        public static final Config DEFAULT = ImmutableSortProjectTransposeRule.Config.of().withOperandFor(Sort.class, LogicalProject.class);

        @Override
        default public SortProjectTransposeRule toRule() {
            return new SortProjectTransposeRule(this);
        }

        default public Config withOperandFor(Class<? extends Sort> sortClass, Class<? extends Project> projectClass) {
            return this.withOperandSupplier(b0 -> b0.operand(sortClass).oneInput(b1 -> b1.operand(projectClass).predicate(p -> !p.containsOver()).anyInputs())).as(Config.class);
        }

        default public Config withOperandFor(Class<? extends Sort> sortClass, Class<? extends Project> projectClass, Class<? extends RelNode> inputClass) {
            return this.withOperandSupplier(b0 -> b0.operand(sortClass).oneInput(b1 -> b1.operand(projectClass).predicate(p -> !p.containsOver()).oneInput(b2 -> b2.operand(inputClass).anyInputs()))).as(Config.class);
        }
    }
}

