/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.sql.fun;

import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import org.apache.kylin.guava30.shaded.common.base.Preconditions;
import org.apache.kylin.guava30.shaded.common.collect.ImmutableList;
import org.apache.kylin.guava30.shaded.common.collect.ImmutableMap;
import org.checkerframework.checker.nullness.qual.Nullable;

public enum SqlLibrary {
    STANDARD("", "standard"),
    SPATIAL("s", "spatial"),
    BIG_QUERY("b", "bigquery"),
    HIVE("h", "hive"),
    MYSQL("m", "mysql"),
    ORACLE("o", "oracle"),
    POSTGRESQL("p", "postgresql"),
    SPARK("s", "spark");

    public final String abbrev;
    public final String fun;
    public static final Map<String, SqlLibrary> MAP;

    private SqlLibrary(String abbrev, String fun) {
        this.abbrev = Objects.requireNonNull(abbrev, "abbrev");
        this.fun = Objects.requireNonNull(fun, "fun");
        Preconditions.checkArgument((boolean)fun.equals(this.name().toLowerCase(Locale.ROOT).replace("_", "")));
    }

    public static @Nullable SqlLibrary of(String name) {
        return MAP.get(name);
    }

    public static List<SqlLibrary> parse(String libraryNameList) {
        ImmutableList.Builder list = ImmutableList.builder();
        for (String libraryName : libraryNameList.split(",")) {
            SqlLibrary library = Objects.requireNonNull(SqlLibrary.of(libraryName), () -> "library does not exist: " + libraryName);
            list.add((Object)library);
        }
        return list.build();
    }

    static {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (SqlLibrary value : SqlLibrary.values()) {
            builder.put((Object)value.name(), (Object)value);
            builder.put((Object)value.fun, (Object)value);
        }
        MAP = builder.build();
    }
}

