/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.sql2rel;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.sql.SqlCall;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.calcite.sql2rel.SqlRexContext;
import org.apache.calcite.sql2rel.SqlRexConvertlet;
import org.apache.calcite.sql2rel.SqlRexConvertletTable;
import org.apache.kylin.guava30.shaded.common.base.Preconditions;
import org.checkerframework.checker.initialization.qual.UnderInitialization;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.RequiresNonNull;

public class ReflectiveConvertletTable
implements SqlRexConvertletTable {
    private final Map<Object, Object> map = new HashMap<Object, Object>();

    public ReflectiveConvertletTable() {
        for (Method method : this.getClass().getMethods()) {
            this.registerNodeTypeMethod(method);
            this.registerOpTypeMethod(method);
        }
    }

    @RequiresNonNull(value={"map"})
    private void registerNodeTypeMethod(@UnderInitialization ReflectiveConvertletTable this, Method method) {
        if (!Modifier.isPublic(method.getModifiers())) {
            return;
        }
        if (!method.getName().startsWith("convert")) {
            return;
        }
        if (!RexNode.class.isAssignableFrom(method.getReturnType())) {
            return;
        }
        Class<?>[] parameterTypes = method.getParameterTypes();
        if (parameterTypes.length != 2) {
            return;
        }
        if (parameterTypes[0] != SqlRexContext.class) {
            return;
        }
        Class<?> parameterType = parameterTypes[1];
        if (!SqlNode.class.isAssignableFrom(parameterType)) {
            return;
        }
        this.map.put(parameterType, (cx, call) -> {
            try {
                RexNode result = (RexNode)method.invoke((Object)this, cx, call);
                return Objects.requireNonNull(result, () -> "null result from " + method + " for call " + call);
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                throw new RuntimeException("while converting " + call, e);
            }
        });
    }

    @RequiresNonNull(value={"map"})
    private void registerOpTypeMethod(@UnderInitialization ReflectiveConvertletTable this, Method method) {
        if (!Modifier.isPublic(method.getModifiers())) {
            return;
        }
        if (!method.getName().startsWith("convert")) {
            return;
        }
        if (!RexNode.class.isAssignableFrom(method.getReturnType())) {
            return;
        }
        Class<?>[] parameterTypes = method.getParameterTypes();
        if (parameterTypes.length != 3) {
            return;
        }
        if (parameterTypes[0] != SqlRexContext.class) {
            return;
        }
        Class<?> opClass = parameterTypes[1];
        if (!SqlOperator.class.isAssignableFrom(opClass)) {
            return;
        }
        Class<?> parameterType = parameterTypes[2];
        if (!SqlCall.class.isAssignableFrom(parameterType)) {
            return;
        }
        this.map.put(opClass, (cx, call) -> {
            try {
                RexNode result = (RexNode)method.invoke((Object)this, cx, call.getOperator(), call);
                return Objects.requireNonNull(result, () -> "null result from " + method + " for call " + call);
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                throw new RuntimeException("while converting " + call, e);
            }
        });
    }

    @Override
    public @Nullable SqlRexConvertlet get(SqlCall call) {
        Class<?> clazz;
        SqlOperator op = call.getOperator();
        SqlRexConvertlet convertlet = (SqlRexConvertlet)this.map.get(op);
        if (convertlet != null) {
            return convertlet;
        }
        for (clazz = op.getClass(); clazz != null; clazz = clazz.getSuperclass()) {
            convertlet = (SqlRexConvertlet)this.map.get(clazz);
            if (convertlet == null) continue;
            return convertlet;
        }
        for (clazz = call.getClass(); clazz != null; clazz = clazz.getSuperclass()) {
            convertlet = (SqlRexConvertlet)this.map.get(clazz);
            if (convertlet == null) continue;
            return convertlet;
        }
        return null;
    }

    protected void registerOp(@UnderInitialization ReflectiveConvertletTable this, SqlOperator op, SqlRexConvertlet convertlet) {
        this.map.put(op, convertlet);
    }

    protected void addAlias(@UnderInitialization ReflectiveConvertletTable this, SqlOperator alias, SqlOperator target) {
        this.map.put(alias, (cx, call) -> {
            Preconditions.checkArgument((call.getOperator() == alias ? 1 : 0) != 0, (Object)"call to wrong operator");
            SqlCall newCall = target.createCall(SqlParserPos.ZERO, call.getOperandList());
            cx.getValidator().setValidatedNodeType(newCall, cx.getValidator().getValidatedNodeType(call));
            return cx.convertExpression(newCall);
        });
    }
}

