/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.tool;

import java.io.File;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.xml.bind.DatatypeConverter;
import lombok.Generated;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.kylin.common.KapConfig;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.exception.KylinTimeoutException;
import org.apache.kylin.common.util.AddressUtil;
import org.apache.kylin.common.util.ClassUtil;
import org.apache.kylin.common.util.CliCommandExecutor;
import org.apache.kylin.common.util.ExecutableApplication;
import org.apache.kylin.common.util.ExecutorServiceUtil;
import org.apache.kylin.common.util.OptionBuilder;
import org.apache.kylin.common.util.OptionsHelper;
import org.apache.kylin.common.util.RandomUtil;
import org.apache.kylin.common.util.TimeZoneUtils;
import org.apache.kylin.common.util.ZipFileUtils;
import org.apache.kylin.guava30.shaded.common.base.Preconditions;
import org.apache.kylin.guava30.shaded.common.collect.Lists;
import org.apache.kylin.job.dao.ExecutablePO;
import org.apache.kylin.job.execution.AbstractExecutable;
import org.apache.kylin.job.execution.DefaultExecutable;
import org.apache.kylin.metadata.cube.model.IndexPlan;
import org.apache.kylin.metadata.cube.model.NIndexPlanManager;
import org.apache.kylin.metadata.project.NProjectManager;
import org.apache.kylin.metadata.query.QueryHistory;
import org.apache.kylin.query.util.ExtractFactory;
import org.apache.kylin.query.util.ILogExtractor;
import org.apache.kylin.rest.cluster.ClusterManager;
import org.apache.kylin.rest.response.ServerInfoResponse;
import org.apache.kylin.rest.util.SpringContext;
import org.apache.kylin.tool.AsyncTaskTool;
import org.apache.kylin.tool.AuditLogTool;
import org.apache.kylin.tool.CommonInfoTool;
import org.apache.kylin.tool.ConfTool;
import org.apache.kylin.tool.DiagClientTool;
import org.apache.kylin.tool.DiagK8sTool;
import org.apache.kylin.tool.DiagSubTaskInfo;
import org.apache.kylin.tool.FavoriteRuleTool;
import org.apache.kylin.tool.InfluxDBTool;
import org.apache.kylin.tool.JStackTool;
import org.apache.kylin.tool.JobDiagInfoTool;
import org.apache.kylin.tool.JobInfoTool;
import org.apache.kylin.tool.KylinLogTool;
import org.apache.kylin.tool.MetadataTool;
import org.apache.kylin.tool.QueryDiagInfoTool;
import org.apache.kylin.tool.QueryHistoryOffsetTool;
import org.apache.kylin.tool.RecCandidateTool;
import org.apache.kylin.tool.StreamingJobDiagInfoTool;
import org.apache.kylin.tool.StreamingSparkLogTool;
import org.apache.kylin.tool.SystemUsageTool;
import org.apache.kylin.tool.YarnApplicationTool;
import org.apache.kylin.tool.constant.DiagSubTaskEnum;
import org.apache.kylin.tool.constant.StageEnum;
import org.apache.kylin.tool.obf.IpObfuscator;
import org.apache.kylin.tool.obf.KylinConfObfuscator;
import org.apache.kylin.tool.obf.MappingRecorder;
import org.apache.kylin.tool.obf.ObfLevel;
import org.apache.kylin.tool.obf.ResultRecorder;
import org.apache.kylin.tool.restclient.RestClient;
import org.apache.kylin.tool.util.DiagnosticFilesChecker;
import org.apache.kylin.tool.util.HashFunction;
import org.apache.kylin.tool.util.ServerInfoUtil;
import org.apache.kylin.tool.util.ToolUtil;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpHeaders;

public abstract class AbstractInfoExtractorTool
extends ExecutableApplication {
    public static final String SLASH = "/";
    public static final String TRUE = "true";
    public static final String FALSE = "false";
    public static final String OPT_COMPRESS = "-compress";
    public static final String OPT_PROJECT = "-project";
    public static final String OPT_DIR = "-dir";
    static final Option OPTION_DEST = OptionBuilder.getInstance().withArgName("destDir").hasArg().isRequired(true).withDescription("specify the dest dir to save the related information").create("destDir");
    static final Option OPTION_START_TIME = OptionBuilder.getInstance().withArgName("startTime").hasArg().isRequired(false).withDescription("specify the start of time range to extract logs. ").create("startTime");
    static final Option OPTION_END_TIME = OptionBuilder.getInstance().withArgName("endTime").hasArg().isRequired(false).withDescription("specify the end of time range to extract logs. ").create("endTime");
    static final Option OPTION_CURRENT_TIME = OptionBuilder.getInstance().withArgName("currentTime").hasArg().isRequired(false).withDescription("specify the current of time from client to fix diff between client and server and timezone problem. ").create("currentTime");
    static final Option OPTION_COMPRESS = OptionBuilder.getInstance().withArgName("compress").hasArg().isRequired(false).withDescription("specify whether to compress the output with zip. Default true.").create("compress");
    static final Option OPTION_SUBMODULE = OptionBuilder.getInstance().withArgName("submodule").hasArg().isRequired(false).withDescription("specify whether this is a submodule of other CLI tool").create("submodule");
    static final Option OPTION_SYSTEM_ENV = OptionBuilder.getInstance().withArgName("systemProp").hasArg().isRequired(false).withDescription("specify whether to include system env and properties to extract. Default false.").create("systemProp");
    static final Option OPTION_DIAGID = OptionBuilder.getInstance().withArgName("diagId").hasArg().isRequired(false).withDescription("Specify whether diag from web").create("diagId");
    static final Option OPTION_OBF_LEVEL = OptionBuilder.getInstance().withArgName("obfLevel").hasArg().isRequired(false).withDescription("specify obfuscate level of the diagnostic package: \nRAW means no obfuscate,\nOBF means obfuscate,\nDefault obfuscate level is OBF.").create("obfLevel");
    private static final Logger logger = LoggerFactory.getLogger((String)"diag");
    private static final Option OPTION_THREADS = OptionBuilder.getInstance().withArgName("threads").hasArg().isRequired(false).withDescription("Specify number of threads for parallel extraction.").create("threads");
    private static final String DEFAULT_PACKAGE_TYPE = "base";
    private static final String[] COMMIT_SHA1_FILES = new String[]{"commit_SHA1", "commit.sha1"};
    private static final int DEFAULT_PARALLEL_SIZE = 4;
    protected final Options options;
    protected ConcurrentHashMap<DiagSubTaskEnum, Long> taskStartTime;
    protected LinkedBlockingQueue<DiagSubTaskInfo> taskQueue;
    protected StageEnum stage = StageEnum.PREPARE;
    protected ScheduledExecutorService executorService;
    protected ScheduledExecutorService timerExecutorService;
    protected boolean mainTaskComplete;
    private String packageType;
    protected File exportDir;
    private KylinConfig kylinConfig;
    private KapConfig kapConfig;
    private String kylinHome;
    private CliCommandExecutor cmdExecutor;
    private boolean includeSystemEnv;

    public AbstractInfoExtractorTool() {
        this.options = new Options();
        this.options.addOption(OPTION_DEST);
        this.options.addOption(OPTION_COMPRESS);
        this.options.addOption(OPTION_SUBMODULE);
        this.options.addOption(OPTION_SYSTEM_ENV);
        this.options.addOption(OPTION_START_TIME);
        this.options.addOption(OPTION_END_TIME);
        this.options.addOption(OPTION_DIAGID);
        this.options.addOption(OPTION_OBF_LEVEL);
        this.packageType = DEFAULT_PACKAGE_TYPE;
        this.kylinConfig = KylinConfig.getInstanceFromEnv();
        this.kapConfig = KapConfig.wrap((KylinConfig)this.kylinConfig);
        this.kylinHome = KapConfig.getKylinHomeAtBestEffort().getAbsolutePath();
        this.cmdExecutor = this.kylinConfig.getCliCommandExecutor();
    }

    protected Options getOptions() {
        return this.options;
    }

    protected abstract void executeExtract(OptionsHelper var1, File var2) throws Exception;

    protected void execute(OptionsHelper optionsHelper) throws Exception {
        this.stage = StageEnum.PREPARE;
        TimeZoneUtils.setDefaultTimeZone((KylinConfig)this.kylinConfig);
        String exportDest = optionsHelper.getOptionValue(OPTION_DEST);
        boolean shouldCompress = this.getBooleanOption(optionsHelper, OPTION_COMPRESS, true);
        boolean submodule = this.getBooleanOption(optionsHelper, OPTION_SUBMODULE, false);
        this.includeSystemEnv = this.getBooleanOption(optionsHelper, OPTION_SYSTEM_ENV, false);
        if (this.isDiag()) {
            int threadsNum = this.getIntOption(optionsHelper, OPTION_THREADS, 4);
            this.executorService = Executors.newScheduledThreadPool(threadsNum);
            this.timerExecutorService = Executors.newScheduledThreadPool(2);
            this.taskQueue = new LinkedBlockingQueue();
            this.taskStartTime = new ConcurrentHashMap();
            if (this.isDiagFromWeb(optionsHelper)) {
                this.scheduleDiagProgress(optionsHelper.getOptionValue(OPTION_DIAGID));
            }
            logger.info("Start diagnosis info extraction in {} threads.", (Object)threadsNum);
        }
        Preconditions.checkArgument((!StringUtils.isEmpty((CharSequence)exportDest) ? 1 : 0) != 0, (Object)"destDir is not set, exit directly without extracting");
        if (!exportDest.endsWith(SLASH)) {
            exportDest = exportDest + SLASH;
        }
        String packageName = this.packageType.toLowerCase(Locale.ROOT) + "_" + new SimpleDateFormat("yyyy_MM_dd_HH_mm_ss", Locale.getDefault(Locale.Category.FORMAT)).format(new Date());
        if (!submodule) {
            exportDest = exportDest + packageName + SLASH;
        }
        this.exportDir = new File(exportDest);
        FileUtils.forceMkdir((File)this.exportDir);
        if (!submodule) {
            this.dumpBasicDiagInfo();
        }
        this.stage = StageEnum.EXTRACT;
        this.mainTaskComplete = false;
        this.executeExtract(optionsHelper, this.exportDir);
        this.mainTaskComplete = true;
        this.obfDiag(optionsHelper, this.exportDir);
        if (shouldCompress) {
            this.stage = StageEnum.COMPRESS;
            File tempZipFile = new File(RandomUtil.randomUUIDStr() + ".zip");
            ZipFileUtils.compressZipFile((String)this.exportDir.getAbsolutePath(), (String)tempZipFile.getAbsolutePath());
            FileUtils.cleanDirectory((File)this.exportDir);
            String sha256Sum = DatatypeConverter.printHexBinary((byte[])HashFunction.SHA256.checksum(tempZipFile));
            String packageFilename = StringUtils.join((Object[])new String[]{ToolUtil.getHostName(), this.getKylinConfig().getServerPort(), packageName, sha256Sum.substring(0, 6)}, (char)'_');
            File zipFile = new File(this.exportDir, packageFilename + ".zip");
            FileUtils.moveFile((File)tempZipFile, (File)zipFile);
            exportDest = zipFile.getAbsolutePath();
            this.exportDir = new File(exportDest);
        }
        this.stage = StageEnum.DONE;
        if (this.isDiagFromWeb(optionsHelper)) {
            this.reportDiagProgressImmediately(optionsHelper.getOptionValue(OPTION_DIAGID));
            ExecutorServiceUtil.forceShutdown((ExecutorService)this.timerExecutorService);
        }
    }

    String getObfMappingPath() {
        return KylinConfig.getKylinHome() + "/logs/obfuscation-mapping.json";
    }

    protected void obfDiag(OptionsHelper optionsHelper, File rootDir) throws IOException {
        logger.info("Start obf diag file.");
        ObfLevel obfLevel = ObfLevel.valueOf(this.kylinConfig.getDiagObfLevel());
        if (optionsHelper.hasOption(OPTION_OBF_LEVEL)) {
            obfLevel = ObfLevel.valueOf(optionsHelper.getOptionValue(OPTION_OBF_LEVEL));
        }
        logger.info("Obf level is {}.", (Object)obfLevel);
        try (MappingRecorder recorder = new MappingRecorder(null);){
            ResultRecorder resultRecorder = new ResultRecorder();
            KylinConfObfuscator kylinConfObfuscator = new KylinConfObfuscator(obfLevel, recorder, resultRecorder);
            kylinConfObfuscator.obfuscate(new File(rootDir, "conf"), file -> file.isFile() && file.getName().startsWith("kylin.properties"));
        }
        this.obfIpDiag(rootDir, obfLevel);
    }

    private void obfIpDiag(File rootDir, ObfLevel obfLevel) throws IOException {
        if (obfLevel != ObfLevel.OBF || !this.kylinConfig.isDiagIpObfEnabled()) {
            return;
        }
        logger.info("diag start obf ip");
        try (MappingRecorder recorder = new MappingRecorder(null);){
            ResultRecorder resultRecorder = new ResultRecorder();
            IpObfuscator ipObfuscator = new IpObfuscator(obfLevel, recorder, resultRecorder);
            ipObfuscator.obfuscate(rootDir, null);
        }
        logger.info("diag end obf ip");
    }

    private boolean isDiag() {
        return this instanceof DiagClientTool || this instanceof JobDiagInfoTool || this instanceof StreamingJobDiagInfoTool || this instanceof QueryDiagInfoTool || this instanceof DiagK8sTool;
    }

    private boolean isDiagFromWeb(OptionsHelper optionsHelper) {
        return this.isDiag() && optionsHelper.hasOption(OPTION_DIAGID);
    }

    private void scheduleDiagProgress(String diagId) {
        long interval = 3L;
        int serverPort = Integer.parseInt(this.getKylinConfig().getServerPort());
        RestClient restClient = new RestClient("127.0.0.1", serverPort, null, null);
        this.timerExecutorService.scheduleWithFixedDelay(() -> restClient.updateDiagProgress(diagId, this.getStage(), this.getProgress(), System.currentTimeMillis()), 0L, interval, TimeUnit.SECONDS);
    }

    private void reportDiagProgressImmediately(String diagId) {
        int retry = 3;
        int serverPort = Integer.parseInt(this.getKylinConfig().getServerPort());
        RestClient restClient = new RestClient("127.0.0.1", serverPort, null, null);
        boolean updateSuccess = false;
        while (retry-- > 0 && !updateSuccess) {
            updateSuccess = restClient.updateDiagProgress(diagId, this.getStage(), this.getProgress(), System.currentTimeMillis());
        }
    }

    protected void exportSparkLog(File exportDir, long startTime, long endTime, File recordTime, String queryId) {
        QueryHistory query = new QueryDiagInfoTool().getQueryByQueryId(queryId);
        String hostName = query == null ? null : AddressUtil.getServerInfo((String)query.getQueryHistoryInfo().getHostName(), (String)query.getQueryHistoryInfo().getPort());
        Future<?> sparkLogTask = this.executorService.submit(() -> {
            this.recordTaskStartTime(DiagSubTaskEnum.SPARK_LOGS);
            if (StringUtils.isEmpty((CharSequence)queryId)) {
                KylinLogTool.extractFullDiagSparderLog(exportDir, startTime, endTime);
            } else {
                KylinLogTool.extractQueryDiagSparderLog(exportDir, startTime, endTime);
            }
            this.recordTaskExecutorTimeToFile(DiagSubTaskEnum.SPARK_LOGS, recordTime);
        });
        this.scheduleTimeoutTask(sparkLogTask, DiagSubTaskEnum.SPARK_LOGS);
        Future<?> sparderHistoryTask = this.executorService.submit(() -> {
            this.recordTaskStartTime(DiagSubTaskEnum.SPARDER_HISTORY);
            ILogExtractor extractTool = ExtractFactory.create();
            this.tryRollUpEventLog(query);
            KylinLogTool.extractSparderEventLog(exportDir, startTime, endTime, this.getKapConfig().getSparkConf(), extractTool, hostName);
            this.recordTaskExecutorTimeToFile(DiagSubTaskEnum.SPARDER_HISTORY, recordTime);
        });
        this.scheduleTimeoutTask(sparderHistoryTask, DiagSubTaskEnum.SPARDER_HISTORY);
    }

    public void tryRollUpEventLog(QueryHistory queryHistory) {
        int retry = 3;
        ArrayList restClients = Lists.newArrayList();
        if (KylinConfig.getInstanceFromEnv().getMicroServiceMode() != null && queryHistory == null) {
            ClusterManager clusterManager = (ClusterManager)SpringContext.getApplicationContext().getBean(ClusterManager.class);
            for (ServerInfoResponse queryServer : clusterManager.getQueryServers()) {
                RestClient restClient = new RestClient(queryServer.getHost());
                restClients.add(restClient);
            }
        } else if (queryHistory != null) {
            RestClient restClient = new RestClient(queryHistory.getHostName());
            restClients.add(restClient);
        } else {
            int serverPort = Integer.parseInt(this.getKylinConfig().getServerPort());
            RestClient restClient = new RestClient("127.0.0.1", serverPort, null, null);
            restClients.add(restClient);
        }
        while (retry-- > 0 && !restClients.isEmpty()) {
            ArrayList successClient = Lists.newArrayList();
            for (RestClient restClient : restClients) {
                if (!restClient.rollUpEventLog()) continue;
                successClient.add(restClient);
            }
            restClients.removeAll(successClient);
        }
    }

    public void extractCommitFile(File exportDir) {
        try {
            for (String commitSHA1File : COMMIT_SHA1_FILES) {
                File commitFile = new File(this.kylinHome, commitSHA1File);
                if (!commitFile.exists()) continue;
                Files.copy(commitFile.toPath(), new File(exportDir, commitFile.getName()).toPath(), new CopyOption[0]);
            }
        }
        catch (IOException e) {
            logger.warn("Failed to copy commit_SHA1 file.", (Throwable)e);
        }
    }

    public void dumpSystemEnv() throws IOException {
        StringBuilder sb = new StringBuilder("System env:").append("\n");
        Map<String, String> systemEnv = System.getenv();
        for (Map.Entry<String, String> entry : systemEnv.entrySet()) {
            sb.append(entry.getKey()).append("=").append(entry.getValue()).append("\n");
        }
        sb.append("System properties:").append("\n");
        Properties systemProperties = System.getProperties();
        for (String key : systemProperties.stringPropertyNames()) {
            sb.append(key).append("=").append(systemProperties.getProperty(key)).append("\n");
        }
        FileUtils.writeStringToFile((File)new File(this.exportDir, "system_env"), (String)sb.toString());
    }

    private void dumpBasicDiagInfo() throws Exception {
        this.extractCommitFile(this.exportDir);
        File kylinEnv = new File(this.exportDir, "kylin_env");
        FileUtils.writeStringToFile((File)kylinEnv, (String)ServerInfoUtil.getKylinClientInformation());
        if (this.includeSystemEnv) {
            this.dumpSystemEnv();
        }
    }

    protected void addFile(File srcFile, File destDir) {
        logger.info("copy file: {}", (Object)srcFile.getName());
        try {
            FileUtils.forceMkdir((File)destDir);
        }
        catch (IOException e) {
            logger.error("Can not create" + destDir, (Throwable)e);
        }
        File destFile = new File(destDir, srcFile.getName());
        String copyCmd = String.format(Locale.ROOT, "cp -r %s %s", srcFile.getAbsolutePath(), destFile.getAbsolutePath());
        logger.info("The command is: {}", (Object)copyCmd);
        try {
            this.cmdExecutor.execute(copyCmd, null);
        }
        catch (Exception e) {
            logger.debug("Failed to execute copyCmd", (Throwable)e);
        }
    }

    protected void addShellOutput(String cmd, File destDir, String filename) {
        this.addShellOutput(cmd, destDir, filename, false);
    }

    protected void addShellOutput(String cmd, File destDir, String filename, boolean append) {
        this.addShellOutput(cmd, destDir, filename, append, false);
    }

    protected void addShellOutput(String cmd, File destDir, String filename, boolean append, boolean errorDebug) {
        if (null == this.cmdExecutor) {
            logger.error("Failed to run cmd because cmdExecutor is null: {}", (Object)cmd);
            return;
        }
        try {
            if (null == destDir) {
                destDir = this.exportDir;
            }
            FileUtils.forceMkdir((File)destDir);
            String output = this.cmdExecutor.execute(cmd, null).getCmd();
            FileUtils.writeStringToFile((File)new File(destDir, filename), (String)output, (boolean)append);
        }
        catch (Exception e) {
            if (errorDebug) {
                logger.debug("Failed to run command: {}", (Object)cmd, (Object)e);
            }
            logger.error("Failed to run command: {}", (Object)cmd, (Object)e);
        }
    }

    public String getStringOption(OptionsHelper optionsHelper, Option option, String defaultVal) {
        return optionsHelper.hasOption(option) ? optionsHelper.getOptionValue(option) : defaultVal;
    }

    public boolean getBooleanOption(OptionsHelper optionsHelper, Option option, boolean defaultVal) {
        return optionsHelper.hasOption(option) ? Boolean.parseBoolean(optionsHelper.getOptionValue(option)) : defaultVal;
    }

    public int getIntOption(OptionsHelper optionsHelper, Option option, int defaultVal) {
        return optionsHelper.hasOption(option) ? Integer.parseInt(optionsHelper.getOptionValue(option)) : defaultVal;
    }

    public long getLongOption(OptionsHelper optionsHelper, Option option, long defaultVal) {
        return optionsHelper.hasOption(option) ? Long.parseLong(optionsHelper.getOptionValue(option)) : defaultVal;
    }

    public String getStage() {
        return this.stage.toString();
    }

    public float getProgress() {
        if (this.executorService == null || this.getStage().equals("PREPARE")) {
            return 0.0f;
        }
        if (this.getStage().equals("DONE")) {
            return 1.0f;
        }
        long totalTaskCount = ((ThreadPoolExecutor)((Object)this.executorService)).getTaskCount() + 1L;
        long completedTaskCount = ((ThreadPoolExecutor)((Object)this.executorService)).getCompletedTaskCount() + (long)(this.mainTaskComplete ? 1 : 0);
        return (float)completedTaskCount / (float)totalTaskCount * 0.9f;
    }

    protected void awaitDiagPackageTermination(long timeout) throws InterruptedException {
        try {
            if (this.executorService != null && !this.executorService.awaitTermination(timeout, TimeUnit.SECONDS)) {
                ExecutorServiceUtil.forceShutdown((ExecutorService)this.executorService);
                throw new KylinTimeoutException("The query exceeds the set time limit of " + KylinConfig.getInstanceFromEnv().getQueryTimeoutSeconds() + "s. Current step: Diagnosis packaging. ");
            }
        }
        catch (InterruptedException e) {
            ExecutorServiceUtil.forceShutdown((ExecutorService)this.executorService);
            logger.debug("diagnosis main wait for all sub task exit...");
            long start = System.currentTimeMillis();
            boolean allSubTaskExit = this.executorService.awaitTermination(600L, TimeUnit.SECONDS);
            logger.warn("diagnosis main task quit by interrupt , all sub task exit ? {} , waiting for {} ms ", (Object)allSubTaskExit, (Object)(System.currentTimeMillis() - start));
            throw e;
        }
    }

    protected void dumpMetadata(String[] metaToolArgs, File recordTime) {
        Future<?> metadataTask = this.executorService.submit(() -> {
            this.recordTaskStartTime(DiagSubTaskEnum.METADATA);
            try {
                File metaDir = new File(this.exportDir, "metadata");
                FileUtils.forceMkdir((File)metaDir);
                new MetadataTool().execute(metaToolArgs);
            }
            catch (Exception e) {
                logger.error("Failed to extract metadata.", (Throwable)e);
            }
            this.recordTaskExecutorTimeToFile(DiagSubTaskEnum.METADATA, recordTime);
        });
        this.scheduleTimeoutTask(metadataTask, DiagSubTaskEnum.METADATA);
    }

    protected void dumpStreamingSparkLog(String[] sparkToolArgs, File recordTime) {
        Future<?> metadataTask = this.executorService.submit(() -> {
            this.recordTaskStartTime(DiagSubTaskEnum.SPARK_STREAMING_LOGS);
            try {
                new StreamingSparkLogTool().execute(sparkToolArgs);
            }
            catch (Exception e) {
                logger.error("Failed to extract streaming spark log.", (Throwable)e);
            }
            this.recordTaskExecutorTimeToFile(DiagSubTaskEnum.SPARK_STREAMING_LOGS, recordTime);
        });
        this.scheduleTimeoutTask(metadataTask, DiagSubTaskEnum.SPARK_STREAMING_LOGS);
    }

    protected void exportRecCandidate(String project, String modelId, File exportDir, boolean full, File recordTime) {
        Future<?> recTask = this.executorService.submit(() -> {
            this.recordTaskStartTime(DiagSubTaskEnum.REC_CANDIDATE);
            try {
                File recDir = new File(exportDir, "rec_candidate");
                FileUtils.forceMkdir((File)recDir);
                if (full) {
                    new RecCandidateTool().extractFull(recDir);
                } else {
                    new RecCandidateTool().extractModel(project, modelId, recDir);
                }
            }
            catch (Exception e) {
                logger.error("Failed to extract rec candidate.", (Throwable)e);
            }
            this.recordTaskExecutorTimeToFile(DiagSubTaskEnum.REC_CANDIDATE, recordTime);
        });
        this.scheduleTimeoutTask(recTask, DiagSubTaskEnum.REC_CANDIDATE);
    }

    protected void exportJobInfo(String project, String jobId, File recordTime) {
        this.exportJobInfo(project, jobId, -1L, -1L, recordTime);
    }

    protected void exportJobInfo(long startTime, long endTime, File recordTime) {
        this.exportJobInfo(null, null, startTime, endTime, recordTime);
    }

    private void exportJobInfo(String project, String jobId, long startTime, long endTime, File recordTime) {
        Future<?> jobTask = this.executorService.submit(() -> {
            this.recordTaskStartTime(DiagSubTaskEnum.JOB_INFO);
            try {
                File jobDir = new File(this.exportDir, "job_info");
                FileUtils.forceMkdir((File)jobDir);
                JobInfoTool tool = new JobInfoTool();
                if (jobId != null) {
                    tool.extractJob(jobDir, project, jobId);
                } else {
                    tool.extractFull(jobDir, startTime, endTime);
                }
                tool.extractJobLock(jobDir);
            }
            catch (Exception e) {
                logger.error("Failed to extract job info.", (Throwable)e);
            }
            this.recordTaskExecutorTimeToFile(DiagSubTaskEnum.JOB_INFO, recordTime);
        });
        this.scheduleTimeoutTask(jobTask, DiagSubTaskEnum.JOB_INFO);
    }

    protected void exportFavoriteRule(String project, File recordTime) {
        Future<?> favoriteRuleTask = this.executorService.submit(() -> {
            this.recordTaskStartTime(DiagSubTaskEnum.FAVORITE_RULE);
            try {
                File favoriteRuleDir = new File(this.exportDir, "favorite_rule");
                FileUtils.forceMkdir((File)favoriteRuleDir);
                FavoriteRuleTool tool = new FavoriteRuleTool();
                if (project != null) {
                    tool.extractProject(favoriteRuleDir, project);
                } else {
                    tool.extractFull(favoriteRuleDir);
                }
            }
            catch (Exception e) {
                logger.error("Failed to extract favorite rules.", (Throwable)e);
            }
            this.recordTaskExecutorTimeToFile(DiagSubTaskEnum.FAVORITE_RULE, recordTime);
        });
        this.scheduleTimeoutTask(favoriteRuleTask, DiagSubTaskEnum.FAVORITE_RULE);
    }

    protected void exportAsyncTask(String project, File recordTime) {
        Future<?> asyncTaskTask = this.executorService.submit(() -> {
            this.recordTaskStartTime(DiagSubTaskEnum.ASYNC_TASK);
            try {
                File asyncTaskDir = new File(this.exportDir, "async_task");
                FileUtils.forceMkdir((File)asyncTaskDir);
                AsyncTaskTool tool = new AsyncTaskTool();
                if (project != null) {
                    tool.extractProject(asyncTaskDir, project);
                } else {
                    tool.extractFull(asyncTaskDir);
                }
            }
            catch (Exception e) {
                logger.error("Failed to extract async task.", (Throwable)e);
            }
            this.recordTaskExecutorTimeToFile(DiagSubTaskEnum.ASYNC_TASK, recordTime);
        });
        this.scheduleTimeoutTask(asyncTaskTask, DiagSubTaskEnum.ASYNC_TASK);
    }

    public void exportQueryHistoryOffset(String project, File recordTime) {
        Future<?> queryHistoryOffsetTask = this.executorService.submit(() -> {
            this.recordTaskStartTime(DiagSubTaskEnum.QUERY_HISTORY_OFFSET);
            try {
                File queryHistoryOffsetDir = new File(this.exportDir, "query_history_offset");
                FileUtils.forceMkdir((File)queryHistoryOffsetDir);
                QueryHistoryOffsetTool tool = new QueryHistoryOffsetTool();
                if (project != null) {
                    tool.extractProject(queryHistoryOffsetDir, project);
                } else {
                    tool.extractFull(queryHistoryOffsetDir);
                }
            }
            catch (Exception e) {
                logger.error("Failed to extract query history offset.", (Throwable)e);
            }
            this.recordTaskExecutorTimeToFile(DiagSubTaskEnum.QUERY_HISTORY_OFFSET, recordTime);
        });
        this.scheduleTimeoutTask(queryHistoryOffsetTask, DiagSubTaskEnum.QUERY_HISTORY_OFFSET);
    }

    protected void exportKgLogs(File exportDir, long startTime, long endTime, File recordTime) {
        Future<?> kgLogTask = this.executorService.submit(() -> {
            this.recordTaskStartTime(DiagSubTaskEnum.KG_LOGS);
            KylinLogTool.extractKGLogs(exportDir, startTime, endTime);
            this.recordTaskExecutorTimeToFile(DiagSubTaskEnum.KG_LOGS, recordTime);
        });
        this.scheduleTimeoutTask(kgLogTask, DiagSubTaskEnum.KG_LOGS);
    }

    protected void exportAuditLog(String[] auditLogToolArgs, File recordTime) {
        Future<?> auditTask = this.executorService.submit(() -> {
            this.recordTaskStartTime(DiagSubTaskEnum.AUDIT_LOG);
            try {
                new AuditLogTool(KylinConfig.getInstanceFromEnv()).execute(auditLogToolArgs);
            }
            catch (Exception e) {
                logger.error("Failed to extract audit log.", (Throwable)e);
            }
            this.recordTaskExecutorTimeToFile(DiagSubTaskEnum.AUDIT_LOG, recordTime);
        });
        this.scheduleTimeoutTask(auditTask, DiagSubTaskEnum.AUDIT_LOG);
    }

    protected void exportInfluxDBMetrics(File exportDir, File recordTime) {
        Future<?> metricsTask = this.executorService.submit(() -> {
            this.recordTaskStartTime(DiagSubTaskEnum.SYSTEM_METRICS);
            InfluxDBTool.dumpInfluxDBMetrics(exportDir);
            this.recordTaskExecutorTimeToFile(DiagSubTaskEnum.SYSTEM_METRICS, recordTime);
        });
        this.scheduleTimeoutTask(metricsTask, DiagSubTaskEnum.SYSTEM_METRICS);
        Future<?> monitorTask = this.executorService.submit(() -> {
            this.recordTaskStartTime(DiagSubTaskEnum.MONITOR_METRICS);
            InfluxDBTool.dumpInfluxDBMonitorMetrics(exportDir);
            this.recordTaskExecutorTimeToFile(DiagSubTaskEnum.MONITOR_METRICS, recordTime);
        });
        this.scheduleTimeoutTask(monitorTask, DiagSubTaskEnum.MONITOR_METRICS);
    }

    protected void exportClient(File recordTime) {
        Future<?> clientTask = this.executorService.submit(() -> {
            this.recordTaskStartTime(DiagSubTaskEnum.CLIENT);
            CommonInfoTool.exportClientInfo(this.exportDir);
            this.recordTaskExecutorTimeToFile(DiagSubTaskEnum.CLIENT, recordTime);
        });
        this.scheduleTimeoutTask(clientTask, DiagSubTaskEnum.CLIENT);
    }

    protected void exportJstack(File recordTime) {
        Future<?> jstackTask = this.executorService.submit(() -> {
            this.recordTaskStartTime(DiagSubTaskEnum.JSTACK);
            JStackTool.extractJstack(this.exportDir);
            this.recordTaskExecutorTimeToFile(DiagSubTaskEnum.JSTACK, recordTime);
        });
        this.scheduleTimeoutTask(jstackTask, DiagSubTaskEnum.JSTACK);
    }

    protected void exportSystemUsageInfo(File recordTime, long startTime, long endTime) {
        Future<?> confTask = this.executorService.submit(() -> {
            this.recordTaskStartTime(DiagSubTaskEnum.SYSTEM_USAGE);
            SystemUsageTool.extractUseInfo(this.exportDir, startTime, endTime);
            this.recordTaskExecutorTimeToFile(DiagSubTaskEnum.SYSTEM_USAGE, recordTime);
        });
        this.scheduleTimeoutTask(confTask, DiagSubTaskEnum.SYSTEM_USAGE);
    }

    protected void exportLogFromLoki(File exportDir, Long startTime, Long endTime, List<String> instances, File recordTime) {
        Future<?> logTask = this.executorService.submit(() -> {
            this.recordTaskStartTime(DiagSubTaskEnum.LOG);
            KylinLogTool.extractKylinLogFromLoki(exportDir, startTime, endTime, instances);
            this.recordTaskExecutorTimeToFile(DiagSubTaskEnum.LOG, recordTime);
        });
        this.scheduleTimeoutTask(logTask, DiagSubTaskEnum.LOG);
    }

    protected void exportLogFromWorkingDir(File exportDir, List<String> instances, File recordTime) {
        Future<?> logTask = this.executorService.submit(() -> {
            this.recordTaskStartTime(DiagSubTaskEnum.LOG_ON_WORKING_DIR);
            KylinLogTool.extractLogFromWorkingDir(exportDir, instances);
            this.recordTaskExecutorTimeToFile(DiagSubTaskEnum.LOG_ON_WORKING_DIR, recordTime);
        });
        this.scheduleTimeoutTask(logTask, DiagSubTaskEnum.LOG_ON_WORKING_DIR);
    }

    protected void exportK8sConf(HttpHeaders headers, File exportDir, File recordTime, String serverId) {
        Future<?> confTask = this.executorService.submit(() -> {
            this.recordTaskStartTime(DiagSubTaskEnum.CONF);
            ConfTool.extractK8sConf(headers, exportDir, serverId);
            this.recordTaskExecutorTimeToFile(DiagSubTaskEnum.CONF, recordTime);
        });
        this.scheduleTimeoutTask(confTask, DiagSubTaskEnum.CONF);
    }

    protected void exportConf(File exportDir, File recordTime, boolean includeConf, boolean includeBin) {
        if (includeConf) {
            Future<?> confTask = this.executorService.submit(() -> {
                this.recordTaskStartTime(DiagSubTaskEnum.CONF);
                ConfTool.extractConf(exportDir);
                this.recordTaskExecutorTimeToFile(DiagSubTaskEnum.CONF, recordTime);
            });
            this.scheduleTimeoutTask(confTask, DiagSubTaskEnum.CONF);
        }
        Future<?> hadoopConfTask = this.executorService.submit(() -> {
            this.recordTaskStartTime(DiagSubTaskEnum.HADOOP_CONF);
            ConfTool.extractHadoopConf(exportDir);
            this.recordTaskExecutorTimeToFile(DiagSubTaskEnum.HADOOP_CONF, recordTime);
        });
        this.scheduleTimeoutTask(hadoopConfTask, DiagSubTaskEnum.HADOOP_CONF);
        if (includeBin) {
            Future<?> binTask = this.executorService.submit(() -> {
                this.recordTaskStartTime(DiagSubTaskEnum.BIN);
                ConfTool.extractBin(exportDir);
                this.recordTaskExecutorTimeToFile(DiagSubTaskEnum.BIN, recordTime);
            });
            this.scheduleTimeoutTask(binTask, DiagSubTaskEnum.BIN);
        }
        Future<?> hadoopEnvTask = this.executorService.submit(() -> {
            this.recordTaskStartTime(DiagSubTaskEnum.HADOOP_ENV);
            CommonInfoTool.exportHadoopEnv(exportDir);
            this.recordTaskExecutorTimeToFile(DiagSubTaskEnum.HADOOP_ENV, recordTime);
        });
        this.scheduleTimeoutTask(hadoopEnvTask, DiagSubTaskEnum.HADOOP_ENV);
        Future<?> catcalogTask = this.executorService.submit(() -> {
            this.recordTaskStartTime(DiagSubTaskEnum.CATALOG_INFO);
            CommonInfoTool.exportKylinHomeDir(exportDir);
            this.recordTaskExecutorTimeToFile(DiagSubTaskEnum.CATALOG_INFO, recordTime);
        });
        this.scheduleTimeoutTask(catcalogTask, DiagSubTaskEnum.CATALOG_INFO);
    }

    protected void scheduleTimeoutTask(Future task, DiagSubTaskEnum taskEnum) {
        if (!KylinConfig.getInstanceFromEnv().getDiagTaskTimeoutBlackList().contains((Object)taskEnum.name())) {
            this.taskQueue.add(new DiagSubTaskInfo(task, taskEnum));
            logger.info("Add {} to task queue.", (Object)taskEnum);
        }
    }

    protected void executeTimeoutTask(LinkedBlockingQueue<DiagSubTaskInfo> tasks) {
        this.timerExecutorService.submit(() -> {
            while (!tasks.isEmpty()) {
                DiagSubTaskInfo info = (DiagSubTaskInfo)tasks.poll();
                Future task = info.getTask();
                DiagSubTaskEnum taskEnum = info.getTaskEnum();
                logger.info("Timeout task {} start at {}.", (Object)taskEnum, (Object)System.currentTimeMillis());
                Long startTime = this.taskStartTime.get((Object)taskEnum);
                if (startTime == null) {
                    startTime = System.currentTimeMillis();
                    logger.info("Task {} start time is not set now, choose current time {} as task start time.", (Object)taskEnum, (Object)startTime);
                }
                long endTime = startTime + KylinConfig.getInstanceFromEnv().getDiagTaskTimeout() * 1000L;
                long waitTime = endTime - System.currentTimeMillis();
                logger.info("Timeout task {} wait time is {}ms.", (Object)taskEnum, (Object)waitTime);
                if (waitTime > 0L) {
                    try {
                        task.get(waitTime, TimeUnit.MILLISECONDS);
                    }
                    catch (Exception e) {
                        logger.warn(String.format(Locale.ROOT, "Task %s call get function.", task), (Throwable)e);
                    }
                }
                if (task.cancel(true)) {
                    logger.error("Cancel '{}' task.", (Object)taskEnum);
                }
                logger.info("Timeout task {} exit at {}.", (Object)taskEnum, (Object)System.currentTimeMillis());
            }
        });
    }

    protected void recordTaskStartTime(DiagSubTaskEnum subTask) {
        logger.info("Start to dump {}.", (Object)subTask);
        this.taskStartTime.put(subTask, System.currentTimeMillis());
    }

    protected void recordTaskExecutorTimeToFile(DiagSubTaskEnum subTask, File file) {
        long startTime = this.taskStartTime.get((Object)subTask);
        DiagnosticFilesChecker.writeMsgToFile(subTask.name(), System.currentTimeMillis() - startTime, file);
    }

    public long getDefaultStartTime() {
        return DateTime.now().minusDays(this.getKapConfig().getExtractionStartTimeDays() - 1).withTimeAtStartOfDay().getMillis();
    }

    public long getDefaultEndTime() {
        return DateTime.now().plusDays(1).minus(1L).withTimeAtStartOfDay().getMillis();
    }

    public void exportJobSparkLog(File exportDir, File recordTime, String project, String jobId, ExecutablePO job) {
        Future<?> sparkLogTask = this.executorService.submit(() -> {
            this.recordTaskStartTime(DiagSubTaskEnum.SPARK_LOGS);
            KylinLogTool.extractSparkLog(exportDir, project, jobId);
            this.recordTaskExecutorTimeToFile(DiagSubTaskEnum.SPARK_LOGS, recordTime);
        });
        this.scheduleTimeoutTask(sparkLogTask, DiagSubTaskEnum.SPARK_LOGS);
        Future<?> eventLogTask = this.executorService.submit(() -> {
            try {
                if (ClassUtil.forName((String)job.getType(), AbstractExecutable.class).newInstance() instanceof DefaultExecutable) {
                    this.recordTaskStartTime(DiagSubTaskEnum.JOB_EVENTLOGS);
                    YarnApplicationTool yarnApplicationTool = new YarnApplicationTool();
                    Set<String> appIds = yarnApplicationTool.extract(project, jobId);
                    KylinConfig config = this.getConfigForModelOrProjectLevel(job.getTargetModelId(), project);
                    Map sparkConf = config.getSparkConfigOverride();
                    KylinLogTool.extractJobEventLogs(exportDir, appIds, sparkConf);
                    this.recordTaskExecutorTimeToFile(DiagSubTaskEnum.JOB_EVENTLOGS, recordTime);
                }
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
                logger.error("Class <{}> not found or cannot be created.", (Object)job.getType(), (Object)e);
            }
        });
        this.scheduleTimeoutTask(eventLogTask, DiagSubTaskEnum.JOB_EVENTLOGS);
        Future<?> jobTmpTask = this.executorService.submit(() -> {
            this.recordTaskStartTime(DiagSubTaskEnum.JOB_TMP);
            KylinLogTool.extractJobTmp(exportDir, project, jobId);
            this.recordTaskExecutorTimeToFile(DiagSubTaskEnum.JOB_TMP, recordTime);
        });
        this.scheduleTimeoutTask(jobTmpTask, DiagSubTaskEnum.JOB_TMP);
    }

    protected KylinConfig getConfigForModelOrProjectLevel(String modelId, String project) {
        KylinConfig config = null;
        IndexPlan indexPlan = NIndexPlanManager.getInstance((KylinConfig)this.getKylinConfig(), (String)project).getIndexPlan(modelId);
        if (indexPlan != null) {
            config = indexPlan.getConfig();
        }
        if (config == null) {
            config = NProjectManager.getProjectConfig((String)project);
        }
        return config;
    }

    protected void exportCandidateLog(File exportDir, File recordTime, long startTime, long endTime) {
        Future<?> candidateLogTask = this.executorService.submit(() -> {
            this.recordTaskStartTime(DiagSubTaskEnum.CANDIDATE_LOG);
            List projects = NProjectManager.getInstance((KylinConfig)KylinConfig.getInstanceFromEnv()).listAllProjects();
            projects.forEach(x -> KylinLogTool.extractJobTmpCandidateLog(exportDir, x.getName(), startTime, endTime));
            this.recordTaskExecutorTimeToFile(DiagSubTaskEnum.CANDIDATE_LOG, recordTime);
        });
        this.scheduleTimeoutTask(candidateLogTask, DiagSubTaskEnum.CANDIDATE_LOG);
    }

    @Generated
    public String getPackageType() {
        return this.packageType;
    }

    @Generated
    public void setPackageType(String packageType) {
        this.packageType = packageType;
    }

    @Generated
    public File getExportDir() {
        return this.exportDir;
    }

    @Generated
    public KylinConfig getKylinConfig() {
        return this.kylinConfig;
    }

    @Generated
    public KapConfig getKapConfig() {
        return this.kapConfig;
    }

    @Generated
    public String getKylinHome() {
        return this.kylinHome;
    }

    @Generated
    public CliCommandExecutor getCmdExecutor() {
        return this.cmdExecutor;
    }
}

