/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.tool;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;
import java.util.List;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.util.JsonUtil;
import org.apache.kylin.metadata.asynctask.AbstractAsyncTask;
import org.apache.kylin.metadata.favorite.AsyncTaskManager;
import org.apache.kylin.metadata.project.NProjectManager;
import org.apache.kylin.metadata.project.ProjectInstance;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AsyncTaskTool {
    private static final Logger logger = LoggerFactory.getLogger((String)"diag");

    public void backup() {
    }

    public void restore() {
    }

    public void extractFull(File dir) throws IOException {
        logger.info("Extract async task.");
        List projects = NProjectManager.getInstance((KylinConfig)KylinConfig.getInstanceFromEnv()).listAllProjects();
        for (ProjectInstance project : projects) {
            this.extractProject(dir, project.getName());
        }
    }

    public void extractProject(File dir, String project) throws IOException {
        logger.info("Extract async task for project: {}", (Object)project);
        File projectFile = new File(dir, project);
        AsyncTaskManager manager = AsyncTaskManager.getInstance((String)project);
        try (FileOutputStream os = new FileOutputStream(projectFile);
             BufferedWriter bw = new BufferedWriter(new OutputStreamWriter((OutputStream)os, Charset.defaultCharset()));){
            for (String taskType : AsyncTaskManager.ALL_TASK_TYPES) {
                AbstractAsyncTask task = manager.get(taskType);
                try {
                    bw.write(JsonUtil.writeValueAsString((Object)task));
                    bw.newLine();
                }
                catch (Exception e) {
                    logger.error("Write error, id is {}", (Object)task.getId(), (Object)e);
                }
            }
        }
    }
}

