/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.tool;

import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import lombok.Generated;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.util.Unsafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KylinConfigExporterCLI {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(KylinConfigExporterCLI.class);

    public static void main(String[] args) {
        if (ArrayUtils.isEmpty((Object[])args)) {
            log.error("Usage:   KylinConfigExporterCli ${FILE_PATH}");
            log.error("Example: KylinConfigExporterCli /tmp/t1.p");
            Unsafe.systemExit((int)1);
        }
        try {
            KylinConfigExporterCLI.execute(args);
        }
        catch (Exception e) {
            Unsafe.systemExit((int)1);
        }
        Unsafe.systemExit((int)0);
    }

    public static void execute(String[] args) {
        String filePath = args[0];
        try {
            if (args.length != 1) {
                throw new IllegalArgumentException();
            }
            String exportString = KylinConfig.getInstanceFromEnv().exportAllToString();
            KylinConfigExporterCLI.doExport(filePath, exportString);
            log.info("export configuration succeed, {}", (Object)filePath);
        }
        catch (Exception e) {
            log.error("export configuration failed, {},", (Object)filePath, (Object)e);
            ExceptionUtils.rethrow((Throwable)e);
        }
    }

    private static void doExport(String filePath, String exportStr) throws IOException {
        File kFile = new File(filePath);
        if (kFile.exists()) {
            throw new IllegalStateException("file already exists:" + filePath);
        }
        FileUtils.writeStringToFile((File)kFile, (String)exportStr, (Charset)StandardCharsets.UTF_8);
    }
}

