/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.tool.general;

import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.kylin.common.util.EncryptUtil;
import org.apache.kylin.common.util.ExecutableApplication;
import org.apache.kylin.common.util.OptionBuilder;
import org.apache.kylin.common.util.OptionsHelper;
import org.apache.kylin.common.util.Unsafe;
import org.springframework.security.crypto.bcrypt.BCryptPasswordEncoder;

public class CryptTool
extends ExecutableApplication {
    private final Option optionEncryptMethod;
    private final Option optionCharSequence;
    private final Options options;

    public CryptTool() {
        OptionBuilder optionBuilder = OptionBuilder.getInstance();
        optionBuilder.withArgName("ENCRYPT_METHOD");
        optionBuilder.hasArg();
        optionBuilder.withDescription("Specify the encrypt method: [AES, BCrypt]");
        optionBuilder.isRequired();
        optionBuilder.withLongOpt("encrypt-method");
        this.optionEncryptMethod = optionBuilder.create("e");
        optionBuilder.withArgName("CHAR_SEQUENCE");
        optionBuilder.hasArg();
        optionBuilder.withDescription("Specify the char sequence to be encrypted");
        optionBuilder.isRequired();
        optionBuilder.withLongOpt("char-sequence");
        this.optionCharSequence = optionBuilder.create("s");
        this.options = new Options();
        this.options.addOption(this.optionEncryptMethod);
        this.options.addOption(this.optionCharSequence);
    }

    public static void main(String[] args) {
        CryptTool tool = new CryptTool();
        tool.execute(args);
        Unsafe.systemExit((int)0);
    }

    protected Options getOptions() {
        return this.options;
    }

    protected void execute(OptionsHelper optionsHelper) {
        String encryptMethod = optionsHelper.getOptionValue(this.optionEncryptMethod);
        String passwordTxt = optionsHelper.getOptionValue(this.optionCharSequence);
        if ("AES".equalsIgnoreCase(encryptMethod)) {
            System.out.println(EncryptUtil.encrypt((String)passwordTxt));
        } else if ("BCrypt".equalsIgnoreCase(encryptMethod)) {
            BCryptPasswordEncoder bCryptPasswordEncoder = new BCryptPasswordEncoder();
            System.out.println(bCryptPasswordEncoder.encode((CharSequence)passwordTxt));
        } else {
            System.out.println("Unsupported encrypt method: " + encryptMethod);
            Unsafe.systemExit((int)1);
        }
    }
}

