/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.tool.security;

import java.util.Locale;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.persistence.RawResource;
import org.apache.kylin.common.persistence.ResourceStore;
import org.apache.kylin.common.persistence.transaction.UnitOfWork;
import org.apache.kylin.common.util.Unsafe;
import org.apache.kylin.metadata.user.ManagedUser;
import org.apache.kylin.metadata.user.NKylinUserManager;
import org.apache.kylin.tool.MetadataTool;
import org.apache.kylin.tool.security.AdminUserInitCLI;
import org.apache.kylin.util.PasswordEncodeFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.crypto.password.PasswordEncoder;

public class KylinPasswordResetCLI {
    protected static final Logger logger = LoggerFactory.getLogger(KylinPasswordResetCLI.class);

    public static void main(String[] args) {
        int exit;
        try {
            exit = KylinPasswordResetCLI.reset() ? 0 : 1;
        }
        catch (Exception e) {
            exit = 1;
            logger.warn("Fail to reset admin password.", (Throwable)e);
        }
        Unsafe.systemExit((int)exit);
    }

    public static boolean reset() throws Exception {
        KylinConfig config = KylinConfig.getInstanceFromEnv();
        if (config.isQueryNodeOnly()) {
            logger.error("Only job/all node can update metadata.");
            return false;
        }
        PasswordEncoder pwdEncoder = PasswordEncodeFactory.newUserPasswordEncoder();
        String id = "USER_INFO/ADMIN";
        ResourceStore aclStore = ResourceStore.getKylinMetaStore((KylinConfig)config);
        NKylinUserManager userManager = NKylinUserManager.getInstance((KylinConfig)config);
        ManagedUser user = userManager.get("ADMIN");
        if (user == null) {
            logger.warn("The password cannot be reset because there is no ADMIN user.");
            return false;
        }
        RawResource res = aclStore.getResource(id);
        if (res == null) {
            logger.warn("The password cannot be reset because there is no ADMIN user.");
            return false;
        }
        user.clearAuthenticateFailedRecord();
        boolean randomPasswordEnabled = KylinConfig.getInstanceFromEnv().getRandomAdminPasswordEnabled();
        String password = randomPasswordEnabled ? AdminUserInitCLI.generateRandomPassword() : "KYLIN";
        UnitOfWork.doInTransactionWithRetry(() -> {
            KylinConfig conf = KylinConfig.getInstanceFromEnv();
            NKylinUserManager.getInstance((KylinConfig)conf).updateUser("ADMIN", copyForWrite -> {
                copyForWrite.setPassword(pwdEncoder.encode((CharSequence)password));
                copyForWrite.setDefaultPassword(true);
            });
            return true;
        }, (String)"_global");
        logger.trace("update user : {}", (Object)user.getUsername());
        logger.info("User {}'s password is set to default password.", (Object)user.getUsername());
        try {
            MetadataTool.backup(config);
        }
        catch (Exception e) {
            logger.error("metadata backup failed", (Throwable)e);
        }
        if (randomPasswordEnabled) {
            String blackColorUsernameForPrint = "\u001b[0mADMIN\u001b[31m";
            String blackColorPasswordForPrint = "\u001b[0m" + password + "\u001b[31m";
            String info = String.format(Locale.ROOT, "Reset password of [%s] succeed. The password is [%s].\nPlease keep the password properly.", blackColorUsernameForPrint, blackColorPasswordForPrint);
            System.out.println("\u001b[31m" + info + "\u001b[0m");
        } else {
            System.out.println("\u001b[33mReset the ADMIN password successfully.\u001b[0m");
        }
        return true;
    }
}

