/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.tool.util;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.naming.directory.SearchControls;
import lombok.Generated;
import org.apache.kylin.common.KapConfig;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.util.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.ldap.control.PagedResultsDirContextProcessor;
import org.springframework.ldap.core.ContextMapper;
import org.springframework.ldap.core.ContextSource;
import org.springframework.ldap.core.DirContextAdapter;
import org.springframework.ldap.core.DirContextProcessor;
import org.springframework.ldap.core.support.SingleContextSource;
import org.springframework.security.ldap.SpringSecurityLdapTemplate;

public class LdapUtils {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(LdapUtils.class);

    private LdapUtils() {
    }

    public static Map<String, String> getAllValidUserDnMap(SpringSecurityLdapTemplate ldapTemplate, SearchControls searchControls) {
        String ldapUserSearchBase = KylinConfig.getInstanceFromEnv().getLDAPUserSearchBase();
        String ldapUserSearchFilter = KapConfig.getInstanceFromEnv().getLDAPUserSearchFilter();
        String ldapUserIDAttr = KapConfig.getInstanceFromEnv().getLDAPUserIDAttr();
        Integer maxPageSize = KapConfig.getInstanceFromEnv().getLDAPMaxPageSize();
        log.info("ldap user search config, base: {}, filter: {}, identifier attribute: {}, maxPageSize: {}", new Object[]{ldapUserSearchBase, ldapUserSearchFilter, ldapUserIDAttr, maxPageSize});
        PagedResultsDirContextProcessor processor = new PagedResultsDirContextProcessor(maxPageSize.intValue());
        ContextMapper contextMapper = ctx -> {
            DirContextAdapter adapter = (DirContextAdapter)ctx;
            return Pair.newPair((Object)adapter.getNameInNamespace(), (Object)adapter.getAttributes().get(ldapUserIDAttr).get().toString());
        };
        List pairs = (List)SingleContextSource.doWithSingleContext((ContextSource)ldapTemplate.getContextSource(), operations -> {
            ArrayList pairList = new ArrayList();
            do {
                pairList.addAll(operations.search(ldapUserSearchBase, ldapUserSearchFilter, searchControls, contextMapper, (DirContextProcessor)processor));
            } while (processor.hasMore());
            return pairList;
        });
        Map<String, String> resultMap = pairs.stream().collect(Collectors.groupingBy(Pair::getSecond)).entrySet().stream().filter(e -> 1 == ((List)e.getValue()).size()).map(Map.Entry::getValue).map(list -> (Pair)list.get(0)).collect(Collectors.toMap(Pair::getKey, Pair::getValue));
        log.info("LDAP user info load success");
        return resultMap;
    }

    public static Set<String> getAllGroupMembers(SpringSecurityLdapTemplate ldapTemplate, String name) {
        String ldapGroupSearchBase = KylinConfig.getInstanceFromEnv().getLDAPGroupSearchBase();
        String ldapGroupMemberSearchFilter = KapConfig.getInstanceFromEnv().getLDAPGroupMemberSearchFilter();
        String ldapGroupMemberAttr = KapConfig.getInstanceFromEnv().getLDAPGroupMemberAttr();
        Set<String> ldapUserDNs = ldapTemplate.searchForSingleAttributeValues(ldapGroupSearchBase, ldapGroupMemberSearchFilter, (Object[])new String[]{name}, ldapGroupMemberAttr);
        log.info("Ldap group members search config, base: {},member search filter: {}, member identifier: {}", new Object[]{ldapGroupSearchBase, ldapGroupMemberSearchFilter, ldapGroupMemberAttr});
        if (ldapUserDNs.isEmpty()) {
            int left = 0;
            Integer maxValRange = KapConfig.getInstanceFromEnv().getLDAPMaxValRange();
            while (true) {
                String ldapGroupMemberRangeAttr = String.format(Locale.ROOT, "%s;range=%s-%s", ldapGroupMemberAttr, left, left + (maxValRange - 1));
                log.info("Ldap group members search config, base: {},member search filter: {}, member identifier: {}", new Object[]{ldapGroupSearchBase, ldapGroupMemberSearchFilter, ldapGroupMemberRangeAttr});
                Set rangeResults = ldapTemplate.searchForSingleAttributeValues(ldapGroupSearchBase, ldapGroupMemberSearchFilter, (Object[])new String[]{name}, ldapGroupMemberRangeAttr);
                if (rangeResults.isEmpty()) {
                    ldapGroupMemberRangeAttr = String.format(Locale.ROOT, "%s;range=%s-%s", ldapGroupMemberAttr, left, "*");
                    log.info("Last page, ldap group members search config, base: {},member search filter: {}, member identifier: {}", new Object[]{ldapGroupSearchBase, ldapGroupMemberSearchFilter, ldapGroupMemberRangeAttr});
                    ldapUserDNs.addAll(ldapTemplate.searchForSingleAttributeValues(ldapGroupSearchBase, ldapGroupMemberSearchFilter, (Object[])new String[]{name}, ldapGroupMemberRangeAttr));
                    break;
                }
                ldapUserDNs.addAll(rangeResults);
                left += maxValRange.intValue();
            }
        }
        ldapUserDNs = LdapUtils.rewriteUserDnIfNeeded(ldapUserDNs);
        return ldapUserDNs;
    }

    public static Set<String> rewriteUserDnIfNeeded(Set<String> ldapUserDNs) {
        String ldapUserSearchBase = KylinConfig.getInstanceFromEnv().getLDAPUserSearchBase();
        return ldapUserDNs.stream().map(dn -> {
            String dnName = dn;
            if (!dn.contains(ldapUserSearchBase)) {
                dnName = "uid=" + dn + "," + ldapUserSearchBase;
            }
            return dnName;
        }).collect(Collectors.toSet());
    }
}

