/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.tool.util;

import org.apache.kylin.common.util.Unsafe;

public class ScreenPrintUtil {
    public static final String ANSI_RED = "\u001b[31m";
    public static final String ANSI_GREEN = "\u001b[32m";
    public static final String ANSI_YELLOW = "\u001b[33m";
    public static final String ANSI_BLUE = "\u001b[34m";
    public static final String ANSI_RESET = "\u001b[0m";

    private ScreenPrintUtil() {
    }

    public static void println(String msg) {
        System.out.println(msg);
    }

    private static void printlnColorMsg(String type, String msg) {
        System.out.println(type + msg + ANSI_RESET);
    }

    public static void printlnGreen(String msg) {
        ScreenPrintUtil.printlnColorMsg(ANSI_GREEN, msg);
    }

    public static void printlnRed(String msg) {
        ScreenPrintUtil.printlnColorMsg(ANSI_RED, msg);
    }

    public static void printlnYellow(String msg) {
        ScreenPrintUtil.printlnColorMsg(ANSI_YELLOW, msg);
    }

    public static void printlnBlue(String msg) {
        ScreenPrintUtil.printlnColorMsg(ANSI_BLUE, msg);
    }

    public static void systemExitWhenMainThread(int code) {
        if (ScreenPrintUtil.isMainThread()) {
            Unsafe.systemExit((int)code);
        }
    }

    public static boolean isMainThread() {
        return "main".equalsIgnoreCase(Thread.currentThread().getName());
    }
}

