/*
 * Decompiled with CFR 0.152.
 */
package io.delta.standalone.expressions;

import io.delta.standalone.data.RowRecord;
import io.delta.standalone.expressions.Expression;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public abstract class UnaryExpression
implements Expression {
    protected final Expression child;

    protected UnaryExpression(Expression expression) {
        this.child = expression;
    }

    public Expression getChild() {
        return this.child;
    }

    @Override
    public Object eval(RowRecord rowRecord) {
        Object object = this.child.eval(rowRecord);
        if (null == object) {
            return null;
        }
        return this.nullSafeEval(object);
    }

    protected Object nullSafeEval(Object object) {
        throw new IllegalArgumentException("UnaryExpressions must override either eval or nullSafeEval");
    }

    @Override
    public List<Expression> children() {
        return Collections.singletonList(this.child);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        UnaryExpression unaryExpression = (UnaryExpression)object;
        return Objects.equals(this.child, unaryExpression.child);
    }

    public int hashCode() {
        return Objects.hash(this.child);
    }
}

