/*
 * Decompiled with CFR 0.152.
 */
package io.delta.standalone.util;

import io.delta.standalone.internal.util.SparkToParquetSchemaConverter;
import io.delta.standalone.types.StructType;
import org.apache.parquet.schema.MessageType;

public final class ParquetSchemaConverter {
    public static final Boolean writeLegacyParquetFormatDefault = false;
    public static final ParquetOutputTimestampType outputTimestampTypeDefault = ParquetOutputTimestampType.INT96;

    private ParquetSchemaConverter() {
    }

    public static MessageType deltaToParquet(StructType structType) {
        return new SparkToParquetSchemaConverter(writeLegacyParquetFormatDefault, outputTimestampTypeDefault).convert(structType);
    }

    public static MessageType deltaToParquet(StructType structType, Boolean bl) {
        return new SparkToParquetSchemaConverter(bl, outputTimestampTypeDefault).convert(structType);
    }

    public static MessageType deltaToParquet(StructType structType, ParquetOutputTimestampType parquetOutputTimestampType) {
        return new SparkToParquetSchemaConverter(writeLegacyParquetFormatDefault, parquetOutputTimestampType).convert(structType);
    }

    public static MessageType deltaToParquet(StructType structType, Boolean bl, ParquetOutputTimestampType parquetOutputTimestampType) {
        return new SparkToParquetSchemaConverter(bl, parquetOutputTimestampType).convert(structType);
    }

    public static enum ParquetOutputTimestampType {
        INT96,
        TIMESTAMP_MICROS,
        TIMESTAMP_MILLIS;

    }
}

