/*
 * Decompiled with CFR 0.152.
 */
package shadedelta.org.apache.yetus.audience.tools;

import com.sun.javadoc.DocErrorReporter;
import java.util.ArrayList;
import java.util.Locale;
import shadedelta.org.apache.yetus.audience.tools.RootDocProcessor;

class StabilityOptions {
    public static final String STABLE_OPTION = "-stable";
    public static final String EVOLVING_OPTION = "-evolving";
    public static final String UNSTABLE_OPTION = "-unstable";

    StabilityOptions() {
    }

    public static Integer optionLength(String option) {
        String opt = option.toLowerCase(Locale.ENGLISH);
        if (opt.equals(UNSTABLE_OPTION)) {
            return 1;
        }
        if (opt.equals(EVOLVING_OPTION)) {
            return 1;
        }
        if (opt.equals(STABLE_OPTION)) {
            return 1;
        }
        return null;
    }

    public static void validOptions(String[][] options, DocErrorReporter reporter) {
        block10: for (String[] option : options) {
            String opt;
            switch (opt = option[0].toLowerCase(Locale.ENGLISH)) {
                case "-unstable": {
                    RootDocProcessor.stability = UNSTABLE_OPTION;
                    continue block10;
                }
                case "-evolving": {
                    RootDocProcessor.stability = EVOLVING_OPTION;
                    continue block10;
                }
                case "-stable": {
                    RootDocProcessor.stability = STABLE_OPTION;
                    continue block10;
                }
            }
        }
    }

    public static String[][] filterOptions(String[][] options) {
        ArrayList<String[]> optionsList = new ArrayList<String[]>(options.length);
        for (String[] option1 : options) {
            if (option1[0].equalsIgnoreCase(UNSTABLE_OPTION) || option1[0].equalsIgnoreCase(EVOLVING_OPTION) || option1[0].equalsIgnoreCase(STABLE_OPTION)) continue;
            optionsList.add(option1);
        }
        String[][] filteredOptions = new String[optionsList.size()][];
        int i = 0;
        for (String[] option : optionsList) {
            filteredOptions[i++] = option;
        }
        return filteredOptions;
    }
}

