/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gluten.substrait.rel;

import io.substrait.proto.AggregateRel;
import io.substrait.proto.Rel;
import io.substrait.proto.RelCommon;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.gluten.substrait.expression.AggregateFunctionNode;
import org.apache.gluten.substrait.expression.ExpressionNode;
import org.apache.gluten.substrait.extensions.AdvancedExtensionNode;
import org.apache.gluten.substrait.rel.RelNode;

public class AggregateRelNode
implements RelNode,
Serializable {
    private final RelNode input;
    private final List<ExpressionNode> groupings = new ArrayList<ExpressionNode>();
    private final List<AggregateFunctionNode> aggregateFunctionNodes = new ArrayList<AggregateFunctionNode>();
    private final List<ExpressionNode> filters = new ArrayList<ExpressionNode>();
    private final AdvancedExtensionNode extensionNode;

    AggregateRelNode(RelNode input, List<ExpressionNode> groupings, List<AggregateFunctionNode> aggregateFunctionNodes, List<ExpressionNode> filters) {
        this.input = input;
        this.groupings.addAll(groupings);
        this.aggregateFunctionNodes.addAll(aggregateFunctionNodes);
        this.filters.addAll(filters);
        this.extensionNode = null;
    }

    AggregateRelNode(RelNode input, List<ExpressionNode> groupings, List<AggregateFunctionNode> aggregateFunctionNodes, List<ExpressionNode> filters, AdvancedExtensionNode extensionNode) {
        this.input = input;
        this.groupings.addAll(groupings);
        this.aggregateFunctionNodes.addAll(aggregateFunctionNodes);
        this.filters.addAll(filters);
        this.extensionNode = extensionNode;
    }

    @Override
    public Rel toProtobuf() {
        RelCommon.Builder relCommonBuilder = RelCommon.newBuilder();
        relCommonBuilder.setDirect(RelCommon.Direct.newBuilder());
        AggregateRel.Grouping.Builder groupingBuilder = AggregateRel.Grouping.newBuilder();
        for (ExpressionNode exprNode : this.groupings) {
            groupingBuilder.addGroupingExpressions(exprNode.toProtobuf());
        }
        AggregateRel.Builder aggBuilder = AggregateRel.newBuilder();
        aggBuilder.setCommon(relCommonBuilder.build());
        aggBuilder.addGroupings(groupingBuilder.build());
        for (int i = 0; i < this.aggregateFunctionNodes.size(); ++i) {
            AggregateRel.Measure.Builder measureBuilder = AggregateRel.Measure.newBuilder();
            measureBuilder.setMeasure(this.aggregateFunctionNodes.get(i).toProtobuf());
            if (this.filters.get(i) != null) {
                measureBuilder.setFilter(this.filters.get(i).toProtobuf());
            }
            aggBuilder.addMeasures(measureBuilder.build());
        }
        if (this.input != null) {
            aggBuilder.setInput(this.input.toProtobuf());
        }
        if (this.extensionNode != null) {
            aggBuilder.setAdvancedExtension(this.extensionNode.toProtobuf());
        }
        Rel.Builder builder = Rel.newBuilder();
        builder.setAggregate(aggBuilder.build());
        return builder.build();
    }
}

