/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gluten.substrait.rel;

import io.substrait.proto.Rel;
import io.substrait.proto.RelCommon;
import io.substrait.proto.SortField;
import io.substrait.proto.WindowGroupLimitRel;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.gluten.substrait.expression.ExpressionNode;
import org.apache.gluten.substrait.extensions.AdvancedExtensionNode;
import org.apache.gluten.substrait.rel.RelNode;

public class WindowGroupLimitRelNode
implements RelNode,
Serializable {
    private final RelNode input;
    private final List<ExpressionNode> partitionExpressions = new ArrayList<ExpressionNode>();
    private final List<SortField> sorts = new ArrayList<SortField>();
    private final AdvancedExtensionNode extensionNode;
    private final Integer limit;

    public WindowGroupLimitRelNode(RelNode input, List<ExpressionNode> partitionExpressions, List<SortField> sorts, Integer limit) {
        this.input = input;
        this.partitionExpressions.addAll(partitionExpressions);
        this.sorts.addAll(sorts);
        this.limit = limit;
        this.extensionNode = null;
    }

    public WindowGroupLimitRelNode(RelNode input, List<ExpressionNode> partitionExpressions, List<SortField> sorts, Integer limit, AdvancedExtensionNode extensionNode) {
        this.input = input;
        this.partitionExpressions.addAll(partitionExpressions);
        this.sorts.addAll(sorts);
        this.limit = limit;
        this.extensionNode = extensionNode;
    }

    @Override
    public Rel toProtobuf() {
        int i;
        RelCommon.Builder relCommonBuilder = RelCommon.newBuilder();
        relCommonBuilder.setDirect(RelCommon.Direct.newBuilder());
        WindowGroupLimitRel.Builder windowBuilder = WindowGroupLimitRel.newBuilder();
        windowBuilder.setCommon(relCommonBuilder.build());
        if (this.input != null) {
            windowBuilder.setInput(this.input.toProtobuf());
        }
        for (i = 0; i < this.partitionExpressions.size(); ++i) {
            windowBuilder.addPartitionExpressions(i, this.partitionExpressions.get(i).toProtobuf());
        }
        for (i = 0; i < this.sorts.size(); ++i) {
            windowBuilder.addSorts(i, this.sorts.get(i));
        }
        windowBuilder.setLimit(this.limit);
        if (this.extensionNode != null) {
            windowBuilder.setAdvancedExtension(this.extensionNode.toProtobuf());
        }
        Rel.Builder builder = Rel.newBuilder();
        builder.setWindowGroupLimit(windowBuilder.build());
        return builder.build();
    }
}

