/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gluten.utils;

import org.apache.gluten.backendsapi.BackendsApiManager$;
import org.apache.gluten.exception.GlutenNotSupportException;
import org.apache.gluten.expression.ExpressionConverter$;
import org.apache.spark.sql.catalyst.analysis.DecimalPrecision$;
import org.apache.spark.sql.catalyst.expressions.Add;
import org.apache.spark.sql.catalyst.expressions.BinaryArithmetic;
import org.apache.spark.sql.catalyst.expressions.Cast;
import org.apache.spark.sql.catalyst.expressions.Cast$;
import org.apache.spark.sql.catalyst.expressions.Divide;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.Literal;
import org.apache.spark.sql.catalyst.expressions.Multiply;
import org.apache.spark.sql.catalyst.expressions.Pmod;
import org.apache.spark.sql.catalyst.expressions.PromotePrecision;
import org.apache.spark.sql.catalyst.expressions.Remainder;
import org.apache.spark.sql.catalyst.expressions.Subtract;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.types.ByteType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.Decimal;
import org.apache.spark.sql.types.DecimalType;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.ShortType$;
import org.apache.spark.sql.utils.DecimalTypeUtil$;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public final class DecimalArithmeticUtil$ {
    public static DecimalArithmeticUtil$ MODULE$;
    private final int MIN_ADJUSTED_SCALE;
    private final int MAX_PRECISION;
    private final int MAX_SCALE;

    static {
        new DecimalArithmeticUtil$();
    }

    public int MIN_ADJUSTED_SCALE() {
        return this.MIN_ADJUSTED_SCALE;
    }

    public int MAX_PRECISION() {
        return this.MAX_PRECISION;
    }

    public int MAX_SCALE() {
        return this.MAX_SCALE;
    }

    public DecimalType getResultType(BinaryArithmetic expr, DecimalType type1, DecimalType type2) {
        boolean allowPrecisionLoss = SQLConf$.MODULE$.get().decimalOperationsAllowPrecisionLoss();
        int resultScale = 0;
        int resultPrecision = 0;
        BinaryArithmetic binaryArithmetic = expr;
        if (binaryArithmetic instanceof Add) {
            resultScale = Math.max(type1.scale(), type2.scale());
            resultPrecision = resultScale + Math.max(type1.precision() - type1.scale(), type2.precision() - type2.scale()) + 1;
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (binaryArithmetic instanceof Subtract) {
            resultScale = Math.max(type1.scale(), type2.scale());
            resultPrecision = resultScale + Math.max(type1.precision() - type1.scale(), type2.precision() - type2.scale()) + 1;
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (binaryArithmetic instanceof Multiply) {
            resultScale = type1.scale() + type2.scale();
            resultPrecision = type1.precision() + type2.precision() + 1;
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (binaryArithmetic instanceof Divide) {
            BoxedUnit boxedUnit;
            if (allowPrecisionLoss) {
                resultScale = Math.max(this.MIN_ADJUSTED_SCALE(), type1.scale() + type2.precision() + 1);
                resultPrecision = type1.precision() - type1.scale() + type2.scale() + resultScale;
                boxedUnit = BoxedUnit.UNIT;
            } else {
                int decDig;
                int intDig = Math.min(this.MAX_SCALE(), type1.precision() - type1.scale() + type2.scale());
                int diff = intDig + (decDig = Math.min(this.MAX_SCALE(), Math.max(6, type1.scale() + type2.precision() + 1))) - this.MAX_SCALE();
                if (diff > 0) {
                    intDig = this.MAX_SCALE() - (decDig -= diff / 2 + 1);
                }
                resultPrecision = intDig + decDig;
                resultScale = decDig;
                boxedUnit = BoxedUnit.UNIT;
            }
            BoxedUnit boxedUnit2 = boxedUnit;
        } else {
            throw new GlutenNotSupportException(new StringBuilder(18).append(binaryArithmetic).append(" is not supported.").toString());
        }
        return allowPrecisionLoss ? DecimalTypeUtil$.MODULE$.adjustPrecisionScale(resultPrecision, resultScale) : this.bounded(resultPrecision, resultScale);
    }

    public DecimalType bounded(int precision, int scale) {
        return new DecimalType(Math.min(precision, this.MAX_PRECISION()), Math.min(scale, this.MAX_SCALE()));
    }

    public boolean isDecimalArithmetic(BinaryArithmetic b) {
        boolean bl;
        if (((Expression)b.left()).dataType() instanceof DecimalType && ((Expression)b.right()).dataType() instanceof DecimalType) {
            BinaryArithmetic binaryArithmetic = b;
            boolean bl2 = binaryArithmetic instanceof Divide ? true : (binaryArithmetic instanceof Multiply ? true : (binaryArithmetic instanceof Add ? true : (binaryArithmetic instanceof Subtract ? true : (binaryArithmetic instanceof Remainder ? true : binaryArithmetic instanceof Pmod))));
            boolean bl3 = bl2;
            bl = bl3;
        } else {
            bl = false;
        }
        return bl;
    }

    private Tuple2<Integer, Integer> getNewPrecisionScale(Decimal dec) {
        String input = dec.abs().toJavaBigDecimal().toPlainString();
        int dotIndex = input.indexOf(".");
        if (dotIndex == -1) {
            return new Tuple2((Object)Predef$.MODULE$.int2Integer(input.length()), (Object)Predef$.MODULE$.int2Integer(0));
        }
        if (dec.toBigDecimal().isValidLong()) {
            return new Tuple2((Object)Predef$.MODULE$.int2Integer(dotIndex), (Object)Predef$.MODULE$.int2Integer(0));
        }
        return new Tuple2((Object)Predef$.MODULE$.int2Integer(dec.precision()), (Object)Predef$.MODULE$.int2Integer(dec.scale()));
    }

    public BinaryArithmetic rescaleLiteral(BinaryArithmetic arithmeticExpr) {
        BinaryArithmetic binaryArithmetic;
        if (arithmeticExpr.left() instanceof PromotePrecision && arithmeticExpr.right() instanceof Literal) {
            BinaryArithmetic binaryArithmetic2;
            Literal lit = (Literal)arithmeticExpr.right();
            Object object = lit.value();
            if (object instanceof Decimal) {
                Decimal decimal = (Decimal)object;
                Tuple2<Integer, Integer> tuple2 = this.getNewPrecisionScale(decimal);
                if (tuple2 == null) {
                    throw new MatchError(tuple2);
                }
                Integer precision = (Integer)tuple2._1();
                Integer scale = (Integer)tuple2._2();
                Tuple2 tuple22 = new Tuple2((Object)precision, (Object)scale);
                Tuple2 tuple23 = tuple22;
                Integer precision2 = (Integer)tuple23._1();
                Integer scale2 = (Integer)tuple23._2();
                binaryArithmetic2 = !BoxesRunTime.equalsNumObject((Number)precision2, (Object)BoxesRunTime.boxToInteger((int)decimal.precision())) || !BoxesRunTime.equalsNumObject((Number)scale2, (Object)BoxesRunTime.boxToInteger((int)decimal.scale())) ? (BinaryArithmetic)arithmeticExpr.withNewChildren((Seq)new .colon.colon((Object)((Expression)arithmeticExpr.left()), (List)new .colon.colon((Object)new Cast((Expression)lit, (DataType)new DecimalType(Predef$.MODULE$.Integer2int(precision2), Predef$.MODULE$.Integer2int(scale2)), Cast$.MODULE$.apply$default$3(), Cast$.MODULE$.apply$default$4()), (List)Nil$.MODULE$))) : arithmeticExpr;
            } else {
                binaryArithmetic2 = arithmeticExpr;
            }
            binaryArithmetic = binaryArithmetic2;
        } else if (arithmeticExpr.right() instanceof PromotePrecision && arithmeticExpr.left() instanceof Literal) {
            BinaryArithmetic binaryArithmetic3;
            Literal lit = (Literal)arithmeticExpr.left();
            Object object = lit.value();
            if (object instanceof Decimal) {
                Decimal decimal = (Decimal)object;
                Tuple2<Integer, Integer> tuple2 = this.getNewPrecisionScale(decimal);
                if (tuple2 == null) {
                    throw new MatchError(tuple2);
                }
                Integer precision = (Integer)tuple2._1();
                Integer scale = (Integer)tuple2._2();
                Tuple2 tuple24 = new Tuple2((Object)precision, (Object)scale);
                Tuple2 tuple25 = tuple24;
                Integer precision3 = (Integer)tuple25._1();
                Integer scale3 = (Integer)tuple25._2();
                binaryArithmetic3 = !BoxesRunTime.equalsNumObject((Number)precision3, (Object)BoxesRunTime.boxToInteger((int)decimal.precision())) || !BoxesRunTime.equalsNumObject((Number)scale3, (Object)BoxesRunTime.boxToInteger((int)decimal.scale())) ? (BinaryArithmetic)arithmeticExpr.withNewChildren((Seq)new .colon.colon((Object)new Cast((Expression)lit, (DataType)new DecimalType(Predef$.MODULE$.Integer2int(precision3), Predef$.MODULE$.Integer2int(scale3)), Cast$.MODULE$.apply$default$3(), Cast$.MODULE$.apply$default$4()), (List)new .colon.colon((Object)((Expression)arithmeticExpr.right()), (List)Nil$.MODULE$))) : arithmeticExpr;
            } else {
                binaryArithmetic3 = arithmeticExpr;
            }
            binaryArithmetic = binaryArithmetic3;
        } else {
            binaryArithmetic = arithmeticExpr;
        }
        return binaryArithmetic;
    }

    private boolean isPromoteCast(Expression expr) {
        Cast cast;
        PromotePrecision promotePrecision;
        Expression expression;
        Expression expression2 = expr;
        boolean bl = expression2 instanceof PromotePrecision && (expression = (promotePrecision = (PromotePrecision)expression2).child()) instanceof Cast && (cast = (Cast)expression).dataType() instanceof DecimalType;
        return bl;
    }

    public Tuple2<Expression, Expression> rescaleCastForDecimal(Expression left, Expression right) {
        Tuple2 tuple2;
        if (!this.isPromoteCast(left) && this.isPromoteCastIntegral(right)) {
            tuple2 = this.doScale$1(left, right);
        } else if (!this.isPromoteCast(right) && this.isPromoteCastIntegral(left)) {
            Tuple2 tuple22 = this.doScale$1(right, left);
            if (tuple22 == null) {
                throw new MatchError((Object)tuple22);
            }
            Expression r = (Expression)tuple22._1();
            Expression l = (Expression)tuple22._2();
            Tuple2 tuple23 = new Tuple2((Object)r, (Object)l);
            Tuple2 tuple24 = tuple23;
            Expression r2 = (Expression)tuple24._1();
            Expression l2 = (Expression)tuple24._2();
            tuple2 = new Tuple2((Object)l2, (Object)r2);
        } else {
            tuple2 = new Tuple2((Object)left, (Object)right);
        }
        return tuple2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Expression removeCastForDecimal(Expression arithmeticExpr) {
        Expression expression = arithmeticExpr;
        if (!(expression instanceof PromotePrecision)) return arithmeticExpr;
        PromotePrecision promotePrecision = (PromotePrecision)expression;
        Expression expression2 = promotePrecision.child();
        if (!(expression2 instanceof Cast)) return arithmeticExpr;
        Cast cast = (Cast)expression2;
        Expression child = cast.child();
        if (!(cast.dataType() instanceof DecimalType)) return arithmeticExpr;
        if (!(child.dataType() instanceof DecimalType)) return arithmeticExpr;
        return child;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean isPromoteCastIntegral(Expression expr) {
        Expression expression = expr;
        if (!(expression instanceof PromotePrecision)) return false;
        PromotePrecision promotePrecision = (PromotePrecision)expression;
        Expression expression2 = promotePrecision.child();
        if (!(expression2 instanceof Cast)) return false;
        Cast cast = (Cast)expression2;
        Expression child = cast.child();
        if (!(cast.dataType() instanceof DecimalType)) return false;
        DataType dataType = child.dataType();
        if (IntegerType$.MODULE$.equals(dataType)) {
            return true;
        }
        if (ByteType$.MODULE$.equals(dataType)) {
            return true;
        }
        if (ShortType$.MODULE$.equals(dataType)) {
            return true;
        }
        if (!LongType$.MODULE$.equals(dataType)) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Expression rescaleCastForOneSide(Expression expr) {
        Expression expression = expr;
        if (!(expression instanceof PromotePrecision)) return expr;
        PromotePrecision promotePrecision = (PromotePrecision)expression;
        Expression expression2 = promotePrecision.child();
        if (!(expression2 instanceof Cast)) return expr;
        Cast cast = (Cast)expression2;
        Expression child = cast.child();
        if (!(cast.dataType() instanceof DecimalType)) return expr;
        DataType dataType = child.dataType();
        boolean bl = IntegerType$.MODULE$.equals(dataType) ? true : (ByteType$.MODULE$.equals(dataType) ? true : ShortType$.MODULE$.equals(dataType));
        Expression expression3 = bl ? (Expression)promotePrecision.withNewChildren((Seq)new .colon.colon((Object)new Cast(child, (DataType)new DecimalType(10, 0), Cast$.MODULE$.apply$default$3(), Cast$.MODULE$.apply$default$4()), (List)Nil$.MODULE$)) : (LongType$.MODULE$.equals(dataType) ? (Expression)promotePrecision.withNewChildren((Seq)new .colon.colon((Object)new Cast(child, (DataType)new DecimalType(20, 0), Cast$.MODULE$.apply$default$3(), Cast$.MODULE$.apply$default$4()), (List)Nil$.MODULE$)) : expr);
        return expression3;
    }

    private boolean checkIsWiderType(DecimalType left, DecimalType right, DecimalType wider) {
        DecimalType widerType = DecimalPrecision$.MODULE$.widerDecimalType(left, right);
        return widerType.equals((Object)wider);
    }

    public void checkAllowDecimalArithmetic() {
        if (!BackendsApiManager$.MODULE$.getSettings().allowDecimalArithmetic()) {
            throw new GlutenNotSupportException(new StringBuilder(18).append("Not support ").append(SQLConf$.MODULE$.DECIMAL_OPERATIONS_ALLOW_PREC_LOSS().key()).append(" ").append(ExpressionConverter$.MODULE$.conf().decimalOperationsAllowPrecisionLoss()).append(" mode").toString());
        }
    }

    private final Tuple2 doScale$1(Expression e1, Expression e2) {
        Expression newE2 = this.rescaleCastForOneSide(e2);
        boolean isWiderType = this.checkIsWiderType((DecimalType)e1.dataType(), (DecimalType)newE2.dataType(), (DecimalType)e2.dataType());
        return isWiderType ? new Tuple2((Object)e1, (Object)newE2) : new Tuple2((Object)e1, (Object)e2);
    }

    private DecimalArithmeticUtil$() {
        MODULE$ = this;
        this.MIN_ADJUSTED_SCALE = 6;
        this.MAX_PRECISION = 38;
        this.MAX_SCALE = 38;
    }
}

