/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.hive;

import java.io.Serializable;
import java.net.URI;
import org.apache.gluten.backendsapi.BackendsApiManager$;
import org.apache.gluten.sql.shims.SparkShimLoader$;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.ql.metadata.Partition;
import org.apache.hadoop.io.compress.CompressionCodec;
import org.apache.hadoop.io.compress.CompressionCodecFactory;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.InternalRow$;
import org.apache.spark.sql.catalyst.SQLConfHelper;
import org.apache.spark.sql.catalyst.analysis.CastSupport;
import org.apache.spark.sql.catalyst.expressions.Cast;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.Literal$;
import org.apache.spark.sql.execution.datasources.FilePartition;
import org.apache.spark.sql.execution.datasources.FilePartition$;
import org.apache.spark.sql.execution.datasources.PartitionDirectory;
import org.apache.spark.sql.internal.SQLConf;
import org.apache.spark.sql.types.DataType;
import scala.Array$;
import scala.Function1;
import scala.MatchError;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.GenIterable;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableLike;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Buffer$;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005}e\u0001\u0002\t\u0012\u0001qA\u0001b\f\u0001\u0003\u0002\u0003\u0006I\u0001\r\u0005\tq\u0001\u0011\t\u0011)A\u0005s!)Q\b\u0001C\u0001}!)1\u0007\u0001C!\u0007\")!\n\u0001C\u0005\u0017\"AA\r\u0001EC\u0002\u0013\u0005Q\r\u0003\u0005o\u0001!\u0015\r\u0011\"\u0001p\u0011\u0015\u0019\b\u0001\"\u0003u\u0011\u0015i\b\u0001\"\u0003\u007f\u0011\u001d\tI\u0001\u0001C\u0005\u0003\u0017Aq!!\u0003\u0001\t\u0013\ti\u0005C\u0004\u0002r\u0001!I!a\u001d\t\u000f\u0005\r\u0005\u0001\"\u0003\u0002\u0006\"9\u00111\u0011\u0001\u0005\u0002\u0005M\u0005bBAB\u0001\u0011\u0005\u0011\u0011\u0014\u0002\u0017\u0011&4X\rU1si&$\u0018n\u001c8D_:4XM\u001d;fe*\u0011!cE\u0001\u0005Q&4XM\u0003\u0002\u0015+\u0005\u00191/\u001d7\u000b\u0005Y9\u0012!B:qCJ\\'B\u0001\r\u001a\u0003\u0019\t\u0007/Y2iK*\t!$A\u0002pe\u001e\u001c\u0001a\u0005\u0003\u0001;\rZ\u0003C\u0001\u0010\"\u001b\u0005y\"\"\u0001\u0011\u0002\u000bM\u001c\u0017\r\\1\n\u0005\tz\"AB!osJ+g\r\u0005\u0002%S5\tQE\u0003\u0002'O\u0005A\u0011M\\1msNL7O\u0003\u0002)'\u0005A1-\u0019;bYf\u001cH/\u0003\u0002+K\tY1)Y:u'V\u0004\bo\u001c:u!\taS&D\u0001(\u0013\tqsEA\u0007T#2\u001buN\u001c4IK2\u0004XM]\u0001\u000bQ\u0006$wn\u001c9D_:4\u0007CA\u00197\u001b\u0005\u0011$BA\u001a5\u0003\u0011\u0019wN\u001c4\u000b\u0005U:\u0012A\u00025bI>|\u0007/\u0003\u00028e\ti1i\u001c8gS\u001e,(/\u0019;j_:\fqa]3tg&|g\u000e\u0005\u0002;w5\t1#\u0003\u0002='\ta1\u000b]1sWN+7o]5p]\u00061A(\u001b8jiz\"2aP!C!\t\u0001\u0005!D\u0001\u0012\u0011\u0015y3\u00011\u00011\u0011\u0015A4\u00011\u0001:+\u0005!\u0005CA#I\u001b\u00051%BA$\u0014\u0003!Ig\u000e^3s]\u0006d\u0017BA%G\u0005\u001d\u0019\u0016\u000bT\"p]\u001a\fabY1ti\u001a\u0013x.\\*ue&tw\rF\u0002M\u001fr\u0003\"AH'\n\u00059{\"aA!os\")\u0001+\u0002a\u0001#\u0006)a/\u00197vKB\u0011!+\u0017\b\u0003'^\u0003\"\u0001V\u0010\u000e\u0003US!AV\u000e\u0002\rq\u0012xn\u001c;?\u0013\tAv$\u0001\u0004Qe\u0016$WMZ\u0005\u00035n\u0013aa\u0015;sS:<'B\u0001- \u0011\u0015iV\u00011\u0001_\u0003!!\u0017\r^1UsB,\u0007CA0c\u001b\u0005\u0001'BA1\u0014\u0003\u0015!\u0018\u0010]3t\u0013\t\u0019\u0007M\u0001\u0005ECR\fG+\u001f9f\u00031\u0019w\u000eZ3d\r\u0006\u001cGo\u001c:z+\u00051\u0007CA4m\u001b\u0005A'BA5k\u0003!\u0019w.\u001c9sKN\u001c(BA65\u0003\tIw.\u0003\u0002nQ\n92i\\7qe\u0016\u001c8/[8o\u0007>$Wm\u0019$bGR|'/_\u0001\ne\u0016\u001cWO]:jm\u0016,\u0012\u0001\u001d\t\u0003=EL!A]\u0010\u0003\u000f\t{w\u000e\\3b]\u0006Q1-\u00198CKN\u0003H.\u001b;\u0015\u0005A,\b\"\u0002<\t\u0001\u00049\u0018\u0001\u00034jY\u0016\u0004\u0016\r\u001e5\u0011\u0005a\\X\"A=\u000b\u0005i$\u0014A\u00014t\u0013\ta\u0018P\u0001\u0003QCRD\u0017AE5t\u001d>tW)\u001c9us\u0012\u000bG/\u0019$jY\u0016$\"\u0001]@\t\u000f\u0005\u0005\u0011\u00021\u0001\u0002\u0004\u0005\ta\rE\u0002y\u0003\u000bI1!a\u0002z\u0005)1\u0015\u000e\\3Ti\u0006$Xo]\u0001\nY&\u001cHOR5mKN$b!!\u0004\u00020\u0005\u001d\u0003CBA\b\u00033\tyB\u0004\u0003\u0002\u0012\u0005Uab\u0001+\u0002\u0014%\t\u0001%C\u0002\u0002\u0018}\tq\u0001]1dW\u0006<W-\u0003\u0003\u0002\u001c\u0005u!aA*fc*\u0019\u0011qC\u0010\u0011\t\u0005\u0005\u00121F\u0007\u0003\u0003GQA!!\n\u0002(\u0005YA-\u0019;bg>,(oY3t\u0015\r\tIcE\u0001\nKb,7-\u001e;j_:LA!!\f\u0002$\t\u0011\u0002+\u0019:uSRLwN\u001c#je\u0016\u001cGo\u001c:z\u0011\u001d\t\tD\u0003a\u0001\u0003g\t\u0001\u0003\u001d:v]\u0016$\u0007+\u0019:uSRLwN\\:\u0011\r\u0005=\u0011\u0011DA\u001b!\u0011\t9$a\u0011\u000e\u0005\u0005e\"\u0002BA\u001e\u0003{\t\u0001\"\\3uC\u0012\fG/\u0019\u0006\u0005\u0003\u007f\t\t%\u0001\u0002rY*\u0011!\u0003N\u0005\u0005\u0003\u000b\nIDA\u0005QCJ$\u0018\u000e^5p]\"9\u0011\u0011\n\u0006A\u0002\u0005-\u0013!\u00059beRLG/[8o\u0007>dG+\u001f9fgB)\u0011qBA\r=R!\u0011QBA(\u0011\u001d\t\tf\u0003a\u0001\u0003'\n1\u0002Z5sK\u000e$xN]5fgB1\u0011qBA\r\u0003+\u0002rAHA,\u00037\nY'C\u0002\u0002Z}\u0011a\u0001V;qY\u0016\u0014\u0004\u0003BA/\u0003Oj!!a\u0018\u000b\t\u0005\u0005\u00141M\u0001\u0004]\u0016$(BAA3\u0003\u0011Q\u0017M^1\n\t\u0005%\u0014q\f\u0002\u0004+JK\u0005c\u0001\u0017\u0002n%\u0019\u0011qN\u0014\u0003\u0017%sG/\u001a:oC2\u0014vn^\u0001\u0018C\u0012$\u0017J\u001c9viB\u000bG\u000f\u001b*fGV\u00148/\u001b<fYf$b!!\u001e\u0002x\u0005}\u0004CBA\b\u00033\t\u0019\u0001\u0003\u0004{\u0019\u0001\u0007\u0011\u0011\u0010\t\u0004q\u0006m\u0014bAA?s\nQa)\u001b7f'f\u001cH/Z7\t\u000f\u0005\u0005E\u00021\u0001\u0002\u0004\u0005)a-\u001b7fg\u0006\u00192M]3bi\u00164\u0015\u000e\\3QCJ$\u0018\u000e^5p]R!\u0011qQAH!\u0019\ty!!\u0007\u0002\nB!\u0011\u0011EAF\u0013\u0011\ti)a\t\u0003\u001b\u0019KG.\u001a)beRLG/[8o\u0011\u001d\t\t*\u0004a\u0001\u0003\u001b\t!c]3mK\u000e$X\r\u001a)beRLG/[8ogR1\u0011qQAK\u0003/Cq!!\r\u000f\u0001\u0004\t\u0019\u0004C\u0004\u0002J9\u0001\r!a\u0013\u0015\t\u0005\u001d\u00151\u0014\u0005\b\u0003;{\u0001\u0019AA.\u00035!\u0018M\u00197f\u0019>\u001c\u0017\r^5p]\u0002")
public class HivePartitionConverter
implements CastSupport,
SQLConfHelper {
    private CompressionCodecFactory codecFactory;
    private boolean recursive;
    private final Configuration hadoopConf;
    private final SparkSession session;
    private volatile byte bitmap$0;

    public Cast cast(Expression child, DataType dataType) {
        return CastSupport.cast$((CastSupport)this, (Expression)child, (DataType)dataType);
    }

    public SQLConf conf() {
        return this.session.sessionState().conf();
    }

    private Object castFromString(String value, DataType dataType) {
        return this.cast((Expression)Literal$.MODULE$.apply((Object)value), dataType).eval(null);
    }

    private CompressionCodecFactory codecFactory$lzycompute() {
        HivePartitionConverter hivePartitionConverter = this;
        synchronized (hivePartitionConverter) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.codecFactory = new CompressionCodecFactory(this.hadoopConf);
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.codecFactory;
    }

    public CompressionCodecFactory codecFactory() {
        return (byte)(this.bitmap$0 & 1) == 0 ? this.codecFactory$lzycompute() : this.codecFactory;
    }

    private boolean recursive$lzycompute() {
        HivePartitionConverter hivePartitionConverter = this;
        synchronized (hivePartitionConverter) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.recursive = this.hadoopConf.getBoolean("mapreduce.input.fileinputformat.input.dir.recursive", false);
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.recursive;
    }

    public boolean recursive() {
        return (byte)(this.bitmap$0 & 2) == 0 ? this.recursive$lzycompute() : this.recursive;
    }

    private boolean canBeSplit(Path filePath) {
        CompressionCodec codec = this.codecFactory().getCodec(filePath);
        return codec == null || BackendsApiManager$.MODULE$.getValidatorApiInstance().doCompressionSplittableValidate(codec.getClass().getSimpleName());
    }

    private boolean isNonEmptyDataFile(FileStatus f) {
        String name;
        return !f.isFile() || f.getLen() == 0L ? false : (!(name = f.getPath().getName()).startsWith("_") || name.contains("=")) && !name.startsWith(".");
    }

    private Seq<PartitionDirectory> listFiles(Seq<Partition> prunedPartitions, Seq<DataType> partitionColTypes) {
        Seq directories = (Seq)prunedPartitions.map((Function1 & Serializable & scala.Serializable)p -> {
            URI uri = p.getDataLocation().toUri();
            Seq partValues = ((SeqLike)((TraversableLike)((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(p.getValues()).asScala()).zip((GenIterable)partitionColTypes, Buffer$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
                Tuple2 tuple2 = x0$1;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                String value = (String)tuple2._1();
                DataType dataType = (DataType)tuple2._2();
                Object object = this.castFromString(value, dataType);
                return object;
            }, Buffer$.MODULE$.canBuildFrom())).toSeq();
            InternalRow partValuesAsInternalRow = InternalRow$.MODULE$.fromSeq(partValues);
            return new Tuple2((Object)uri, (Object)partValuesAsInternalRow);
        }, Seq$.MODULE$.canBuildFrom());
        return this.listFiles((Seq<Tuple2<URI, InternalRow>>)directories);
    }

    private Seq<PartitionDirectory> listFiles(Seq<Tuple2<URI, InternalRow>> directories) {
        return (Seq)directories.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            URI directory = (URI)tuple2._1();
            InternalRow partValues = (InternalRow)tuple2._2();
            Path path = new Path(directory);
            FileSystem fs = path.getFileSystem($this.hadoopConf);
            FileStatus[] dirContents = (FileStatus[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])fs.listStatus(path))).flatMap((Function1 & Serializable & scala.Serializable)f -> f.isFile() ? (Seq)new .colon.colon(f, (List)Nil$.MODULE$) : (this.recursive() ? this.addInputPathRecursively(fs, (FileStatus)f) : (Seq<FileStatus>)Nil$.MODULE$), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(FileStatus.class))))).filter((Function1 & Serializable & scala.Serializable)f -> BoxesRunTime.boxToBoolean((boolean)this.isNonEmptyDataFile(f)));
            PartitionDirectory partitionDirectory = new PartitionDirectory(partValues, (Seq)Predef$.MODULE$.wrapRefArray((Object[])dirContents));
            return partitionDirectory;
        }, Seq$.MODULE$.canBuildFrom());
    }

    private Seq<FileStatus> addInputPathRecursively(FileSystem fs, FileStatus files) {
        return files.isFile() ? (Seq)new .colon.colon((Object)files, (List)Nil$.MODULE$) : (Seq)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])fs.listStatus(files.getPath()))).flatMap((Function1 & Serializable & scala.Serializable)file -> file.isFile() ? (Seq)new .colon.colon(file, (List)Nil$.MODULE$) : this.addInputPathRecursively(fs, (FileStatus)file), Array$.MODULE$.fallbackCanBuildFrom(Predef.DummyImplicit$.MODULE$.dummyImplicit()));
    }

    private Seq<FilePartition> createFilePartition(Seq<PartitionDirectory> selectedPartitions) {
        long maxSplitBytes = FilePartition$.MODULE$.maxSplitBytes(this.session, selectedPartitions);
        Seq splitFiles = (Seq)selectedPartitions.flatMap((Function1 & Serializable & scala.Serializable)partition -> (Seq)((SeqLike)SparkShimLoader$.MODULE$.getSparkShims().getFileStatus(partition).flatMap((Function1 & Serializable & scala.Serializable)f -> SparkShimLoader$.MODULE$.getSparkShims().splitFiles($this.session, f, f.getPath(), this.canBeSplit(f.getPath()), maxSplitBytes, partition.values()), Seq$.MODULE$.canBuildFrom())).sortBy((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToLong((long)x$1.length()), ((Ordering)Predef$.MODULE$.implicitly((Object)Ordering.Long$.MODULE$)).reverse()), Seq$.MODULE$.canBuildFrom());
        return FilePartition$.MODULE$.getFilePartitions(this.session, splitFiles, maxSplitBytes);
    }

    public Seq<FilePartition> createFilePartition(Seq<Partition> prunedPartitions, Seq<DataType> partitionColTypes) {
        return this.createFilePartition(this.listFiles(prunedPartitions, partitionColTypes));
    }

    public Seq<FilePartition> createFilePartition(URI tableLocation) {
        return this.createFilePartition(this.listFiles((Seq<Tuple2<URI, InternalRow>>)((Seq)new .colon.colon((Object)new Tuple2((Object)tableLocation, (Object)InternalRow$.MODULE$.empty()), (List)Nil$.MODULE$))));
    }

    public HivePartitionConverter(Configuration hadoopConf, SparkSession session) {
        this.hadoopConf = hadoopConf;
        this.session = session;
        CastSupport.$init$((CastSupport)this);
        SQLConfHelper.$init$((SQLConfHelper)this);
    }
}

