/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.rec;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.collections4.MapUtils;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.guava30.shaded.common.collect.Lists;
import org.apache.kylin.metadata.model.ComputedColumnDesc;
import org.apache.kylin.metadata.model.NDataModel;
import org.apache.kylin.metadata.model.NDataModelManager;
import org.apache.kylin.query.relnode.OlapContext;
import org.apache.kylin.rec.AbstractContext;
import org.apache.kylin.rec.AbstractProposer;
import org.apache.kylin.rec.model.GreedyModelTreesBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ViewModelSelectProposer
extends AbstractProposer {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ViewModelSelectProposer.class);
    private final NDataModelManager dataModelManager;

    protected ViewModelSelectProposer(AbstractContext proposeContext) {
        super(proposeContext);
        this.dataModelManager = NDataModelManager.getInstance((KylinConfig)KylinConfig.getInstanceFromEnv(), (String)this.project);
    }

    @Override
    public void execute() {
        Map<String, Collection<OlapContext>> modelViewOlapContextMap = this.proposeContext.getModelViewOlapContextMap();
        List<AbstractContext.ModelContext> modelContexts = this.proposeContext.getModelContexts();
        if (MapUtils.isEmpty(modelViewOlapContextMap) || null == modelContexts) {
            return;
        }
        Map<String, AbstractContext.ModelContext> existedModelContextsMap = modelContexts.stream().filter(e -> null != e.getOriginModel()).collect(Collectors.toMap(e -> e.getOriginModel().getAlias(), v -> v, (v1, v2) -> v1));
        Map aliasModelMap = this.proposeContext.getOriginModels().stream().collect(Collectors.toMap(NDataModel::getAlias, Function.identity()));
        modelViewOlapContextMap.forEach((modelAlias, olapContexts) -> {
            if (existedModelContextsMap.containsKey(modelAlias)) {
                this.addToExistedModelContext((AbstractContext.ModelContext)existedModelContextsMap.get(modelAlias), (Collection<OlapContext>)olapContexts);
            } else {
                NDataModel dataModel = (NDataModel)aliasModelMap.get(modelAlias);
                if (null != dataModel) {
                    this.createNewModelContext(dataModel, (Collection<OlapContext>)olapContexts);
                }
            }
        });
    }

    private void addToExistedModelContext(AbstractContext.ModelContext existedContext, Collection<OlapContext> olapContexts) {
        existedContext.getModelTree().getOlapContexts().addAll(olapContexts);
    }

    private void createNewModelContext(NDataModel dataModel, Collection<OlapContext> olapContexts) {
        AbstractContext.ModelContext modelContext = this.proposeContext.createModelContext(new GreedyModelTreesBuilder(KylinConfig.getInstanceFromEnv(), this.project, this.proposeContext).build(olapContexts, dataModel.getRootFactTable().getTableDesc()));
        this.setModelContextModel(modelContext, dataModel);
        this.proposeContext.getModelContexts().add(modelContext);
    }

    @Override
    public String getIdentifierName() {
        return "ViewModelSelectProposer";
    }

    private void setModelContextModel(AbstractContext.ModelContext modelContext, NDataModel dataModel) {
        modelContext.setOriginModel(dataModel);
        NDataModel targetModel = this.dataModelManager.copyBySerialization(dataModel);
        targetModel.init(KylinConfig.getInstanceFromEnv(), this.project, (List)Lists.newArrayList());
        modelContext.setTargetModel(targetModel);
        targetModel.getComputedColumnDescs().forEach(cc -> modelContext.getUsedCC().put(cc.getExpression(), (ComputedColumnDesc)cc));
    }
}

