/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.rec.model;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.util.RandomUtil;
import org.apache.kylin.guava30.shaded.common.base.Preconditions;
import org.apache.kylin.guava30.shaded.common.collect.Lists;
import org.apache.kylin.guava30.shaded.common.collect.Maps;
import org.apache.kylin.guava30.shaded.common.collect.Sets;
import org.apache.kylin.metadata.model.ComputedColumnDesc;
import org.apache.kylin.metadata.model.FunctionDesc;
import org.apache.kylin.metadata.model.JoinTableDesc;
import org.apache.kylin.metadata.model.NDataModel;
import org.apache.kylin.metadata.model.ParameterDesc;
import org.apache.kylin.metadata.model.TblColRef;
import org.apache.kylin.metadata.recommendation.entity.DimensionRecItemV2;
import org.apache.kylin.metadata.recommendation.entity.MeasureRecItemV2;
import org.apache.kylin.metadata.recommendation.util.RawRecUtil;
import org.apache.kylin.query.relnode.OlapContext;
import org.apache.kylin.rec.AbstractContext;
import org.apache.kylin.rec.common.AccelerateInfo;
import org.apache.kylin.rec.exception.PendingException;
import org.apache.kylin.rec.model.AbstractModelProposer;
import org.apache.kylin.rec.model.ModelTree;
import org.apache.kylin.rec.util.CubeUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QueryScopeProposer
extends AbstractModelProposer {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(QueryScopeProposer.class);

    QueryScopeProposer(AbstractContext.ModelContext modelContext) {
        super(modelContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void execute(NDataModel dataModel) {
        log.trace("Propose scope for model [{}]", (Object)dataModel.getId());
        KylinConfig kylinConfig = this.getModelContext().getProposeContext().getKapConfig().getKylinConfig();
        boolean partialMatch = kylinConfig.isQueryMatchPartialInnerJoinModel();
        boolean nonEquiPartialMatch = kylinConfig.partialMatchNonEquiJoins();
        ScopeBuilder scopeBuilder = new ScopeBuilder(dataModel, this.getModelContext());
        ModelTree modelTree = this.modelContext.getModelTree();
        for (OlapContext ctx : modelTree.getOlapContexts()) {
            if (!this.isValidOlapContext(ctx)) continue;
            try {
                Map aliasMap = ctx.matchJoins(dataModel, partialMatch, nonEquiPartialMatch);
                ctx.fixModel(dataModel, aliasMap);
                scopeBuilder.injectAllTableColumns(ctx);
                scopeBuilder.injectCandidateMeasure(ctx);
                scopeBuilder.injectCandidateColumns(ctx);
            }
            catch (Exception e) {
                scopeBuilder.inheritAllNameColumn();
                Map<String, AccelerateInfo> accelerateInfoMap = this.modelContext.getProposeContext().getAccelerateInfoMap();
                AccelerateInfo accelerateInfo = accelerateInfoMap.get(ctx.getSql());
                Preconditions.checkNotNull((Object)accelerateInfo);
                if (e instanceof PendingException) {
                    accelerateInfo.setPendingMsg(e.getMessage());
                    continue;
                }
                accelerateInfo.setFailedCause(e);
            }
            finally {
                ctx.unfixModel();
            }
        }
        scopeBuilder.build();
    }

    protected static class ScopeBuilder {
        private final Map<String, ComputedColumnDesc> ccMap;
        private final NDataModel dataModel;
        private final AbstractContext.ModelContext modelContext;
        Map<String, NDataModel.NamedColumn> candidateNamedColumns = Maps.newLinkedHashMap();
        Map<FunctionDesc, NDataModel.Measure> candidateMeasures = Maps.newLinkedHashMap();
        Set<TblColRef> dimensionAsMeasureColumns = Sets.newHashSet();
        Set<TblColRef> allTableColumns = Sets.newHashSet();
        JoinTableDesc[] joins = new JoinTableDesc[0];
        private Set<String> newCcUuids;
        private int maxColId = -1;
        private int maxMeasureId = 99999;

        protected ScopeBuilder(NDataModel dataModel, AbstractContext.ModelContext modelContext) {
            this.dataModel = dataModel;
            this.modelContext = modelContext;
            this.inheritCandidateNamedColumns(dataModel);
            this.inheritCandidateMeasures(dataModel);
            this.inheritJoinTables(dataModel);
            this.ccMap = dataModel.getCcMap();
            this.newCcUuids = modelContext.getCcRecItemMap().values().stream().map(item -> item.getCc().getUuid()).collect(Collectors.toSet());
        }

        private void inheritCandidateNamedColumns(NDataModel dataModel) {
            List allNamedColumns = dataModel.getAllNamedColumns();
            for (NDataModel.NamedColumn column : allNamedColumns) {
                this.maxColId = Math.max(this.maxColId, column.getId());
                if (!column.isExist()) continue;
                column.setName(column.getName());
                this.candidateNamedColumns.put(column.getAliasDotColumn(), column);
            }
        }

        private void inheritCandidateMeasures(NDataModel dataModel) {
            List measures = dataModel.getAllMeasures();
            for (NDataModel.Measure measure : measures) {
                this.maxMeasureId = Math.max(this.maxMeasureId, measure.getId());
                if (measure.isTomb()) continue;
                this.candidateMeasures.put(measure.getFunction(), measure);
            }
        }

        private void inheritJoinTables(NDataModel dataModel) {
            this.joins = dataModel.getJoinTables().toArray(new JoinTableDesc[0]);
        }

        private void injectAllTableColumns(OlapContext ctx) {
            ctx.getAllTableScans().forEach(tableScan -> this.allTableColumns.addAll(tableScan.getTableRef().getColumns()));
        }

        private void injectCandidateColumns(OlapContext olapContext) {
            TreeSet<TblColRef> allColumns = new TreeSet<TblColRef>(Comparator.comparing(TblColRef::getIdentity));
            allColumns.addAll(this.allTableColumns);
            Map<String, TblColRef> fKAsDimensionMap = this.modelContext.collectFkDimensionMap(olapContext);
            allColumns.forEach(tblColRef -> {
                boolean canTreatAsDim;
                boolean isNewDimension = canTreatAsDim = this.canTblColRefTreatAsDimension(fKAsDimensionMap, (TblColRef)tblColRef) || this.canTblColRefTreatAsDimension(olapContext, (TblColRef)tblColRef);
                if (this.candidateNamedColumns.containsKey(tblColRef.getIdentity())) {
                    NDataModel.NamedColumn namedColumn = this.candidateNamedColumns.get(tblColRef.getIdentity());
                    boolean existingDimension = namedColumn.isDimension();
                    NDataModel.ColumnStatus status = existingDimension || canTreatAsDim ? NDataModel.ColumnStatus.DIMENSION : NDataModel.ColumnStatus.EXIST;
                    isNewDimension = !existingDimension && canTreatAsDim;
                    namedColumn.setStatus(status);
                } else {
                    NDataModel.ColumnStatus status = canTreatAsDim ? NDataModel.ColumnStatus.DIMENSION : NDataModel.ColumnStatus.EXIST;
                    NDataModel.NamedColumn column = this.transferToNamedColumn((TblColRef)tblColRef, status);
                    this.candidateNamedColumns.put(tblColRef.getIdentity(), column);
                }
                if (isNewDimension) {
                    this.addDimRecommendation(this.candidateNamedColumns.get(tblColRef.getIdentity()), (TblColRef)tblColRef);
                }
            });
        }

        private void inheritAllNameColumn() {
            TreeSet allColumns = Sets.newTreeSet(Comparator.comparing(TblColRef::getIdentity));
            allColumns.addAll(this.allTableColumns);
            allColumns.forEach(tblColRef -> {
                if (!this.candidateNamedColumns.containsKey(tblColRef.getIdentity())) {
                    NDataModel.NamedColumn column = this.transferToNamedColumn((TblColRef)tblColRef, NDataModel.ColumnStatus.EXIST);
                    this.candidateNamedColumns.put(tblColRef.getIdentity(), column);
                }
            });
        }

        private void addDimRecommendation(NDataModel.NamedColumn column, TblColRef tblColRef) {
            if (this.modelContext.getProposeContext().skipCollectRecommendations()) {
                return;
            }
            String uniqueContent = RawRecUtil.dimensionUniqueContent((TblColRef)tblColRef, this.ccMap, this.newCcUuids);
            if (this.modelContext.getUniqueContentToFlag().containsKey(uniqueContent)) {
                return;
            }
            DimensionRecItemV2 item = new DimensionRecItemV2(column, tblColRef, uniqueContent);
            this.modelContext.getDimensionRecItemMap().putIfAbsent(item.getUuid(), item);
        }

        private void injectCandidateMeasure(OlapContext ctx) {
            this.preCheckBeforeInjectMeasures(ctx);
            ctx.getAggregations().forEach(agg -> {
                log.debug("aggregation from OlapContext is: {}", agg);
                LinkedHashSet paramNames = Sets.newLinkedHashSet();
                agg.getParameters().forEach(parameterDesc -> {
                    String identity = parameterDesc.getColRef().getIdentity();
                    paramNames.add(identity.replace(".", "_"));
                });
                boolean isNewMeasure = false;
                if (!this.candidateMeasures.containsKey(agg)) {
                    boolean isValidMeasure = CubeUtils.isValidMeasure(agg);
                    if (isValidMeasure) {
                        FunctionDesc fun = this.copyFunctionDesc((FunctionDesc)agg);
                        String name = String.format(Locale.ROOT, "%s_%s", fun.getExpression(), String.join((CharSequence)"_", paramNames));
                        NDataModel.Measure measure = CubeUtils.newMeasure(fun, name, ++this.maxMeasureId);
                        this.candidateMeasures.put(fun, measure);
                        isNewMeasure = true;
                    } else if (agg.canAnsweredByDimensionAsMeasure()) {
                        this.dimensionAsMeasureColumns.addAll(agg.getSourceColRefs());
                    } else if (paramNames.stream().anyMatch(param -> param.startsWith("UNKNOWN_ALIAS"))) {
                        throw new PendingException("Unsupported measure may caused by turning on only reusing used defined computed column." + agg);
                    }
                } else if (this.candidateMeasures.get(agg).isTomb()) {
                    String name = String.format(Locale.ROOT, "%s_%s", agg.getExpression(), String.join((CharSequence)"_", paramNames));
                    NDataModel.Measure measure = CubeUtils.newMeasure(agg, name, ++this.maxMeasureId);
                    this.candidateMeasures.put((FunctionDesc)agg, measure);
                    isNewMeasure = true;
                }
                if (isNewMeasure) {
                    NDataModel.Measure measure = this.candidateMeasures.get(agg);
                    this.addMeasureRecommendation(measure);
                }
            });
        }

        private void preCheckBeforeInjectMeasures(OlapContext ctx) {
            for (FunctionDesc agg : ctx.getAggregations()) {
                if (agg.canAnsweredByDimensionAsMeasure()) continue;
                if (this.modelContext.getAntiFlatChecker().isMeasureOfAntiLookup(agg)) {
                    throw new PendingException("Unsupported measure of anti flatten lookup table, stop the process of generate index. " + agg);
                }
                if (!this.modelContext.getExcludedChecker().isExcludedMeasure(agg)) continue;
                throw new PendingException("Unsupported measure of excluded columns, stop the process of generate index. " + agg);
            }
        }

        private void addMeasureRecommendation(NDataModel.Measure measure) {
            if (this.modelContext.getProposeContext().skipCollectRecommendations()) {
                return;
            }
            String uniqueContent = RawRecUtil.measureUniqueContent((NDataModel.Measure)measure, this.ccMap, this.newCcUuids);
            if (this.modelContext.getUniqueContentToFlag().containsKey(uniqueContent)) {
                return;
            }
            MeasureRecItemV2 item = new MeasureRecItemV2();
            item.setMeasure(measure);
            item.setCreateTime(System.currentTimeMillis());
            item.setUniqueContent(uniqueContent);
            item.setUuid(String.format(Locale.ROOT, "measure_%s", RandomUtil.randomUUIDStr()));
            this.modelContext.getMeasureRecItemMap().putIfAbsent(item.getUuid(), item);
        }

        private void build() {
            ArrayList measures = Lists.newArrayList(this.candidateMeasures.values());
            NDataModel.checkDuplicateMeasure((List)measures);
            this.dataModel.setAllMeasures((List)measures);
            ArrayList namedColumns = Lists.newArrayList(this.candidateNamedColumns.values());
            NDataModel.changeNameIfDup((List)namedColumns);
            NDataModel.checkDuplicateColumn((List)namedColumns);
            this.dataModel.setAllNamedColumns((List)namedColumns);
        }

        private ParameterDesc copyParameterDesc(ParameterDesc param) {
            ParameterDesc newParam = new ParameterDesc();
            newParam.setType(param.getType());
            if (param.isColumnType()) {
                newParam.setValue(param.getColRef().getIdentity());
            } else {
                newParam.setValue(param.getValue());
            }
            return newParam;
        }

        private FunctionDesc copyFunctionDesc(FunctionDesc orig) {
            TblColRef paramColRef = ((ParameterDesc)orig.getParameters().get(0)).getColRef();
            ArrayList newParams = Lists.newArrayList();
            orig.getParameters().forEach(parameterDesc -> newParams.add(this.copyParameterDesc((ParameterDesc)parameterDesc)));
            return CubeUtils.newFunctionDesc(this.dataModel, orig.getExpression(), newParams, paramColRef == null ? null : paramColRef.getDatatype());
        }

        private boolean canTblColRefTreatAsDimension(OlapContext ctx, TblColRef tblColRef) {
            if (this.modelContext.getAntiFlatChecker().isColOfAntiLookup(tblColRef)) {
                return false;
            }
            if (this.modelContext.getExcludedChecker().isExcludedCol(tblColRef)) {
                return false;
            }
            if (ctx.getSQLDigest().isRawQuery) {
                return ctx.getAllColumns().contains(tblColRef);
            }
            return ctx.getFilterColumns().contains(tblColRef) || ctx.getGroupByColumns().contains(tblColRef) || ctx.getSubqueryJoinParticipants().contains(tblColRef) || this.dimensionAsMeasureColumns.contains(tblColRef);
        }

        private boolean canTblColRefTreatAsDimension(Map<String, TblColRef> fKAsDimensionMap, TblColRef tblColRef) {
            return fKAsDimensionMap.containsKey(tblColRef.getCanonicalName());
        }

        protected NDataModel.NamedColumn transferToNamedColumn(TblColRef colRef, NDataModel.ColumnStatus status) {
            NDataModel.NamedColumn col = new NDataModel.NamedColumn();
            col.setName(colRef.getName());
            col.setAliasDotColumn(colRef.getIdentity());
            col.setId(++this.maxColId);
            col.setStatus(status);
            return col;
        }
    }
}

