/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.rec.query;

import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.util.NamedThreadFactory;
import org.apache.kylin.guava30.shaded.common.cache.Cache;
import org.apache.kylin.guava30.shaded.common.cache.CacheBuilder;
import org.apache.kylin.guava30.shaded.common.collect.Lists;
import org.apache.kylin.guava30.shaded.common.collect.Maps;
import org.apache.kylin.metadata.cube.model.NDataflowManager;
import org.apache.kylin.metadata.cube.model.NIndexPlanManager;
import org.apache.kylin.metadata.model.NDataModelManager;
import org.apache.kylin.metadata.model.NTableMetadataManager;
import org.apache.kylin.metadata.project.NProjectLoader;
import org.apache.kylin.query.relnode.ContextUtil;
import org.apache.kylin.query.relnode.OlapContext;
import org.apache.kylin.rec.query.QueryRecord;
import org.apache.kylin.rec.query.SQLResult;
import org.apache.kylin.rec.query.mockup.AbstractQueryExecutor;
import org.apache.kylin.rec.query.mockup.MockupQueryExecutor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractQueryRunner
implements Closeable {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AbstractQueryRunner.class);
    private final String[] sqls;
    protected KylinConfig kylinConfig;
    protected final String project;
    private final Cache<String, QueryRecord> queryCache = CacheBuilder.newBuilder().maximumSize(20L).build();
    private final Map<String, SQLResult> queryResults = new ConcurrentSkipListMap<String, SQLResult>();
    private final Map<String, Collection<OlapContext>> olapContexts = Maps.newLinkedHashMap();
    private static final ExecutorService SUGGESTION_EXECUTOR_POOL = Executors.newFixedThreadPool(KylinConfig.getInstanceFromEnv().getProposingThreadNum(), (ThreadFactory)new NamedThreadFactory("SuggestRunner"));

    AbstractQueryRunner(String project, String[] sqls) {
        this.project = Objects.requireNonNull(project);
        this.sqls = Objects.requireNonNull(sqls);
    }

    private void submitQueryExecute(CountDownLatch counter, AbstractQueryExecutor executor, KylinConfig kylinConfig, String project, String sql) {
        SUGGESTION_EXECUTOR_POOL.execute(() -> {
            try {
                if (!this.isQueryCached(sql)) {
                    try (KylinConfig.SetAndUnsetThreadLocalConfig autoUnset = KylinConfig.setAndUnsetThreadLocalConfig((KylinConfig)kylinConfig);){
                        NTableMetadataManager.getInstance((KylinConfig)autoUnset.get(), (String)project);
                        NDataModelManager.getInstance((KylinConfig)autoUnset.get(), (String)project);
                        NDataflowManager.getInstance((KylinConfig)autoUnset.get(), (String)project);
                        NIndexPlanManager.getInstance((KylinConfig)autoUnset.get(), (String)project);
                        NProjectLoader.updateCache((String)project);
                        QueryRecord record = executor.execute(project, autoUnset.get(), sql);
                        this.queryCache.put((Object)sql, (Object)record);
                    }
                }
                this.recordExecuteResult(sql);
            }
            finally {
                NProjectLoader.removeCache();
                ContextUtil.clearThreadLocalContexts();
                counter.countDown();
            }
        });
    }

    private void recordExecuteResult(String sql) {
        QueryRecord record = (QueryRecord)this.queryCache.getIfPresent((Object)sql);
        if (record == null) {
            log.error("The analysis result missing for sql: {}", (Object)sql);
        } else {
            this.queryResults.put(sql, record.getSqlResult());
            this.olapContexts.get(sql).addAll(record.getOlapContexts());
        }
    }

    private boolean isQueryCached(String sql) {
        QueryRecord record = (QueryRecord)this.queryCache.getIfPresent((Object)sql);
        return record != null && record.getSqlResult() != null && record.getSqlResult().getStatus() == SQLResult.Status.SUCCESS;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() throws IOException, InterruptedException {
        log.info("Mock query to generate OlapContexts applied to auto-modeling.");
        KylinConfig config = this.prepareConfig();
        try {
            MockupQueryExecutor queryExecutor = new MockupQueryExecutor();
            List<String> distinctSqls = Arrays.stream(this.sqls).distinct().collect(Collectors.toList());
            CountDownLatch latch = new CountDownLatch(distinctSqls.size());
            distinctSqls.forEach(sql -> this.olapContexts.put((String)sql, Lists.newArrayList()));
            distinctSqls.forEach(sql -> this.submitQueryExecute(latch, queryExecutor, config, this.project, (String)sql));
            latch.await();
        }
        finally {
            this.cleanupConfig(config);
        }
    }

    public abstract KylinConfig prepareConfig() throws IOException;

    public abstract void cleanupConfig(KylinConfig var1) throws IOException;

    public Map<String, List<OlapContext>> filterModelViewOlapContexts() {
        ArrayList modeViewOlapContextList = Lists.newArrayList();
        this.olapContexts.forEach((sql, olapContextList) -> {
            List<OlapContext> modelViewOlapContexts = olapContextList.stream().filter(e -> StringUtils.isNotEmpty((CharSequence)e.getBoundedModelAlias())).collect(Collectors.toList());
            if (CollectionUtils.isEmpty(modelViewOlapContexts)) {
                return;
            }
            modelViewOlapContexts.forEach(e -> e.setSql(sql));
            modeViewOlapContextList.addAll(modelViewOlapContexts);
        });
        return modeViewOlapContextList.stream().collect(Collectors.groupingBy(OlapContext::getBoundedModelAlias));
    }

    public Map<String, Collection<OlapContext>> filterNonModelViewOlapContexts() {
        return this.olapContexts.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, v -> ((Collection)v.getValue()).stream().filter(e -> StringUtils.isEmpty((CharSequence)e.getBoundedModelAlias())).collect(Collectors.toList()), (k1, k2) -> k1, LinkedHashMap::new));
    }

    @Override
    public void close() {
        this.queryCache.invalidateAll();
        this.queryResults.clear();
        this.olapContexts.clear();
    }

    @Generated
    public Map<String, SQLResult> getQueryResults() {
        return this.queryResults;
    }

    @Generated
    public Map<String, Collection<OlapContext>> getOlapContexts() {
        return this.olapContexts;
    }
}

