/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.rest.service;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.exception.ErrorCodeSupplier;
import org.apache.kylin.common.exception.KylinException;
import org.apache.kylin.common.exception.ServerErrorCode;
import org.apache.kylin.common.exception.code.ErrorCodeProducer;
import org.apache.kylin.common.exception.code.ErrorCodeServer;
import org.apache.kylin.common.msg.Message;
import org.apache.kylin.common.msg.MsgPicker;
import org.apache.kylin.common.persistence.RootPersistentEntity;
import org.apache.kylin.common.persistence.metadata.jdbc.JdbcUtil;
import org.apache.kylin.common.util.JsonUtil;
import org.apache.kylin.guava30.shaded.common.collect.ImmutableBiMap;
import org.apache.kylin.guava30.shaded.common.collect.ImmutableList;
import org.apache.kylin.guava30.shaded.common.collect.Lists;
import org.apache.kylin.guava30.shaded.common.collect.Maps;
import org.apache.kylin.guava30.shaded.common.collect.Sets;
import org.apache.kylin.metadata.cube.model.IndexEntity;
import org.apache.kylin.metadata.cube.model.IndexPlan;
import org.apache.kylin.metadata.cube.model.LayoutEntity;
import org.apache.kylin.metadata.cube.model.NDataflowManager;
import org.apache.kylin.metadata.cube.model.NIndexPlanManager;
import org.apache.kylin.metadata.favorite.FavoriteRule;
import org.apache.kylin.metadata.favorite.FavoriteRuleManager;
import org.apache.kylin.metadata.favorite.ModelFavoriteRuleManager;
import org.apache.kylin.metadata.model.ComputedColumnDesc;
import org.apache.kylin.metadata.model.NDataModel;
import org.apache.kylin.metadata.model.TblColRef;
import org.apache.kylin.metadata.project.EnhancedUnitOfWork;
import org.apache.kylin.metadata.project.NProjectManager;
import org.apache.kylin.metadata.realization.RealizationStatusEnum;
import org.apache.kylin.metadata.recommendation.entity.LayoutRecItemV2;
import org.apache.kylin.rec.AbstractContext;
import org.apache.kylin.rec.AbstractSemiContext;
import org.apache.kylin.rec.ModelCreateContext;
import org.apache.kylin.rec.ModelReuseContext;
import org.apache.kylin.rec.ModelSelectContext;
import org.apache.kylin.rec.ProposerJob;
import org.apache.kylin.rec.SmartMaster;
import org.apache.kylin.rec.common.AccelerateInfo;
import org.apache.kylin.rec.common.SmartConfig;
import org.apache.kylin.rec.runner.InMemoryJobRunner;
import org.apache.kylin.rest.request.AutoIndexPlanRuleUpdateRequest;
import org.apache.kylin.rest.request.ModelRequest;
import org.apache.kylin.rest.request.OpenSqlAccelerateRequest;
import org.apache.kylin.rest.response.LayoutRecDetailResponse;
import org.apache.kylin.rest.response.SuggestAndOptimizedResponse;
import org.apache.kylin.rest.response.SuggestionResponse;
import org.apache.kylin.rest.service.AbstractModelService;
import org.apache.kylin.rest.service.IndexPlanService;
import org.apache.kylin.rest.service.ModelService;
import org.apache.kylin.rest.service.ModelSmartServiceSupporter;
import org.apache.kylin.rest.service.OptRecService;
import org.apache.kylin.rest.service.ProjectSmartService;
import org.apache.kylin.rest.service.RawRecService;
import org.apache.kylin.rest.service.util.AutoIndexPlanRuleUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.datasource.DataSourceTransactionManager;
import org.springframework.stereotype.Component;

@Component(value="modelSmartService")
public class ModelSmartService
extends AbstractModelService
implements ModelSmartServiceSupporter {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ModelSmartService.class);
    private static final Integer AUTO_INDEX_PLAN_OPTION_ALWAYS_ON = 1;
    private static final Integer AUTO_INDEX_PLAN_OPTION_ALWAYS_OFF = 2;
    @Autowired
    private RawRecService rawRecService;
    @Autowired
    private OptRecService optRecService;
    @Autowired
    private ModelService modelService;
    @Autowired
    private IndexPlanService indexPlanService;
    @Autowired
    private ProjectSmartService projectSmartService;

    public SuggestAndOptimizedResponse generateSuggestion(OpenSqlAccelerateRequest request, boolean createNewModel) {
        AbstractContext proposeContext = this.suggestModel(request.getProject(), request.getSqls(), request.getForce2CreateNewModel() == false, createNewModel, request.getModelName());
        SuggestionResponse innerResponse = this.buildModelSuggestionResponse(proposeContext);
        Map<String, List<LayoutRecDetailResponse>> discardedLayoutRec = this.handleExtraOpt(innerResponse, request, proposeContext);
        List<ModelRequest> modelRequests = this.convertToModelRequest(innerResponse.getNewModels(), request);
        Set<String> modelIds = proposeContext.getModelContexts().stream().map(AbstractContext.ModelContext::getTargetModel).filter(Objects::nonNull).map(RootPersistentEntity::getId).collect(Collectors.toSet());
        this.recoverLayoutIfNeeded(innerResponse, discardedLayoutRec);
        if (request.isWithOptimalModel()) {
            this.fillOptimalModels(proposeContext, innerResponse);
        }
        if (!request.isAcceptRecommendation()) {
            this.rawRecService.transferAndSaveRecommendations(proposeContext);
        }
        return new SuggestAndOptimizedResponse(innerResponse, modelRequests, proposeContext.isCanCreateNewModel(), proposeContext.getProject(), modelIds, discardedLayoutRec);
    }

    private SuggestionResponse recoverLayoutIfNeeded(SuggestionResponse innerResponse, Map<String, List<LayoutRecDetailResponse>> discardedLayoutRec) {
        if (discardedLayoutRec.isEmpty()) {
            return innerResponse;
        }
        innerResponse.getReusedModels().forEach(model -> {
            if (discardedLayoutRec.containsKey(model.getUuid())) {
                model.getIndexes().addAll((Collection)discardedLayoutRec.get(model.getUuid()));
            }
        });
        return innerResponse;
    }

    private Map<String, List<LayoutRecDetailResponse>> handleExtraOpt(SuggestionResponse innerResponse, OpenSqlAccelerateRequest request, AbstractContext proposeContext) {
        HashMap result = Maps.newHashMap();
        if (!request.isDiscardTableIndex() || innerResponse.getReusedModels().isEmpty()) {
            return result;
        }
        for (SuggestionResponse.ModelRecResponse model : innerResponse.getReusedModels()) {
            Set toBeRemovedLayouts = model.getIndexPlan().getIndexes().stream().map(IndexEntity::getLayouts).flatMap(Collection::stream).filter(t -> IndexEntity.isTableIndex((long)t.getId()) && !t.isBase() && !t.isManual() && t.isAuto()).map(LayoutEntity::getId).collect(Collectors.toSet());
            ArrayList discardedLayouts = Lists.newArrayList();
            HashSet toBeRecoveredColumns = Sets.newHashSet();
            model.getIndexPlan().getIndexes().forEach(index -> index.getLayouts().removeIf(layout -> toBeRemovedLayouts.contains(layout.getId())));
            model.getIndexes().removeIf(layout -> {
                Set dimensions = layout.getDimensions().stream().filter(LayoutRecDetailResponse.RecDimension::isNew).map(LayoutRecDetailResponse.RecDimension::getDimension).map(NDataModel.NamedColumn::getId).collect(Collectors.toSet());
                if (toBeRemovedLayouts.contains(layout.getIndexId())) {
                    LayoutRecDetailResponse layoutCopy = (LayoutRecDetailResponse)JsonUtil.deepCopyQuietly((Object)layout, LayoutRecDetailResponse.class);
                    layoutCopy.setDiscarded(true);
                    discardedLayouts.add(layoutCopy);
                    toBeRecoveredColumns.addAll(dimensions);
                    return true;
                }
                toBeRecoveredColumns.removeIf(dimensions::contains);
                return false;
            });
            if (discardedLayouts.isEmpty()) continue;
            model.getAllNamedColumns().forEach(namedColumn -> {
                if (toBeRecoveredColumns.contains(namedColumn.getId())) {
                    namedColumn.setStatus(NDataModel.ColumnStatus.EXIST);
                }
            });
            model.getIndexPlan().getIndexes().removeIf(t -> t.getLayouts().isEmpty());
            model.getIndexPlan().getIndexes().forEach(t -> t.getDimensions().removeIf(toBeRecoveredColumns::contains));
            result.put(model.getUuid(), discardedLayouts);
            Map layoutMap = discardedLayouts.stream().collect(Collectors.toMap(LayoutRecDetailResponse::getIndexId, Function.identity()));
            String layoutStr = layoutMap.keySet().stream().map(Object::toString).collect(Collectors.joining(","));
            log.info(String.format(Locale.ROOT, "Discard table index %s in model [%s] via api control.", layoutStr, model.getAlias()));
            List<AbstractContext.ModelContext> contextList = proposeContext.getModelContexts().stream().filter(modelContext -> modelContext.getTargetModel() != null && modelContext.getTargetModel().getUuid().equals(model.getUuid())).collect(Collectors.toList());
            contextList.forEach(modelContext -> modelContext.getIndexRexItemMap().entrySet().removeIf(entry -> layoutMap.containsKey(((LayoutRecItemV2)entry.getValue()).getLayout().getId())));
        }
        return result;
    }

    private void fillOptimalModels(AbstractContext proposeContext, SuggestionResponse suggestionResponse) {
        ArrayList responseOfOptimalModels = Lists.newArrayList();
        suggestionResponse.setOptimalModels((List)responseOfOptimalModels);
        Map<String, AccelerateInfo> accelerateInfoMap = proposeContext.getAccelerateInfoMap();
        if (MapUtils.isEmpty(accelerateInfoMap)) {
            return;
        }
        HashSet reusedOrNewModelSqlSets = Sets.newHashSet();
        suggestionResponse.getReusedModels().stream().map(SuggestionResponse.ModelRecResponse::getIndexes).flatMap(Collection::stream).map(LayoutRecDetailResponse::getSqlList).forEach(reusedOrNewModelSqlSets::addAll);
        suggestionResponse.getNewModels().stream().map(SuggestionResponse.ModelRecResponse::getIndexes).flatMap(Collection::stream).map(LayoutRecDetailResponse::getSqlList).forEach(reusedOrNewModelSqlSets::addAll);
        HashSet constantSqlSet = Sets.newHashSet();
        HashMap errorOrOptimalAccelerateInfoMap = Maps.newHashMap();
        accelerateInfoMap.forEach((key, value) -> {
            if (reusedOrNewModelSqlSets.contains(key)) {
                return;
            }
            if (!value.isNotSucceed() && CollectionUtils.isEmpty(value.getRelatedLayouts())) {
                constantSqlSet.add(key);
            } else {
                errorOrOptimalAccelerateInfoMap.put(key, value);
            }
        });
        if (CollectionUtils.isNotEmpty((Collection)constantSqlSet)) {
            responseOfOptimalModels.add(this.buildConstantSqlRecResponse(Lists.newArrayList((Iterable)constantSqlSet)));
        }
        if (MapUtils.isEmpty((Map)errorOrOptimalAccelerateInfoMap)) {
            return;
        }
        HashSet finishedModelSets = Sets.newHashSet();
        for (AbstractContext.ModelContext modelContext : proposeContext.getModelContexts()) {
            if (modelContext.isTargetModelMissing() || modelContext.getOriginModel() == null || modelContext.getOriginModel().isStreaming() || finishedModelSets.contains(modelContext.getOriginModel().getUuid())) continue;
            try {
                this.collectResponseOfOptimalModels(modelContext, errorOrOptimalAccelerateInfoMap, responseOfOptimalModels);
                finishedModelSets.add(modelContext.getOriginModel().getUuid());
            }
            catch (Exception e) {
                log.error("Error occurs when collecting optimal models ", (Throwable)e);
            }
        }
    }

    private SuggestionResponse.ModelRecResponse buildConstantSqlRecResponse(List<String> constantSqlSet) {
        ArrayList indexRecItems = Lists.newArrayList();
        LayoutRecDetailResponse recDetailResponse = new LayoutRecDetailResponse();
        recDetailResponse.setSqlList((List)Lists.newArrayList(constantSqlSet));
        recDetailResponse.setIndexId(-1L);
        indexRecItems.add(recDetailResponse);
        SuggestionResponse.ModelRecResponse modelRecResponse = new SuggestionResponse.ModelRecResponse();
        modelRecResponse.setIndexes((List)indexRecItems);
        modelRecResponse.setAlias("CONSTANT");
        return modelRecResponse;
    }

    private void collectResponseOfOptimalModels(AbstractContext.ModelContext modelContext, Map<String, AccelerateInfo> errorOrOptimalAccelerateInfoMap, List<SuggestionResponse.ModelRecResponse> responseOfOptimalModels) {
        Map<Long, Set<String>> layoutIdToSqlSetMap = this.mapLayoutToErrorOrOptimalSqlSet(modelContext, errorOrOptimalAccelerateInfoMap);
        if (MapUtils.isEmpty(layoutIdToSqlSetMap)) {
            return;
        }
        NDataModel originModel = modelContext.getOriginModel();
        Map oriComputedColumnMap = originModel.getComputedColumnDescs().stream().collect(Collectors.toMap(ComputedColumnDesc::getFullName, Function.identity()));
        Map colsOfOriginModelMap = originModel.getAllNamedColumns().stream().collect(Collectors.toMap(NDataModel.NamedColumn::getId, Function.identity()));
        IndexPlan indexPlan = NIndexPlanManager.getInstance((KylinConfig)KylinConfig.getInstanceFromEnv(), (String)originModel.getProject()).getIndexPlan(originModel.getUuid());
        ArrayList indexRecItems = Lists.newArrayList();
        layoutIdToSqlSetMap.forEach((layoutId, optimalSqlSet) -> {
            LayoutEntity layoutEntity = indexPlan.getLayoutEntity(layoutId);
            LayoutRecDetailResponse response = new LayoutRecDetailResponse();
            ImmutableList colOrder = layoutEntity.getColOrder();
            HashMap computedColumnsMap = Maps.newHashMap();
            colOrder.forEach(idx -> {
                if (idx < 100000) {
                    ImmutableBiMap effectiveDimensions = originModel.getEffectiveDimensions();
                    NDataModel.NamedColumn col = (NDataModel.NamedColumn)colsOfOriginModelMap.get(idx);
                    TblColRef tblColRef = (TblColRef)originModel.getEffectiveCols().get(idx);
                    if (!effectiveDimensions.containsKey(idx) || null == col || null == tblColRef) {
                        return;
                    }
                    String dataType = ((TblColRef)effectiveDimensions.get(idx)).getDatatype();
                    response.getDimensions().add(new LayoutRecDetailResponse.RecDimension(col, false, dataType));
                    if (tblColRef.getColumnDesc().isComputedColumn() && oriComputedColumnMap.containsKey(tblColRef.getAliasDotName())) {
                        computedColumnsMap.put(tblColRef.getAliasDotName(), oriComputedColumnMap.get(tblColRef.getAliasDotName()));
                    }
                } else if (originModel.getEffectiveMeasures().containsKey(idx)) {
                    NDataModel.Measure measure = (NDataModel.Measure)originModel.getEffectiveMeasures().get(idx);
                    response.getMeasures().add(new LayoutRecDetailResponse.RecMeasure(measure, false));
                    List colRefs = measure.getFunction().getColRefs();
                    colRefs.forEach(colRef -> {
                        if (colRef.getColumnDesc().isComputedColumn() && oriComputedColumnMap.containsKey(colRef.getAliasDotName())) {
                            computedColumnsMap.put(colRef.getAliasDotName(), oriComputedColumnMap.get(colRef.getAliasDotName()));
                        }
                    });
                }
            });
            List computedColumnDescList = computedColumnsMap.values().stream().map(e -> new LayoutRecDetailResponse.RecComputedColumn(e, false)).collect(Collectors.toList());
            response.setComputedColumns(computedColumnDescList);
            response.setIndexId(layoutEntity.getId());
            response.setSqlList((List)Lists.newArrayList((Iterable)optimalSqlSet));
            indexRecItems.add(response);
        });
        SuggestionResponse.ModelRecResponse response = new SuggestionResponse.ModelRecResponse(originModel);
        response.setIndexPlan(indexPlan);
        response.setIndexes((List)indexRecItems);
        responseOfOptimalModels.add(response);
    }

    private Map<Long, Set<String>> mapLayoutToErrorOrOptimalSqlSet(AbstractContext.ModelContext modelContext, Map<String, AccelerateInfo> errorOrOptimalAccelerateInfoMap) {
        if (modelContext == null || MapUtils.isEmpty(errorOrOptimalAccelerateInfoMap)) {
            return Maps.newHashMap();
        }
        HashMap layoutToSqlSetMap = Maps.newHashMap();
        errorOrOptimalAccelerateInfoMap.forEach((sql, info) -> {
            for (AccelerateInfo.QueryLayoutRelation relation : info.getRelatedLayouts()) {
                if (!StringUtils.equalsIgnoreCase((CharSequence)relation.getModelId(), (CharSequence)modelContext.getOriginModel().getUuid())) continue;
                layoutToSqlSetMap.putIfAbsent(relation.getLayoutId(), Sets.newHashSet());
                ((Set)layoutToSqlSetMap.get(relation.getLayoutId())).add(relation.getSql());
            }
        });
        return layoutToSqlSetMap;
    }

    private List<ModelRequest> convertToModelRequest(List<SuggestionResponse.ModelRecResponse> newModels, OpenSqlAccelerateRequest request) {
        return newModels.stream().map(modelResponse -> {
            ModelRequest modelRequest = new ModelRequest((NDataModel)modelResponse);
            modelRequest.setIndexPlan(modelResponse.getIndexPlan());
            modelRequest.setWithEmptySegment(request.isWithEmptySegment());
            modelRequest.setWithModelOnline(request.isWithModelOnline());
            modelRequest.setWithBaseIndex(request.isWithBaseIndex());
            return modelRequest;
        }).collect(Collectors.toList());
    }

    public AbstractContext probeRecommendation(String project, List<String> sqls) {
        if (this.modelService.isProjectNotExist(project)) {
            throw new KylinException((ErrorCodeProducer)ErrorCodeServer.PROJECT_NOT_EXIST, new Object[]{project});
        }
        ModelSelectContext proposeContext = new ModelSelectContext(NProjectManager.getProjectConfig((String)project), project, sqls.toArray(new String[0]));
        this.fillExtraMeta(proposeContext);
        new SmartMaster(proposeContext).runWithContext(null);
        return proposeContext;
    }

    private void fillExtraMeta(AbstractContext proposeContext) {
        KylinConfig config = proposeContext.getSmartConfig().getKylinConfig();
        Set allModelIdSet = proposeContext.getRelatedModels().stream().map(RootPersistentEntity::getUuid).collect(Collectors.toSet());
        String project = proposeContext.getProject();
        HashSet onlineModelIdSet = Sets.newHashSet();
        HashSet allModelNames = Sets.newHashSet();
        NDataflowManager.getInstance((KylinConfig)config, (String)project).listAllDataflows(true).forEach(df -> {
            NDataModel model = df.getModel();
            allModelNames.add(model.getAlias().toLowerCase(Locale.ROOT));
            if (model.isBroken() || !allModelIdSet.contains(model.getUuid()) || model.isFusionModel()) {
                return;
            }
            if (df.getStatus() == RealizationStatusEnum.ONLINE) {
                onlineModelIdSet.add(model.getUuid());
            }
        });
        String modelOptRule = proposeContext.getSmartConfig().getModelOptRule();
        proposeContext.getExtraMeta().setOnlineModelIds(onlineModelIdSet);
        proposeContext.getExtraMeta().setAllModels(allModelNames);
        proposeContext.getExtraMeta().setModelOptRule(modelOptRule);
    }

    public boolean couldAnsweredByExistedModel(String project, List<String> sqls) {
        this.aclEvaluate.checkProjectWritePermission(project);
        if (CollectionUtils.isEmpty(sqls)) {
            return true;
        }
        AbstractContext proposeContext = this.probeRecommendation(project, sqls);
        List models = proposeContext.getProposedModels().stream().filter(model -> !model.isStreaming()).collect(Collectors.toList());
        return CollectionUtils.isNotEmpty(models);
    }

    public AbstractContext suggestModel(String project, List<String> sqls, boolean reuseExistedModel, boolean createNewModel) {
        return this.suggestModel(project, sqls, reuseExistedModel, createNewModel, null);
    }

    public AbstractContext suggestModel(String project, List<String> sqls, boolean reuseExistedModel, boolean createNewModel, String modelName) {
        this.aclEvaluate.checkProjectWritePermission(project);
        if (CollectionUtils.isEmpty(sqls)) {
            return null;
        }
        KylinConfig kylinConfig = NProjectManager.getProjectConfig((String)project);
        this.checkBatchSqlSize(kylinConfig, sqls);
        String[] sqlArray = sqls.toArray(new String[0]);
        AbstractSemiContext proposeContext = SmartConfig.wrap(kylinConfig).getModelOptRule().equalsIgnoreCase("append") ? (!reuseExistedModel && createNewModel ? new ModelCreateContext(kylinConfig, project, sqlArray) : new ModelReuseContext(kylinConfig, project, sqlArray, true)) : (reuseExistedModel ? new ModelReuseContext(kylinConfig, project, sqlArray, createNewModel) : new ModelCreateContext(kylinConfig, project, sqlArray));
        proposeContext.setModelName(modelName);
        return ProposerJob.propose(proposeContext, (config, runnerType, projectName, resources) -> new InMemoryJobRunner(config, projectName, resources));
    }

    public SuggestionResponse buildModelSuggestionResponse(AbstractContext context) {
        ArrayList responseOfNewModels = Lists.newArrayList();
        ArrayList responseOfReusedModels = Lists.newArrayList();
        for (AbstractContext.ModelContext modelContext : context.getModelContexts()) {
            if (modelContext.isTargetModelMissing()) continue;
            if (modelContext.getOriginModel() != null) {
                this.collectResponseOfReusedModels(modelContext, responseOfReusedModels);
                continue;
            }
            this.collectResponseOfNewModels(context, modelContext, responseOfNewModels);
        }
        responseOfReusedModels.removeIf(NDataModel::isStreaming);
        return new SuggestionResponse((List)responseOfReusedModels, (List)responseOfNewModels);
    }

    private void checkBatchSqlSize(KylinConfig kylinConfig, List<String> sqls) {
        Message msg = MsgPicker.getMsg();
        int limit = kylinConfig.getSuggestModelSqlLimit();
        if (sqls.size() > limit) {
            throw new KylinException((ErrorCodeSupplier)ServerErrorCode.SQL_NUMBER_EXCEEDS_LIMIT, String.format(Locale.ROOT, msg.getSqlNumberExceedsLimit(), limit));
        }
    }

    private void collectResponseOfReusedModels(AbstractContext.ModelContext modelContext, List<SuggestionResponse.ModelRecResponse> responseOfReusedModels) {
        if (modelContext.isSnapshotSelected()) {
            return;
        }
        this.collectResponseOfReusedModelsInner(modelContext, responseOfReusedModels);
    }

    private void collectResponseOfReusedModelsInner(AbstractContext.ModelContext modelContext, List<SuggestionResponse.ModelRecResponse> responseOfReusedModels) {
        Map<Long, Set<String>> layoutToSqlSet = this.mapLayoutToSqlSet(modelContext);
        HashMap oriCCMap = Maps.newHashMap();
        List oriCCList = modelContext.getOriginModel().getComputedColumnDescs();
        oriCCList.forEach(cc -> oriCCMap.put(cc.getFullName(), cc));
        HashMap ccMap = Maps.newHashMap();
        List ccList = modelContext.getTargetModel().getComputedColumnDescs();
        ccList.forEach(cc -> ccMap.put(cc.getFullName(), cc));
        NDataModel targetModel = modelContext.getTargetModel();
        NDataModel originModel = modelContext.getOriginModel();
        ArrayList indexRecItems = Lists.newArrayList();
        modelContext.getIndexRexItemMap().forEach((key, layoutRecItemV2) -> {
            LayoutRecDetailResponse response = new LayoutRecDetailResponse();
            LayoutEntity layout = layoutRecItemV2.getLayout();
            ImmutableList colOrder = layout.getColOrder();
            HashMap ccStateMap = Maps.newHashMap();
            HashMap colsOfTargetModelMap = Maps.newHashMap();
            targetModel.getAllNamedColumns().forEach(col -> colsOfTargetModelMap.put(col.getId(), col));
            colOrder.forEach(idx -> {
                if (idx < 100000 && originModel.getEffectiveDimensions().containsKey(idx)) {
                    NDataModel.NamedColumn col = (NDataModel.NamedColumn)colsOfTargetModelMap.get(idx);
                    String dataType = ((TblColRef)originModel.getEffectiveDimensions().get(idx)).getDatatype();
                    response.getDimensions().add(new LayoutRecDetailResponse.RecDimension(col, false, dataType));
                } else if (idx < 100000) {
                    NDataModel.NamedColumn col = (NDataModel.NamedColumn)colsOfTargetModelMap.get(idx);
                    TblColRef tblColRef = (TblColRef)targetModel.getEffectiveCols().get(idx);
                    String colRefAliasDotName = tblColRef.getAliasDotName();
                    if (tblColRef.getColumnDesc().isComputedColumn() && !oriCCMap.containsKey(colRefAliasDotName)) {
                        ccStateMap.putIfAbsent(ccMap.get(colRefAliasDotName), true);
                    }
                    String dataType = tblColRef.getDatatype();
                    response.getDimensions().add(new LayoutRecDetailResponse.RecDimension(col, true, dataType));
                } else if (originModel.getEffectiveMeasures().containsKey(idx)) {
                    NDataModel.Measure measure = (NDataModel.Measure)targetModel.getEffectiveMeasures().get(idx);
                    response.getMeasures().add(new LayoutRecDetailResponse.RecMeasure(measure, false));
                } else {
                    NDataModel.Measure measure = (NDataModel.Measure)targetModel.getEffectiveMeasures().get(idx);
                    List colRefs = measure.getFunction().getColRefs();
                    colRefs.forEach(colRef -> {
                        String colRefAliasDotName = colRef.getAliasDotName();
                        if (colRef.getColumnDesc().isComputedColumn() && !oriCCMap.containsKey(colRefAliasDotName)) {
                            ccStateMap.putIfAbsent(ccMap.get(colRefAliasDotName), true);
                        }
                    });
                    response.getMeasures().add(new LayoutRecDetailResponse.RecMeasure(measure, true));
                }
            });
            ArrayList newCCList = Lists.newArrayList();
            ccStateMap.forEach((k, v) -> newCCList.add(new LayoutRecDetailResponse.RecComputedColumn(k, v.booleanValue())));
            response.setComputedColumns((List)newCCList);
            response.setIndexId(layout.getId());
            Set sqlSet = (Set)layoutToSqlSet.get(layout.getId());
            if (CollectionUtils.isNotEmpty((Collection)sqlSet)) {
                response.setSqlList((List)Lists.newArrayList((Iterable)sqlSet));
            }
            indexRecItems.add(response);
        });
        SuggestionResponse.ModelRecResponse response = new SuggestionResponse.ModelRecResponse(targetModel);
        response.setIndexPlan(modelContext.getTargetIndexPlan());
        response.setIndexes((List)indexRecItems);
        responseOfReusedModels.add(response);
    }

    private Map<Long, Set<String>> mapLayoutToSqlSet(AbstractContext.ModelContext modelContext) {
        if (modelContext == null) {
            return Maps.newHashMap();
        }
        Map<String, AccelerateInfo> accelerateInfoMap = modelContext.getProposeContext().getAccelerateInfoMap();
        HashMap layoutToSqlSet = Maps.newHashMap();
        accelerateInfoMap.forEach((sql, info) -> {
            for (AccelerateInfo.QueryLayoutRelation relation : info.getRelatedLayouts()) {
                if (!StringUtils.equalsIgnoreCase((CharSequence)relation.getModelId(), (CharSequence)modelContext.getTargetModel().getUuid())) continue;
                layoutToSqlSet.putIfAbsent(relation.getLayoutId(), Sets.newHashSet());
                ((Set)layoutToSqlSet.get(relation.getLayoutId())).add(relation.getSql());
            }
        });
        return layoutToSqlSet;
    }

    private void collectResponseOfNewModels(AbstractContext context, AbstractContext.ModelContext modelContext, List<SuggestionResponse.ModelRecResponse> responseOfNewModels) {
        List sqlList = context.getAccelerateInfoMap().entrySet().stream().filter(entry -> ((AccelerateInfo)entry.getValue()).getRelatedLayouts().stream().anyMatch(relation -> relation.getModelId().equals(modelContext.getTargetModel().getId()))).map(Map.Entry::getKey).collect(Collectors.toList());
        NDataModel model = modelContext.getTargetModel();
        IndexPlan indexPlan = modelContext.getTargetIndexPlan();
        ImmutableBiMap effectiveDimensions = model.getEffectiveDimensions();
        List recDims = model.getAllNamedColumns().stream().filter(NDataModel.NamedColumn::isDimension).map(c -> {
            String datatype = ((TblColRef)effectiveDimensions.get((Object)c.getId())).getDatatype();
            return new LayoutRecDetailResponse.RecDimension(c, true, datatype);
        }).collect(Collectors.toList());
        List recMeasures = model.getAllMeasures().stream().map(measure -> new LayoutRecDetailResponse.RecMeasure(measure, true)).collect(Collectors.toList());
        List recCCList = model.getComputedColumnDescs().stream().map(cc -> new LayoutRecDetailResponse.RecComputedColumn(cc, true)).collect(Collectors.toList());
        LayoutRecDetailResponse virtualResponse = new LayoutRecDetailResponse();
        virtualResponse.setIndexId(-1L);
        virtualResponse.setDimensions(recDims);
        virtualResponse.setMeasures(recMeasures);
        virtualResponse.setComputedColumns(recCCList);
        virtualResponse.setSqlList(sqlList);
        SuggestionResponse.ModelRecResponse response = new SuggestionResponse.ModelRecResponse(model);
        response.setIndexPlan(indexPlan);
        response.setIndexes((List)Lists.newArrayList((Object[])new LayoutRecDetailResponse[]{virtualResponse}));
        responseOfNewModels.add(response);
    }

    public Map<String, Object> getAutoIndexPlanRule(String modelId, String project) {
        Map<String, Object> projectRules = this.projectSmartService.getAutoIndexPlanRule(project);
        HashMap<String, Object> result = new HashMap<String, Object>(projectRules);
        ModelFavoriteRuleManager manager = ModelFavoriteRuleManager.getInstance((String)project, (String)modelId);
        FavoriteRule.AUTO_INDEX_PLAN_RULE_NAMES.stream().filter(ruleName -> !ruleName.equals("index_planner_enable")).map(arg_0 -> ((ModelFavoriteRuleManager)manager).getByName(arg_0)).filter(Objects::nonNull).forEach(rule -> result.put(rule.getName(), AutoIndexPlanRuleUtil.getRuleValue(rule)));
        Integer option = (Integer)AutoIndexPlanRuleUtil.getRuleValue(manager.getByName("auto_index_plan_option"));
        result.put("auto_index_plan_option", option == null ? 0 : option);
        if (AUTO_INDEX_PLAN_OPTION_ALWAYS_ON.equals(option) && this.projectSmartService.isEnableAutoSemi(project)) {
            result.put("index_planner_enable", true);
        } else if (AUTO_INDEX_PLAN_OPTION_ALWAYS_OFF.equals(option)) {
            result.put("index_planner_enable", false);
        }
        return result;
    }

    public Map<String, Object> getIndexPlannerRule(String modelId, String project) {
        Map<String, Object> projectRules = this.projectSmartService.getAutoIndexPlanRule(project);
        HashMap<String, Object> result = new HashMap<String, Object>(projectRules);
        ModelFavoriteRuleManager manager = ModelFavoriteRuleManager.getInstance((String)project, (String)modelId);
        FavoriteRule.INDEX_PLANNER_RULE_NAMES.stream().map(arg_0 -> ((ModelFavoriteRuleManager)manager).getByName(arg_0)).filter(Objects::nonNull).forEach(rule -> result.put(rule.getName(), AutoIndexPlanRuleUtil.getRuleValue(rule)));
        if (!this.projectSmartService.isEnableAutoSemi(project)) {
            result.put("index_planner_enable", false);
        }
        return result;
    }

    public boolean isAutoIndexPlanEnabled(String modelId, String project) {
        ModelFavoriteRuleManager modelManager = ModelFavoriteRuleManager.getInstance((String)project, (String)modelId);
        FavoriteRule modelRule = modelManager.getByName("auto_index_plan_option");
        Object modelOption = AutoIndexPlanRuleUtil.getRuleValue(modelRule);
        if (!this.projectSmartService.isEnableAutoSemi(project)) {
            return false;
        }
        if (modelOption != null) {
            Integer option = (Integer)modelOption;
            if (option.equals(AUTO_INDEX_PLAN_OPTION_ALWAYS_ON)) {
                return true;
            }
            if (option.equals(AUTO_INDEX_PLAN_OPTION_ALWAYS_OFF)) {
                return false;
            }
        }
        FavoriteRuleManager projectManager = FavoriteRuleManager.getInstance((String)project);
        FavoriteRule projectRule = projectManager.getByName("index_planner_enable");
        Object projectSwitch = AutoIndexPlanRuleUtil.getRuleValue(projectRule);
        return Objects.equals(projectSwitch, true);
    }

    public void updateAutoIndexPlanRule(String modelId, AutoIndexPlanRuleUpdateRequest request) {
        this.aclEvaluate.checkProjectWritePermission(request.getProject());
        ModelFavoriteRuleManager manager = ModelFavoriteRuleManager.getInstance((String)request.getProject(), (String)modelId);
        JdbcUtil.withTxAndRetry((DataSourceTransactionManager)manager.getTransactionManager(), () -> {
            FavoriteRule.AUTO_INDEX_PLAN_RULE_NAMES.forEach(ruleName -> {
                if ("index_planner_enable".equals(ruleName)) {
                    return;
                }
                List<FavoriteRule.AbstractCondition> conds = AutoIndexPlanRuleUtil.getConditionsFromUpdateRequest(ruleName, request);
                manager.updateRule(conds, true, ruleName);
            });
            return null;
        });
    }

    public List<Long> getAutoIndexPlanWhiteList(String modelId, String project) {
        IndexPlan indexPlan = this.getIndexPlan(modelId, project);
        return indexPlan.getPlannerWhiteList();
    }

    public void addToAutoIndexPlanWhiteList(String modelId, String project, List<Long> toAddList) {
        NIndexPlanManager indexPlanManager = NIndexPlanManager.getInstance((KylinConfig)KylinConfig.getInstanceFromEnv(), (String)project);
        IndexPlan indexPlan = indexPlanManager.getIndexPlan(modelId);
        Set existingLayoutIds = indexPlan.getAllLayoutIds(false);
        if (!existingLayoutIds.containsAll(toAddList)) {
            HashSet<Long> diffSet = new HashSet<Long>(toAddList);
            diffSet.removeAll(existingLayoutIds);
            throw new KylinException((ErrorCodeSupplier)ServerErrorCode.WHITELIST_NOT_IN_INDEXES, String.format(Locale.ROOT, MsgPicker.getMsg().getWhiteListNotInExistingIndex(), StringUtils.join(diffSet, (String)",")));
        }
        ArrayList existingWhiteList = new ArrayList(indexPlan.getPlannerWhiteList());
        if (existingWhiteList.containsAll(toAddList)) {
            return;
        }
        EnhancedUnitOfWork.doInTransactionWithCheckAndRetry(() -> {
            NIndexPlanManager idpMgr = NIndexPlanManager.getInstance((KylinConfig)KylinConfig.getInstanceFromEnv(), (String)project);
            idpMgr.updateIndexPlan(indexPlan.getUuid(), copyForWrite -> {
                LinkedHashSet allWhiteList = new LinkedHashSet(copyForWrite.getPlannerWhiteList());
                allWhiteList.addAll(toAddList);
                copyForWrite.setPlannerWhiteList(new ArrayList(allWhiteList));
            });
            return null;
        }, (String)project);
    }

    public void deleteFromAutoIndexPlanWhiteList(String modelId, String project, List<Long> toRemoveList) {
        NIndexPlanManager indexPlanManager = (NIndexPlanManager)this.getManager(NIndexPlanManager.class, project);
        IndexPlan indexPlan = indexPlanManager.getIndexPlan(modelId);
        ArrayList existingWhiteList = new ArrayList(indexPlan.getPlannerWhiteList());
        if (!existingWhiteList.containsAll(toRemoveList)) {
            HashSet<Long> diffSet = new HashSet<Long>(toRemoveList);
            diffSet.removeAll(existingWhiteList);
            throw new KylinException((ErrorCodeSupplier)ServerErrorCode.INDEXES_NOT_IN_WHITELIST, String.format(Locale.ROOT, MsgPicker.getMsg().getIndexesNotInWhiteList(), StringUtils.join(diffSet, (String)",")));
        }
        EnhancedUnitOfWork.doInTransactionWithCheckAndRetry(() -> {
            NIndexPlanManager idpMgr = NIndexPlanManager.getInstance((KylinConfig)KylinConfig.getInstanceFromEnv(), (String)project);
            idpMgr.updateIndexPlan(indexPlan.getUuid(), copyForWrite -> {
                ArrayList allWhiteList = new ArrayList(copyForWrite.getPlannerWhiteList());
                allWhiteList.removeAll(toRemoveList);
                copyForWrite.setPlannerWhiteList(new ArrayList(allWhiteList));
            });
            return null;
        }, (String)project);
    }
}

