/*
 * Decompiled with CFR 0.152.
 */
package alluxio;

import alluxio.AlluxioURI;
import java.util.Collections;
import java.util.Map;
import java.util.Set;

public class SyncInfo {
    public static final long INVALID_TXID = -1L;
    private static final SyncInfo EMPTY_INFO = new SyncInfo(Collections.emptyMap(), false, -1L);
    private final Map<AlluxioURI, Set<AlluxioURI>> mChangedFilesMap;
    private final boolean mForceSync;
    private final long mTxId;

    public SyncInfo(Map<AlluxioURI, Set<AlluxioURI>> changedFiles, boolean forceSync, long txId) {
        this.mChangedFilesMap = changedFiles;
        this.mForceSync = forceSync;
        this.mTxId = txId;
    }

    public static SyncInfo emptyInfo() {
        return EMPTY_INFO;
    }

    public Set<AlluxioURI> getSyncPoints() {
        return this.mChangedFilesMap.keySet();
    }

    public Set<AlluxioURI> getChangedFiles(AlluxioURI syncPoint) {
        return this.mChangedFilesMap.get(syncPoint);
    }

    public boolean isForceSync() {
        return this.mForceSync;
    }

    public long getTxId() {
        return this.mTxId;
    }
}

