/*
 * Decompiled with CFR 0.152.
 */
package alluxio.client.file.cache;

import alluxio.shaded.client.com.google.common.base.MoreObjects;
import alluxio.shaded.client.com.google.common.base.Objects;
import alluxio.shaded.client.javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public class PageId {
    private final String mFileId;
    private final long mPageIndex;

    public PageId(String fileId, long pageIndex) {
        this.mFileId = fileId;
        this.mPageIndex = pageIndex;
    }

    public String getFileId() {
        return this.mFileId;
    }

    public long getPageIndex() {
        return this.mPageIndex;
    }

    public int hashCode() {
        return Objects.hashCode(this.mFileId, this.mPageIndex);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof PageId)) {
            return false;
        }
        PageId that = (PageId)obj;
        return this.mFileId.equals(that.mFileId) && this.mPageIndex == that.mPageIndex;
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("FileId", this.mFileId).add("PageIndex", this.mPageIndex).toString();
    }
}

