/*
 * Decompiled with CFR 0.152.
 */
package alluxio.refresh;

import alluxio.refresh.RefreshPolicy;
import alluxio.shaded.client.com.google.common.base.Preconditions;
import alluxio.shaded.client.javax.annotation.concurrent.NotThreadSafe;
import alluxio.util.CommonUtils;

@NotThreadSafe
public class TimeoutRefresh
implements RefreshPolicy {
    private final long mRefreshPeriodMs;
    private long mLastAttempTimeMs = 0L;
    private boolean mFirstAttempt = true;

    public TimeoutRefresh(long refreshPeriodMs) {
        Preconditions.checkArgument(refreshPeriodMs > 0L, "Retry timeout must be a positive number");
        this.mRefreshPeriodMs = refreshPeriodMs;
    }

    @Override
    public boolean attempt() {
        if (this.mFirstAttempt || CommonUtils.getCurrentMs() - this.mLastAttempTimeMs > this.mRefreshPeriodMs) {
            this.mLastAttempTimeMs = CommonUtils.getCurrentMs();
            this.mFirstAttempt = false;
            return true;
        }
        return false;
    }
}

