/*
 * Decompiled with CFR 0.152.
 */
package alluxio.security.authentication;

import alluxio.grpc.ChannelAuthenticationScheme;
import alluxio.grpc.SaslMessage;
import alluxio.grpc.SaslMessageType;
import alluxio.security.authentication.SaslClientHandler;
import alluxio.shaded.client.com.google.common.base.Preconditions;
import alluxio.shaded.client.com.google.protobuf.ByteString;
import javax.security.sasl.SaslClient;
import javax.security.sasl.SaslException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractSaslClientHandler
implements SaslClientHandler {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractSaslClientHandler.class);
    private static final byte[] S_INITIATE_CHALLENGE = new byte[0];
    private final ChannelAuthenticationScheme mAuthScheme;
    protected SaslClient mSaslClient;

    public AbstractSaslClientHandler(ChannelAuthenticationScheme authScheme) {
        this.mAuthScheme = authScheme;
    }

    @Override
    public synchronized SaslMessage handleMessage(SaslMessage message) throws SaslException {
        if (this.mSaslClient == null) {
            throw new SaslException("SaslClient handler is closed");
        }
        if (message == null) {
            byte[] initiateSaslResponse;
            SaslMessage.Builder initialResponse = SaslMessage.newBuilder().setMessageType(SaslMessageType.CHALLENGE).setAuthenticationScheme(this.mAuthScheme);
            if (this.mSaslClient.hasInitialResponse() && (initiateSaslResponse = this.mSaslClient.evaluateChallenge(S_INITIATE_CHALLENGE)) != null) {
                initialResponse.setMessage(ByteString.copyFrom(initiateSaslResponse));
            }
            return initialResponse.build();
        }
        switch (message.getMessageType()) {
            case CHALLENGE: {
                byte[] saslResponse = this.mSaslClient.evaluateChallenge(message.getMessage().toByteArray());
                SaslMessage.Builder response = SaslMessage.newBuilder().setMessageType(SaslMessageType.CHALLENGE);
                if (saslResponse != null) {
                    response.setMessage(ByteString.copyFrom(saslResponse));
                }
                return response.build();
            }
            case SUCCESS: {
                if (message.hasMessage()) {
                    this.mSaslClient.evaluateChallenge(message.getMessage().toByteArray());
                }
                Preconditions.checkArgument(this.mSaslClient.isComplete());
                return null;
            }
        }
        throw new SaslException("Client can't process Sasl message type:" + message.getMessageType().name());
    }

    @Override
    public synchronized void close() {
        if (this.mSaslClient != null) {
            try {
                this.mSaslClient.dispose();
            }
            catch (SaslException exc) {
                LOG.debug("Failed to close SaslClient.", (Throwable)exc);
            }
            finally {
                this.mSaslClient = null;
            }
        }
    }
}

