/*
 * Decompiled with CFR 0.152.
 */
package alluxio.shaded.client.com.rabbitmq.client.impl;

import alluxio.shaded.client.com.rabbitmq.client.Command;
import alluxio.shaded.client.com.rabbitmq.client.Method;
import alluxio.shaded.client.com.rabbitmq.client.ShutdownSignalException;
import alluxio.shaded.client.com.rabbitmq.client.impl.AMQChannel;
import alluxio.shaded.client.com.rabbitmq.client.impl.AMQCommand;
import alluxio.shaded.client.com.rabbitmq.client.impl.RpcWrapper;
import java.util.concurrent.CompletableFuture;

public class CompletableFutureRpcWrapper
implements RpcWrapper {
    private final Method request;
    private final CompletableFuture<Command> completableFuture;

    public CompletableFutureRpcWrapper(Method method, CompletableFuture<Command> completableFuture) {
        this.request = method;
        this.completableFuture = completableFuture;
    }

    @Override
    public boolean canHandleReply(AMQCommand command) {
        return AMQChannel.SimpleBlockingRpcContinuation.isResponseCompatibleWithRequest(this.request, command.getMethod());
    }

    @Override
    public void complete(AMQCommand command) {
        this.completableFuture.complete(command);
    }

    @Override
    public void shutdown(ShutdownSignalException signal) {
        this.completableFuture.completeExceptionally(signal);
    }
}

