/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.sdk.datasource.adaptor;

import java.util.Map;
import lombok.Generated;

public class AdaptorConfig {
    public final String url;
    public final String driver;
    public final String username;
    public final String password;
    public String datasourceId;
    public int poolMaxIdle = 10;
    public int poolMaxTotal = 10;
    public int poolMinIdle = 2;
    public long timeBetweenEvictionRunsMillis = 15000L;
    public long maxWait = 60000L;
    private int connectRetryTimes = 1;
    private long sleepMillisecBetweenRetry = 100L;
    public Map<String, String> options;

    public AdaptorConfig(String url, String driver, String username, String password, Map<String, String> options) {
        this.url = url;
        this.driver = driver;
        this.username = username;
        this.password = password;
        this.options = options;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AdaptorConfig that = (AdaptorConfig)o;
        if (this.poolMaxIdle != that.poolMaxIdle) {
            return false;
        }
        if (this.poolMaxTotal != that.poolMaxTotal) {
            return false;
        }
        if (this.poolMinIdle != that.poolMinIdle) {
            return false;
        }
        if (!this.url.equals(that.url)) {
            return false;
        }
        if (!this.driver.equals(that.driver)) {
            return false;
        }
        if (!this.username.equals(that.username)) {
            return false;
        }
        if (this.password != null ? !this.password.equals(that.password) : that.password != null) {
            return false;
        }
        return this.datasourceId != null ? this.datasourceId.equals(that.datasourceId) : that.datasourceId == null;
    }

    public int hashCode() {
        int result = this.url.hashCode();
        result = 31 * result + this.driver.hashCode();
        result = 31 * result + this.username.hashCode();
        result = 31 * result + (this.password != null ? this.password.hashCode() : 0);
        result = 31 * result + (this.datasourceId != null ? this.datasourceId.hashCode() : 0);
        result = 31 * result + this.poolMaxIdle;
        result = 31 * result + this.poolMaxTotal;
        result = 31 * result + this.poolMinIdle;
        return result;
    }

    public int getConnectRetryTimes() {
        return this.connectRetryTimes;
    }

    public void setConnectRetryTimes(int connectRetryTimes) {
        this.connectRetryTimes = connectRetryTimes;
    }

    public long getSleepMillisecBetweenRetry() {
        return this.sleepMillisecBetweenRetry;
    }

    public void setSleepMillisecBetweenRetry(long sleepMillisecBetweenRetry) {
        this.sleepMillisecBetweenRetry = sleepMillisecBetweenRetry;
    }

    @Generated
    public Map<String, String> getOptions() {
        return this.options;
    }
}

