/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.engine.spark.builder;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import org.apache.commons.collections.CollectionUtils;
import org.apache.kylin.metadata.cube.model.LayoutEntity;
import org.apache.kylin.metadata.cube.model.LayoutPartition;
import org.apache.kylin.metadata.cube.model.NDataLayout;
import org.apache.kylin.metadata.cube.model.NDataSegment;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.datasource.storage.StorageStoreUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DFLayoutMergeAssist
implements Serializable {
    protected static final Logger logger = LoggerFactory.getLogger(DFLayoutMergeAssist.class);
    private static final int DEFAULT_BUFFER_SIZE = 256;
    private final List<NDataLayout> toMergeCuboids = new ArrayList<NDataLayout>();
    private LayoutEntity layout;
    private NDataSegment newSegment;
    private List<NDataSegment> toMergeSegments;
    private SparkSession ss;

    public void setSs(SparkSession ss) {
        this.ss = ss;
    }

    public LayoutEntity getLayout() {
        return this.layout;
    }

    public void setLayout(LayoutEntity layout) {
        this.layout = layout;
    }

    public List<NDataLayout> getCuboids() {
        return this.toMergeCuboids;
    }

    public void addCuboid(NDataLayout cuboid) {
        this.toMergeCuboids.add(cuboid);
    }

    public void setToMergeSegments(List<NDataSegment> segments) {
        this.toMergeSegments = segments;
    }

    public void setNewSegment(NDataSegment segment) {
        this.newSegment = segment;
    }

    public Dataset<Row> merge() {
        Dataset mergeDataset = null;
        for (int i = 0; i < this.toMergeCuboids.size(); ++i) {
            NDataLayout nDataLayout = this.toMergeCuboids.get(i);
            this.ss.sparkContext().setJobDescription("Union segments layout " + nDataLayout.getLayoutId());
            Dataset layoutDataset = this.getLayoutDS(nDataLayout);
            mergeDataset = mergeDataset == null ? layoutDataset : mergeDataset.union(layoutDataset);
            this.ss.sparkContext().setJobDescription(null);
        }
        return mergeDataset;
    }

    private Dataset<Row> getLayoutDS(NDataLayout dataLayout) {
        NDataSegment dataSegment = dataLayout.getSegDetails().getDataSegment();
        if (CollectionUtils.isEmpty((Collection)dataLayout.getMultiPartition())) {
            return StorageStoreUtils.toDF((NDataSegment)dataSegment, (LayoutEntity)dataLayout.getLayout(), (SparkSession)this.ss);
        }
        Dataset mergedDS = null;
        for (LayoutPartition partition : dataLayout.getMultiPartition()) {
            Dataset partitionDS = StorageStoreUtils.toDF((NDataSegment)dataSegment, (LayoutEntity)dataLayout.getLayout(), (Long)partition.getPartitionId(), (SparkSession)this.ss);
            if (Objects.isNull(mergedDS)) {
                mergedDS = partitionDS;
                continue;
            }
            mergedDS = mergedDS.union(partitionDS);
        }
        return mergedDS;
    }
}

