/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.engine.spark.job;

import java.util.List;
import org.apache.kylin.engine.spark.utils.ExecutableHandleUtils;
import org.apache.kylin.engine.spark.utils.SparkJobFactoryUtils;
import org.apache.kylin.guava30.shaded.common.base.Preconditions;
import org.apache.kylin.job.execution.AbstractExecutable;
import org.apache.kylin.job.execution.DefaultExecutableOnModel;
import org.apache.kylin.job.execution.ExecutableHandler;
import org.apache.kylin.job.execution.MergerInfo;
import org.apache.kylin.metadata.cube.model.NDataLayout;

public class ExecutableAddSegmentHandler
extends ExecutableHandler {
    public ExecutableAddSegmentHandler(String project, String modelId, String owner, String segmentId, String jobId) {
        super(project, modelId, owner, segmentId, jobId);
    }

    public void handleFinished() {
        String project = this.getProject();
        DefaultExecutableOnModel executable = this.getExecutable();
        String jobId = executable.getId();
        String modelId = this.getModelId();
        Preconditions.checkState((executable.getTasks().size() > 1 ? 1 : 0) != 0, (Object)("job " + jobId + " steps is not enough"));
        int errorOrPausedJobCount = this.getErrorOrPausedJobCount();
        MergerInfo mergerInfo = new MergerInfo(project, modelId, jobId, errorOrPausedJobCount, ExecutableHandler.HandlerType.ADD_SEGMENT);
        ExecutableHandleUtils.getNeedMergeTasks(executable).forEach(task -> mergerInfo.addTaskMergeInfo(task, SparkJobFactoryUtils.needBuildSnapshots(task)));
        List<NDataLayout[]> mergedLayout = ExecutableHandleUtils.mergeMetadata(project, mergerInfo);
        List<AbstractExecutable> tasks = ExecutableHandleUtils.getNeedMergeTasks(executable);
        Preconditions.checkArgument((mergedLayout.size() == tasks.size() ? 1 : 0) != 0);
        for (int idx = 0; idx < tasks.size(); ++idx) {
            AbstractExecutable task2 = tasks.get(idx);
            NDataLayout[] layouts = mergedLayout.get(idx);
            ExecutableHandleUtils.recordDownJobStats(task2, layouts, project);
            task2.notifyUserIfNecessary(layouts);
        }
    }

    public void handleDiscardOrSuicidal() {
        if (this.getExecutable().checkAnyLayoutExists()) {
            return;
        }
        ExecutableHandleUtils.makeSegmentReady(this.getProject(), this.getModelId(), this.getSegmentId());
    }
}

