/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.engine.spark.job;

import java.util.Set;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.util.JsonUtil;
import org.apache.kylin.common.util.RandomUtil;
import org.apache.kylin.engine.spark.job.NSparkSnapshotBuildingStep;
import org.apache.kylin.engine.spark.job.StepEnum;
import org.apache.kylin.engine.spark.utils.HiveTableRefChecker;
import org.apache.kylin.job.execution.DefaultExecutable;
import org.apache.kylin.job.execution.DefaultExecutableOnTable;
import org.apache.kylin.job.execution.JobTypeEnum;
import org.apache.kylin.job.factory.JobFactory;
import org.apache.kylin.job.handler.SnapshotJobHandler;
import org.apache.kylin.metadata.model.NTableMetadataManager;
import org.apache.kylin.metadata.model.TableDesc;
import org.sparkproject.guava.base.Preconditions;

public class NSparkSnapshotJob
extends DefaultExecutableOnTable {
    public NSparkSnapshotJob() {
    }

    public NSparkSnapshotJob(Object notSetId) {
        super(notSetId);
    }

    public static NSparkSnapshotJob create(TableDesc tableDesc, String submitter, String partitionCol, boolean incrementBuild, Set<String> partitionToBuild, boolean isRefresh) {
        JobTypeEnum jobType = isRefresh ? JobTypeEnum.SNAPSHOT_REFRESH : JobTypeEnum.SNAPSHOT_BUILD;
        String partitionValueString = partitionToBuild == null ? null : JsonUtil.writeValueAsString(partitionToBuild);
        return NSparkSnapshotJob.create(tableDesc, submitter, jobType, RandomUtil.randomUUIDStr(), partitionCol, String.valueOf(incrementBuild), partitionValueString);
    }

    public static NSparkSnapshotJob create(TableDesc tableDesc, String submitter, boolean isRefresh, String yarnQueue) {
        JobTypeEnum jobType = isRefresh ? JobTypeEnum.SNAPSHOT_REFRESH : JobTypeEnum.SNAPSHOT_BUILD;
        return NSparkSnapshotJob.create(tableDesc, submitter, jobType, RandomUtil.randomUUIDStr(), null, "false", null);
    }

    public static NSparkSnapshotJob create(SnapshotJobHandler.SnapshotJobBuildParam jobBuildParam) {
        NTableMetadataManager tblMgr = NTableMetadataManager.getInstance((KylinConfig)KylinConfig.getInstanceFromEnv(), (String)jobBuildParam.getProject());
        TableDesc tableDesc = tblMgr.getTableDesc(jobBuildParam.getTable());
        return NSparkSnapshotJob.create(tableDesc, jobBuildParam.getSubmitter(), jobBuildParam.getJobType(), jobBuildParam.getJobId(), jobBuildParam.getPartitionCol(), jobBuildParam.getIncrementalBuild(), jobBuildParam.getPartitionsToBuild());
    }

    public static NSparkSnapshotJob create(TableDesc tableDesc, String submitter, JobTypeEnum jobType, String jobId, String partitionCol, String incrementalBuild, String partitionToBuild) {
        Preconditions.checkArgument((submitter != null ? 1 : 0) != 0);
        NSparkSnapshotJob job = new NSparkSnapshotJob();
        String project = tableDesc.getProject();
        job.setId(jobId);
        job.setProject(project);
        job.setName(jobType.toString());
        job.setJobType(jobType);
        job.setSubmitter(submitter);
        job.setTargetSubject(tableDesc.getIdentity());
        job.setParam("project", project);
        job.setParam("jobId", jobId);
        job.setParam("table", tableDesc.getIdentity());
        job.setParam("incrementalBuild", incrementalBuild);
        job.setParam("selectedPartitionCol", partitionCol);
        if (partitionToBuild != null) {
            job.setParam("selectedPartition", partitionToBuild);
        }
        KylinConfig config = KylinConfig.getInstanceFromEnv();
        StepEnum.BUILD_SNAPSHOT.create((DefaultExecutable)job, config);
        if (HiveTableRefChecker.isNeedCleanUpTransactionalTableJob(tableDesc.isTransactional(), tableDesc.isRangePartition(), config.isReadTransactionalTableEnabled())) {
            StepEnum.CLEANUP_TRANSACTIONAL_TABLE.create((DefaultExecutable)job, config);
        }
        return job;
    }

    public NSparkSnapshotBuildingStep getSnapshotBuildingStep() {
        return (NSparkSnapshotBuildingStep)this.getTask(NSparkSnapshotBuildingStep.class);
    }

    static {
        JobFactory.register((String)"SNAPSHOT_JOB_FACTORY", (JobFactory)new SnapshotJobFactory());
    }

    public static class SnapshotJobFactory
    extends JobFactory {
        protected SnapshotJobFactory() {
        }

        protected NSparkSnapshotJob create(JobFactory.JobBuildParams jobBuildParams) {
            return NSparkSnapshotJob.create((SnapshotJobHandler.SnapshotJobBuildParam)jobBuildParams);
        }
    }
}

