/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.engine.spark.model.planner;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.hash.HashFunction;
import com.google.common.hash.Hasher;
import com.google.common.hash.Hashing;
import java.io.IOException;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import lombok.Generated;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.util.ByteArray;
import org.apache.kylin.common.util.Bytes;
import org.apache.kylin.engine.spark.model.SegmentFlatTableDesc;
import org.apache.kylin.measure.hllc.HLLCounter;
import org.apache.kylin.measure.hllc.RegisterType;
import org.apache.kylin.metadata.cube.model.IndexPlan;
import org.apache.kylin.metadata.cube.model.LayoutEntity;
import org.apache.kylin.metadata.cube.model.RuleBasedIndex;
import org.apache.kylin.metadata.cube.planner.CostBasePlannerUtils;
import org.apache.kylin.metadata.datatype.DataType;
import org.apache.kylin.metadata.model.MeasureDesc;
import org.apache.kylin.metadata.model.NDataModel;
import org.apache.kylin.metadata.model.TblColRef;
import org.apache.spark.Partitioner;
import org.apache.spark.api.java.JavaPairRDD;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.api.java.function.Function;
import org.apache.spark.api.java.function.Function2;
import org.apache.spark.api.java.function.PairFlatMapFunction;
import org.apache.spark.sql.Row;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Tuple2;

public class FlatTableToCostUtils {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(FlatTableToCostUtils.class);

    private static LayoutEntity createMockRuleBaseLayout(RuleBasedIndex ruleBasedIndex) {
        LayoutEntity baseLayouts = new LayoutEntity();
        baseLayouts.setColOrder(ruleBasedIndex.getDimensions());
        return baseLayouts;
    }

    public static Map<BigInteger, HLLCounter> generateCost(JavaRDD<Row> input, KylinConfig kylinConfig, RuleBasedIndex ruleBasedIndex, SegmentFlatTableDesc flatTableDesc) throws IOException {
        JavaRDD flatTableRDD = input.map((Function)new Function<Row, String[]>(){

            public String[] call(Row row) throws Exception {
                String[] result = new String[row.length()];
                for (int i = 0; i < row.length(); ++i) {
                    Object o = row.get(i);
                    result[i] = o != null ? o.toString() : null;
                }
                return result;
            }
        });
        int rowKeyCount = ruleBasedIndex.countOfIncludeDimension();
        Set inputLayouts = ruleBasedIndex.genCuboidLayouts();
        inputLayouts.add(FlatTableToCostUtils.createMockRuleBaseLayout(ruleBasedIndex));
        BigInteger[] inputCuboids = FlatTableToCostUtils.getCuboIdsFromLayouts(Lists.newArrayList((Iterable)inputLayouts), rowKeyCount, ruleBasedIndex.getColumnIdToRowKeyId());
        int[] rowkeyColumnIndexes = FlatTableToCostUtils.getRowkeyColumnIndexes(ruleBasedIndex, flatTableDesc);
        final int hllPrecision = kylinConfig.getStatsHLLPrecision();
        log.info("The row key count is {}, and the index/column map is {}", (Object)rowKeyCount, (Object)Lists.newArrayList((Object[])new int[][]{rowkeyColumnIndexes}));
        JavaPairRDD costRddByPartition = flatTableRDD.mapPartitionsToPair((PairFlatMapFunction)new FlatOutputFunction(hllPrecision, rowKeyCount, inputCuboids, rowkeyColumnIndexes));
        final int partitionNum = FlatTableToCostUtils.getCuboidHLLCounterReducerNum(inputCuboids.length, kylinConfig);
        log.info("Get the partition count for the HLL reducer: {}", (Object)partitionNum);
        JavaPairRDD costRDD = costRddByPartition.reduceByKey(new Partitioner(){
            private int num;
            private BigInteger bigIntegerMod;
            {
                this.num = partitionNum;
                this.bigIntegerMod = BigInteger.valueOf(this.num);
            }

            public int numPartitions() {
                return this.num;
            }

            public int getPartition(Object key) {
                BigInteger value = (BigInteger)key;
                return value.mod(this.bigIntegerMod).intValue();
            }
        }, (Function2)new Function2<byte[], byte[], byte[]>(){
            private int precision;
            {
                this.precision = hllPrecision;
            }

            public byte[] call(byte[] array1, byte[] array2) throws Exception {
                HLLCounter hll1 = new HLLCounter(this.precision);
                ByteBuffer buffer1 = ByteBuffer.wrap(array1, 0, array1.length);
                hll1.readRegisters(buffer1);
                HLLCounter hll2 = new HLLCounter(this.precision);
                ByteBuffer buffer2 = ByteBuffer.wrap(array2, 0, array2.length);
                hll2.readRegisters(buffer2);
                hll1.merge(hll2);
                ByteBuffer hllBuf = ByteBuffer.allocate(0x100000);
                hll1.writeRegisters(hllBuf);
                byte[] value = new byte[hllBuf.position()];
                System.arraycopy(hllBuf.array(), 0, value, 0, hllBuf.position());
                return value;
            }
        });
        HashMap resultCost = Maps.newHashMap();
        for (Tuple2 pair : costRDD.collect()) {
            HLLCounter hll = new HLLCounter(kylinConfig.getStatsHLLPrecision());
            ByteArray byteArray = new ByteArray((byte[])pair._2);
            hll.readRegisters(byteArray.asBuffer());
            resultCost.put(pair._1, hll);
        }
        if (log.isDebugEnabled()) {
            FlatTableToCostUtils.logMapperAndCuboidStatistics(resultCost, 100);
        }
        return resultCost;
    }

    private static int getCuboidHLLCounterReducerNum(int nCuboids, KylinConfig kylinConfig) {
        int hllMaxReducerNumber;
        int shardBase = (nCuboids - 1) / kylinConfig.getJobPerReducerHLLCuboidNumber() + 1;
        if (shardBase > (hllMaxReducerNumber = kylinConfig.getJobHLLMaxReducerNumber())) {
            shardBase = hllMaxReducerNumber;
        }
        return Math.max(shardBase, 1);
    }

    private static BigInteger[] getCuboIdsFromLayouts(List<LayoutEntity> allLayouts, int dimensionCount, Map<Integer, Integer> columnIdToRowkeyId) {
        HashSet<BigInteger> set = new HashSet<BigInteger>();
        for (LayoutEntity layoutEntity : allLayouts) {
            BigInteger cuboId = CostBasePlannerUtils.convertDimensionsToCuboId((List)layoutEntity.getDimsIds(), (int)dimensionCount, columnIdToRowkeyId);
            set.add(cuboId);
        }
        return set.toArray(new BigInteger[set.size()]);
    }

    private static int[] getRowkeyColumnIndexes(RuleBasedIndex ruleBasedIndex, SegmentFlatTableDesc flatTableDesc) {
        int rowKeyCount = ruleBasedIndex.countOfIncludeDimension();
        List<Integer> columnIds = flatTableDesc.getColumnIds();
        int[] rowkeyColumnIndexes = new int[rowKeyCount];
        Map rowkeyIdToColumnId = ruleBasedIndex.getRowKeyIdToColumnId();
        for (int rowkeyId = 0; rowkeyId < rowKeyCount; ++rowkeyId) {
            if (!rowkeyIdToColumnId.containsKey(rowkeyId)) {
                throw new RuntimeException("Can't find the column id from the rowkey id");
            }
            int columnId = (Integer)rowkeyIdToColumnId.get(rowkeyId);
            int index = columnIds.indexOf(columnId);
            if (index < 0) {
                throw new RuntimeException(String.format(Locale.ROOT, "Can't find the column id %d, column ids %s", columnId, columnIds));
            }
            rowkeyColumnIndexes[rowkeyId] = index;
        }
        return rowkeyColumnIndexes;
    }

    private static void logMapperAndCuboidStatistics(Map<BigInteger, HLLCounter> cuboidHLLMap, int samplingPercentage) {
        log.debug("Total cuboid number: \t" + cuboidHLLMap.size());
        log.debug("Sampling percentage: \t" + samplingPercentage);
        log.debug("The following statistics are collected based on sampling data.");
        ArrayList allCuboids = Lists.newArrayList(cuboidHLLMap.keySet());
        Collections.sort(allCuboids);
        for (BigInteger i : allCuboids) {
            log.debug("Cuboid " + i + " row count is: \t " + cuboidHLLMap.get(i).getCountEstimate());
        }
    }

    public static Map<BigInteger, Long> getCuboidRowCountMapFromSampling(Map<BigInteger, HLLCounter> hllcMap) {
        HashMap cuboidRowCountMap = Maps.newHashMap();
        for (Map.Entry<BigInteger, HLLCounter> entry : hllcMap.entrySet()) {
            cuboidRowCountMap.put(entry.getKey(), entry.getValue().getCountEstimate());
        }
        return cuboidRowCountMap;
    }

    private static Map<BigInteger, Double> getCuboidSizeMapFromSamplingByCount(Map<BigInteger, Long> rowCountMap, long sourceCount, RuleBasedIndex ruleBasedIndex, KylinConfig kylinConfig, SegmentFlatTableDesc segmentFlatTableDesc) {
        HashMap cuboidSizeMap = Maps.newHashMap();
        for (Map.Entry<BigInteger, Long> entry : rowCountMap.entrySet()) {
            double value = entry.getValue().longValue();
            cuboidSizeMap.put(entry.getKey(), value);
        }
        return cuboidSizeMap;
    }

    public static Map<BigInteger, Double> getCuboidSizeMapFromSampling(Map<BigInteger, Long> rowCountMap, long sourceCount, RuleBasedIndex ruleBasedIndex, KylinConfig kylinConfig, SegmentFlatTableDesc segmentFlatTableDesc) {
        return FlatTableToCostUtils.getCuboidSizeMapFromSamplingByCount(rowCountMap, sourceCount, ruleBasedIndex, kylinConfig, segmentFlatTableDesc);
    }

    private static List<Integer> getRowkeyColumnSize(IndexPlan indexPlan, SegmentFlatTableDesc flatTableDesc) {
        int rowKeyCount = indexPlan.getRuleBasedIndex().countOfIncludeDimension();
        List<Integer> columnIds = flatTableDesc.getColumnIds();
        List<TblColRef> tblColRefs = flatTableDesc.getColumns();
        ArrayList rowkeyColumnSize = Lists.newArrayList();
        for (int i = 0; i < rowKeyCount; ++i) {
            int index = columnIds.indexOf(i);
            if (index < 0) {
                throw new RuntimeException(String.format(Locale.ROOT, "Can't find the column id %d, column ids %s", i, columnIds));
            }
            TblColRef tblColRef = tblColRefs.get(index);
            int length = 0;
            rowkeyColumnSize.add(length);
        }
        return rowkeyColumnSize;
    }

    private static double estimateCuboidStorageSize(Set<NDataModel.Measure> measureDescs, long cuboidId, long rowCount, long baseCuboidId, long baseCuboidCount, List<Integer> rowKeyColumnLength, long sourceRowCount, KylinConfig kylinConfig) {
        int rowkeyLength = 8;
        long mask = Long.highestOneBit(baseCuboidId);
        long parentCuboidIdActualLength = 64L - (long)Long.numberOfLeadingZeros(baseCuboidId);
        int i = 0;
        while ((long)i < parentCuboidIdActualLength) {
            if ((mask & cuboidId) > 0L) {
                rowkeyLength += rowKeyColumnLength.get(i).intValue();
            }
            mask >>= 1;
            ++i;
        }
        int normalSpace = rowkeyLength;
        int countDistinctSpace = 0;
        double percentileSpace = 0.0;
        int topNSpace = 0;
        for (MeasureDesc measureDesc : measureDescs) {
            if (rowCount == 0L) break;
            DataType returnType = measureDesc.getFunction().getReturnDataType();
            if (measureDesc.getFunction().getExpression().equals("COUNT_DISTINCT")) {
                long estimateDistinctCount = sourceRowCount / rowCount;
                estimateDistinctCount = estimateDistinctCount == 0L ? 1L : estimateDistinctCount;
                countDistinctSpace = (int)((double)countDistinctSpace + returnType.getStorageBytesEstimate((double)estimateDistinctCount));
                continue;
            }
            if (measureDesc.getFunction().getExpression().equals("PERCENTILE_APPROX")) {
                percentileSpace += returnType.getStorageBytesEstimate((double)baseCuboidCount * 1.0 / (double)rowCount);
                continue;
            }
            if (measureDesc.getFunction().getExpression().equals("TOP_N")) {
                long estimateTopNCount = sourceRowCount / rowCount;
                estimateTopNCount = estimateTopNCount == 0L ? 1L : estimateTopNCount;
                topNSpace = (int)((double)topNSpace + returnType.getStorageBytesEstimate((double)estimateTopNCount));
                continue;
            }
            normalSpace += returnType.getStorageBytesEstimate();
        }
        double cuboidSizeRatio = kylinConfig.getJobCuboidSizeRatio();
        double cuboidSizeMemHungryRatio = kylinConfig.getJobCuboidSizeCountDistinctRatio();
        double cuboidSizeTopNRatio = kylinConfig.getJobCuboidSizeTopNRatio();
        double ret = (1.0 * (double)normalSpace * (double)rowCount * cuboidSizeRatio + 1.0 * (double)countDistinctSpace * (double)rowCount * cuboidSizeMemHungryRatio + 1.0 * percentileSpace * (double)rowCount + 1.0 * (double)topNSpace * (double)rowCount * cuboidSizeTopNRatio) / 1048576.0;
        return ret;
    }

    static class CuboidStatCalculator {
        private final int nRowKey;
        private final int[] rowkeyColIndex;
        private final BigInteger[] cuboidIds;
        private final Integer[][] cuboidsBitSet;
        private HLLCounter[] cuboidsHLL;
        private final boolean isNewAlgorithm;
        private final HashFunction hf;
        private long[] rowHashCodesLong;

        public CuboidStatCalculator(int[] rowkeyColIndex, BigInteger[] cuboidIds, Integer[][] cuboidsBitSet, boolean isUsePutRowKeyToHllNewAlgorithm, HLLCounter[] cuboidsHLL) {
            this.nRowKey = rowkeyColIndex.length;
            this.rowkeyColIndex = rowkeyColIndex;
            this.cuboidIds = cuboidIds;
            this.cuboidsBitSet = cuboidsBitSet;
            this.isNewAlgorithm = isUsePutRowKeyToHllNewAlgorithm;
            if (!this.isNewAlgorithm) {
                this.hf = Hashing.murmur3_32();
            } else {
                this.rowHashCodesLong = new long[this.nRowKey];
                this.hf = Hashing.murmur3_128();
            }
            this.cuboidsHLL = cuboidsHLL;
        }

        public void putRow(String[] row) {
            String[] copyRow = Arrays.copyOf(row, row.length);
            if (this.isNewAlgorithm) {
                this.putRowKeyToHLLNew(copyRow);
            } else {
                this.putRowKeyToHLLOld(copyRow);
            }
        }

        private void putRowKeyToHLLOld(String[] row) {
            int i;
            byte[][] rowHashCodes = new byte[this.nRowKey][];
            for (i = 0; i < this.nRowKey; ++i) {
                Hasher hc = this.hf.newHasher();
                String colValue = row[this.rowkeyColIndex[i]];
                rowHashCodes[i] = colValue != null ? hc.putString((CharSequence)colValue).hash().asBytes() : hc.putInt(0).hash().asBytes();
            }
            int n = this.cuboidsBitSet.length;
            for (i = 0; i < n; ++i) {
                Hasher hc = this.hf.newHasher();
                for (int position = 0; position < this.cuboidsBitSet[i].length; ++position) {
                    hc.putBytes(rowHashCodes[this.cuboidsBitSet[i][position]]);
                }
                this.cuboidsHLL[i].add(hc.hash().asBytes());
            }
        }

        private void putRowKeyToHLLNew(String[] row) {
            int i;
            for (i = 0; i < this.nRowKey; ++i) {
                Hasher hc = this.hf.newHasher();
                String colValue = row[this.rowkeyColIndex[i]];
                if (colValue == null) {
                    colValue = "0";
                }
                byte[] bytes = hc.putString((CharSequence)colValue).hash().asBytes();
                this.rowHashCodesLong[i] = Bytes.toLong((byte[])bytes) + (long)i;
            }
            int n = this.cuboidsBitSet.length;
            for (i = 0; i < n; ++i) {
                long value = 0L;
                for (int position = 0; position < this.cuboidsBitSet[i].length; ++position) {
                    value += this.rowHashCodesLong[this.cuboidsBitSet[i][position]];
                }
                this.cuboidsHLL[i].addHashDirectly(value);
            }
        }

        public HLLCounter[] getHLLCounters() {
            return this.cuboidsHLL;
        }

        public BigInteger[] getCuboidIds() {
            return this.cuboidIds;
        }
    }

    private static class FlatOutputFunction
    implements PairFlatMapFunction<Iterator<String[]>, BigInteger, byte[]> {
        private volatile transient boolean initialized = false;
        private transient CuboidStatCalculator cuboidStatCalculator;
        private final int samplingPercent = 100;
        private final int hllPrecision;
        private final int rowKeyCount;
        private final BigInteger[] cuboidIds;
        private final int[] rowkeyColumnIndexes;

        public FlatOutputFunction(int hllPrecision, int rowKeyCount, BigInteger[] cuboidIds, int[] rowkeyColumnIndexes) {
            this.hllPrecision = hllPrecision;
            this.rowKeyCount = rowKeyCount;
            this.cuboidIds = cuboidIds;
            this.rowkeyColumnIndexes = rowkeyColumnIndexes;
        }

        private Integer[][] getCuboidBitSet(BigInteger[] cuboidIds, int nRowKey) {
            Integer[][] allCuboidsBitSet = new Integer[cuboidIds.length][];
            for (int j = 0; j < cuboidIds.length; ++j) {
                BigInteger cuboidId = cuboidIds[j];
                allCuboidsBitSet[j] = new Integer[cuboidId.bitCount()];
                int position = 0;
                for (int i = 0; i < nRowKey; ++i) {
                    BigInteger bigMask = BigInteger.ZERO.setBit(nRowKey - 1 - i);
                    if (bigMask.and(cuboidId).compareTo(BigInteger.ZERO) <= 0) continue;
                    allCuboidsBitSet[j][position] = i;
                    ++position;
                }
            }
            return allCuboidsBitSet;
        }

        private HLLCounter[] getInitCuboidsHLL(int cuboidSize, int hllPrecision) {
            HLLCounter[] cuboidsHLL = new HLLCounter[cuboidSize];
            for (int i = 0; i < cuboidSize; ++i) {
                cuboidsHLL[i] = new HLLCounter(hllPrecision, RegisterType.DENSE);
            }
            return cuboidsHLL;
        }

        private void init() {
            Integer[][] cuboidsBitSet = this.getCuboidBitSet(this.cuboidIds, this.rowKeyCount);
            HLLCounter[] cuboidsHLL = this.getInitCuboidsHLL(this.cuboidIds.length, this.hllPrecision);
            this.cuboidStatCalculator = new CuboidStatCalculator(this.rowkeyColumnIndexes, this.cuboidIds, cuboidsBitSet, true, cuboidsHLL);
            this.initialized = true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Iterator<Tuple2<BigInteger, byte[]>> call(Iterator<String[]> iterator) throws Exception {
            if (!this.initialized) {
                FlatOutputFunction flatOutputFunction = this;
                synchronized (flatOutputFunction) {
                    if (!this.initialized) {
                        this.init();
                    }
                }
            }
            int rowCount = 0;
            while (iterator.hasNext()) {
                String[] row = iterator.next();
                if (rowCount % 100 < 100) {
                    this.cuboidStatCalculator.putRow(row);
                }
                ++rowCount;
            }
            ArrayList result = Lists.newArrayList();
            ByteBuffer hllBuf = ByteBuffer.allocate(0x100000);
            BigInteger[] cuboidIds = this.cuboidStatCalculator.getCuboidIds();
            HLLCounter[] cuboidsHLL = this.cuboidStatCalculator.getHLLCounters();
            for (int i = 0; i < cuboidIds.length; ++i) {
                BigInteger outputKey = cuboidIds[i];
                HLLCounter hll = cuboidsHLL[i];
                hllBuf.clear();
                hll.writeRegisters(hllBuf);
                byte[] value = new byte[hllBuf.position()];
                System.arraycopy(hllBuf.array(), 0, value, 0, hllBuf.position());
                result.add(new Tuple2((Object)outputKey, (Object)value));
            }
            return result.iterator();
        }
    }
}

