/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.loadbalancer.core;

import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.cloud.loadbalancer.core.ServiceInstanceListSupplier;
import org.springframework.util.Assert;

public abstract class DelegatingServiceInstanceListSupplier
implements ServiceInstanceListSupplier,
InitializingBean,
DisposableBean {
    protected final ServiceInstanceListSupplier delegate;

    public DelegatingServiceInstanceListSupplier(ServiceInstanceListSupplier delegate) {
        Assert.notNull((Object)delegate, (String)"delegate may not be null");
        this.delegate = delegate;
    }

    public ServiceInstanceListSupplier getDelegate() {
        return this.delegate;
    }

    @Override
    public String getServiceId() {
        return this.delegate.getServiceId();
    }

    public void afterPropertiesSet() throws Exception {
        if (this.delegate instanceof InitializingBean) {
            ((InitializingBean)this.delegate).afterPropertiesSet();
        }
    }

    public void destroy() throws Exception {
        if (this.delegate instanceof DisposableBean) {
            ((DisposableBean)this.delegate).destroy();
        }
    }
}

