/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.profiler;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Stream;

public class AsyncArchUtil {
    private static final Map<String, ArchType> ARCH_TO_PROCESSOR = new HashMap<String, ArchType>();

    public static ArchType getProcessor() {
        return AsyncArchUtil.getProcessor(AsyncArchUtil.getSystemProperty("os.arch"));
    }

    public static ArchType getProcessor(String osArch) {
        return ARCH_TO_PROCESSOR.get(osArch);
    }

    private static String getSystemProperty(String property) {
        try {
            return System.getProperty(property);
        }
        catch (SecurityException ex) {
            return null;
        }
    }

    private static void addProcessors(ArchType archType, String ... keys) {
        Stream.of(keys).forEach(key -> ARCH_TO_PROCESSOR.put((String)key, archType));
    }

    public static boolean isMuslLibc() {
        File ld_musl_x86_64_file = new File("/lib/ld-musl-x86_64.so.1");
        File ld_musl_aarch64_file = new File("/lib/ld-musl-aarch64.so.1");
        return ld_musl_x86_64_file.exists() || ld_musl_aarch64_file.exists();
    }

    static {
        AsyncArchUtil.addProcessors(ArchType.LINUX_X64, "x86_64", "amd64");
        AsyncArchUtil.addProcessors(ArchType.LINUX_ARM64, "aarch64");
    }

    public static enum ArchType {
        LINUX_X64,
        LINUX_ARM64;

    }
}

