/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.datasource.storage;

import java.io.Serializable;
import jodd.util.ThreadUtil;
import org.apache.hadoop.fs.Path;
import org.apache.kylin.common.KapConfig;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.metadata.model.TableDesc;
import org.apache.spark.internal.Logging;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.delta.DeltaTableUtils$;
import org.apache.spark.sql.delta.KylinDeltaLogFileIndex;
import org.apache.spark.sql.delta.KylinDeltaTableScan$;
import org.apache.spark.sql.delta.files.TahoeLogFileIndex;
import org.apache.spark.sql.execution.datasources.FileIndex;
import org.apache.spark.sql.execution.datasources.LogicalRelation;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.PartialFunction;
import scala.Tuple5;
import scala.collection.Seq;
import scala.runtime.BoxedUnit;

public final class KylinDeltaStorage$
implements Logging {
    public static KylinDeltaStorage$ MODULE$;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    static {
        new KylinDeltaStorage$();
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public Path getSnapshotPath(TableDesc tableDesc) {
        String hdfsWorkingDir = KapConfig.wrap((KylinConfig)tableDesc.getConfig()).getMetadataWorkingDirectory();
        String pathStr = new StringBuilder(23).append(hdfsWorkingDir).append("/").append(tableDesc.getProject()).append("/table_snapshot/delta/").append(tableDesc.getIdentity()).toString();
        return new Path(pathStr);
    }

    public void doExecuteWithRetry(int n, Function0<BoxedUnit> f) {
        while (true) {
            try {
                f.apply$mcV$sp();
            }
            catch (Throwable e) {
                if (n > 0) {
                    this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(65).append("delta storage execute failed, do retry, remain ").append(n).append(" times retry times").toString(), e);
                    ThreadUtil.sleep((long)100L);
                    --n;
                    continue;
                }
                throw e;
            }
            break;
        }
    }

    public LogicalPlan replaceFileIndex(LogicalPlan target) {
        return (LogicalPlan)target.transform((PartialFunction)new scala.Serializable(){
            public static final long serialVersionUID = 0L;

            public final <A1 extends LogicalPlan, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x1;
                Option<Tuple5<LogicalPlan, Seq<Expression>, TahoeLogFileIndex, Option<Object>, LogicalRelation>> option = KylinDeltaTableScan$.MODULE$.unapply(A1);
                if (!option.isEmpty()) {
                    TahoeLogFileIndex fileIndex = (TahoeLogFileIndex)((Tuple5)option.get())._3();
                    KylinDeltaLogFileIndex kylinIndex = KylinDeltaStorage$.MODULE$.org$apache$spark$sql$datasource$storage$KylinDeltaStorage$$getKylinTahoeLogFileIndex(fileIndex);
                    object = DeltaTableUtils$.MODULE$.replaceFileIndex(A1, (FileIndex)kylinIndex);
                } else {
                    object = function1.apply(x1);
                }
                return (B1)object;
            }

            public final boolean isDefinedAt(LogicalPlan x1) {
                LogicalPlan logicalPlan = x1;
                Option<Tuple5<LogicalPlan, Seq<Expression>, TahoeLogFileIndex, Option<Object>, LogicalRelation>> option = KylinDeltaTableScan$.MODULE$.unapply(logicalPlan);
                boolean bl = !option.isEmpty();
                return bl;
            }
        });
    }

    public KylinDeltaLogFileIndex org$apache$spark$sql$datasource$storage$KylinDeltaStorage$$getKylinTahoeLogFileIndex(TahoeLogFileIndex fileIndex) {
        return new KylinDeltaLogFileIndex(fileIndex.spark(), fileIndex.deltaLog(), fileIndex.path(), fileIndex.snapshotAtAnalysis(), (Seq<Expression>)fileIndex.partitionFilters(), fileIndex.isTimeTravelQuery());
    }

    private KylinDeltaStorage$() {
        MODULE$ = this;
        Logging.$init$((Logging)this);
    }
}

