/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.delta.storage.dv;

import java.io.DataInputStream;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.util.UUID;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.spark.internal.Logging;
import org.apache.spark.sql.delta.actions.DeletionVectorDescriptor;
import org.apache.spark.sql.delta.deletionvectors.RoaringBitmapArray;
import org.apache.spark.sql.delta.deletionvectors.RoaringBitmapArray$;
import org.apache.spark.sql.delta.storage.dv.DeletionVectorStore;
import org.apache.spark.sql.delta.storage.dv.DeletionVectorStore$;
import org.apache.spark.sql.delta.storage.dv.DeletionVectorStoreUtils;
import org.apache.spark.sql.delta.util.PathWithFileSystem;
import org.apache.spark.sql.delta.util.PathWithFileSystem$;
import org.apache.spark.util.Utils$;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001e3AAB\u0004\u0001-!A\u0011\u0005\u0001B\u0001B\u0003%!\u0005C\u0003+\u0001\u0011\u00051\u0006C\u0003/\u0001\u0011\u0005s\u0006C\u0003F\u0001\u0011\u0005c\tC\u0003W\u0001\u0011\u0005sKA\fIC\u0012|w\u000e\u001d$jY\u0016\u001c\u0016p\u001d;f[\u001236\u000b^8sK*\u0011\u0001\"C\u0001\u0003IZT!AC\u0006\u0002\u000fM$xN]1hK*\u0011A\"D\u0001\u0006I\u0016dG/\u0019\u0006\u0003\u001d=\t1a]9m\u0015\t\u0001\u0012#A\u0003ta\u0006\u00148N\u0003\u0002\u0013'\u00051\u0011\r]1dQ\u0016T\u0011\u0001F\u0001\u0004_J<7\u0001A\n\u0004\u0001]i\u0002C\u0001\r\u001c\u001b\u0005I\"\"\u0001\u000e\u0002\u000bM\u001c\u0017\r\\1\n\u0005qI\"AB!osJ+g\r\u0005\u0002\u001f?5\tq!\u0003\u0002!\u000f\t\u0019B)\u001a7fi&|gNV3di>\u00148\u000b^8sK\u0006Q\u0001.\u00193p_B\u001cuN\u001c4\u0011\u0005\rBS\"\u0001\u0013\u000b\u0005\u00152\u0013\u0001B2p]\u001aT!aJ\t\u0002\r!\fGm\\8q\u0013\tICEA\u0007D_:4\u0017nZ;sCRLwN\\\u0001\u0007y%t\u0017\u000e\u001e \u0015\u00051j\u0003C\u0001\u0010\u0001\u0011\u0015\t#\u00011\u0001#\u0003\u0011\u0011X-\u00193\u0015\tA2dh\u0011\t\u0003cQj\u0011A\r\u0006\u0003g-\tq\u0002Z3mKRLwN\u001c<fGR|'o]\u0005\u0003kI\u0012!CU8be&twMQ5u[\u0006\u0004\u0018I\u001d:bs\")qg\u0001a\u0001q\u0005!\u0001/\u0019;i!\tID(D\u0001;\u0015\tYd%\u0001\u0002gg&\u0011QH\u000f\u0002\u0005!\u0006$\b\u000eC\u0003@\u0007\u0001\u0007\u0001)\u0001\u0004pM\u001a\u001cX\r\u001e\t\u00031\u0005K!AQ\r\u0003\u0007%sG\u000fC\u0003E\u0007\u0001\u0007\u0001)\u0001\u0003tSj,\u0017\u0001D2sK\u0006$Xm\u0016:ji\u0016\u0014HCA$P!\tA5J\u0004\u0002\u001f\u0013&\u0011!jB\u0001\u0014\t\u0016dW\r^5p]Z+7\r^8s'R|'/Z\u0005\u0003\u00196\u0013aa\u0016:ji\u0016\u0014\u0018B\u0001(\b\u0005a!U\r\\3uS>tg+Z2u_J\u001cFo\u001c:f+RLGn\u001d\u0005\u0006o\u0011\u0001\r\u0001\u0015\t\u0003#Rk\u0011A\u0015\u0006\u0003'.\tA!\u001e;jY&\u0011QK\u0015\u0002\u0013!\u0006$\bnV5uQ\u001aKG.Z*zgR,W.\u0001\nqCRDw+\u001b;i\r&dWmU=ti\u0016lGC\u0001)Y\u0011\u00159T\u00011\u00019\u0001")
public class HadoopFileSystemDVStore
implements DeletionVectorStore {
    private final Configuration hadoopConf;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    @Override
    public RoaringBitmapArray read(DeletionVectorDescriptor dvDescriptor, Path tablePath) {
        return DeletionVectorStore.read$(this, dvDescriptor, tablePath);
    }

    @Override
    public PathWithFileSystem generateFileNameInTable(PathWithFileSystem targetPath, UUID fileId, String prefix) {
        return DeletionVectorStore.generateFileNameInTable$(this, targetPath, fileId, prefix);
    }

    @Override
    public String generateFileNameInTable$default$3() {
        return DeletionVectorStore.generateFileNameInTable$default$3$(this);
    }

    @Override
    public PathWithFileSystem generateUniqueNameInTable(PathWithFileSystem targetPath, String prefix) {
        return DeletionVectorStore.generateUniqueNameInTable$(this, targetPath, prefix);
    }

    @Override
    public String generateUniqueNameInTable$default$2() {
        return DeletionVectorStore.generateUniqueNameInTable$default$2$(this);
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    @Override
    public RoaringBitmapArray read(Path path, int offset, int size) {
        FileSystem fs = path.getFileSystem(this.hadoopConf);
        byte[] buffer = (byte[])Utils$.MODULE$.tryWithResource((Function0 & Serializable & scala.Serializable)() -> fs.open(path), (Function1 & Serializable & scala.Serializable)reader -> {
            reader.seek((long)offset);
            return DeletionVectorStore$.MODULE$.readRangeFromStream((DataInputStream)reader, size);
        });
        return RoaringBitmapArray$.MODULE$.readFrom(buffer);
    }

    @Override
    public DeletionVectorStoreUtils.Writer createWriter(PathWithFileSystem path) {
        return new DeletionVectorStoreUtils.Writer(this, path){
            private FSDataOutputStream outputStream;
            private final byte[] serializedPath;
            private final /* synthetic */ HadoopFileSystemDVStore $outer;
            private final PathWithFileSystem path$2;

            private FSDataOutputStream outputStream() {
                return this.outputStream;
            }

            private void outputStream_$eq(FSDataOutputStream x$1) {
                this.outputStream = x$1;
            }

            /*
             * WARNING - void declaration
             */
            public DeletionVectorStoreUtils.DVRangeDescriptor write(byte[] data) {
                void var3_3;
                if (this.outputStream() == null) {
                    boolean overwrite = false;
                    this.outputStream_$eq(this.path$2.fs().create(this.path$2.path(), overwrite));
                    this.outputStream().writeByte((int)DeletionVectorStore$.MODULE$.DV_FILE_FORMAT_VERSION_ID_V1());
                }
                DeletionVectorStoreUtils.DVRangeDescriptor dvRange = new DeletionVectorStoreUtils.DVRangeDescriptor(DeletionVectorStore$.MODULE$, this.outputStream().size(), data.length, DeletionVectorStore$.MODULE$.calculateChecksum(data));
                this.$outer.log().debug(new StringBuilder(39).append("Writing DV range to file: Path=").append(this.path$2.path()).append(", Range=").append(dvRange).toString());
                this.outputStream().writeInt(data.length);
                this.outputStream().write(data);
                this.outputStream().writeInt(dvRange.checksum());
                return var3_3;
            }

            public byte[] serializedPath() {
                return this.serializedPath;
            }

            public void close() {
                block0: {
                    if (this.outputStream() == null) break block0;
                    this.outputStream().close();
                }
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.path$2 = path$2;
                this.serializedPath = DeletionVectorStore$.MODULE$.pathToString(path$2.path()).getBytes(StandardCharsets.UTF_8);
            }
        };
    }

    @Override
    public PathWithFileSystem pathWithFileSystem(Path path) {
        return PathWithFileSystem$.MODULE$.withConf(path, this.hadoopConf);
    }

    public HadoopFileSystemDVStore(Configuration hadoopConf) {
        this.hadoopConf = hadoopConf;
        Logging.$init$((Logging)this);
        DeletionVectorStore.$init$(this);
    }
}

