/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.common.metrics.prometheus;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.Generated;

public enum PrometheusMetrics {
    JVM_DB_CONNECTIONS("kylin_db_connections", 1),
    SPARK_TASKS("spark_tasks", 1),
    SPARK_TASK_UTILIZATION("spark_tasks_utilization", 1),
    QUERY_SECONDS("kylin_queries_seconds", 2),
    QUERY_SCAN_BYTES("kylin_queries_scan_bytes", 2),
    QUERY_RESULT_ROWS("kylin_queries_result_rows", 2),
    QUERY_JOBS("kylin_queries_jobs", 2),
    QUERY_STAGES("kylin_queries_stages", 2),
    QUERY_TASKS("kylin_queries_tasks", 2),
    SPARDER_UP("kylin_sparder_up", 1),
    JOB_COUNTS("kylin_job_counts", 2),
    JOB_MINUTES("kylin_job_minutes", 2),
    JOB_LONG_RUNNING("kylin_long_running_jobs", 2),
    MODEL_BUILD_DURATION("kylin_model_build_minutes", 6),
    PROJECT_LIST("kylin_project_list", 2);

    private final String value;
    private final int types;

    private PrometheusMetrics(String value, int types) {
        this.value = value;
        this.types = types;
    }

    public static Set<PrometheusMetrics> listModelMetrics() {
        return Stream.of(PrometheusMetrics.values()).filter(metric -> (metric.getTypes() & 4) != 0).collect(Collectors.toSet());
    }

    @Generated
    public String getValue() {
        return this.value;
    }

    @Generated
    public int getTypes() {
        return this.types;
    }

    private static class Type {
        public static final int GLOBAL = 0;
        public static final int INSTANCE_METRIC = 1;
        public static final int PROJECT_METRIC = 2;
        public static final int MODEL_METRIC = 4;

        private Type() {
        }
    }
}

