/*
 * Decompiled with CFR 0.152.
 */
package org.apache.curator.x.discovery.details;

import com.google.common.base.Function;
import java.io.Closeable;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.listen.ListenerContainer;
import org.apache.curator.framework.recipes.cache.ChildData;
import org.apache.curator.framework.recipes.cache.PathChildrenCache;
import org.apache.curator.framework.recipes.cache.PathChildrenCacheEvent;
import org.apache.curator.framework.recipes.cache.PathChildrenCacheListener;
import org.apache.curator.shaded.com.google.common.annotations.VisibleForTesting;
import org.apache.curator.shaded.com.google.common.base.Preconditions;
import org.apache.curator.shaded.com.google.common.collect.Lists;
import org.apache.curator.shaded.com.google.common.collect.Maps;
import org.apache.curator.utils.CloseableExecutorService;
import org.apache.curator.utils.CloseableUtils;
import org.apache.curator.utils.ZKPaths;
import org.apache.curator.x.discovery.ServiceCache;
import org.apache.curator.x.discovery.ServiceInstance;
import org.apache.curator.x.discovery.details.ServiceCacheListener;
import org.apache.curator.x.discovery.details.ServiceDiscoveryImpl;

public class ServiceCacheImpl<T>
implements ServiceCache<T>,
PathChildrenCacheListener {
    private final ListenerContainer<ServiceCacheListener> listenerContainer = new ListenerContainer();
    private final ServiceDiscoveryImpl<T> discovery;
    private final AtomicReference<State> state = new AtomicReference<State>(State.LATENT);
    private final PathChildrenCache cache;
    private final ConcurrentMap<String, ServiceInstance<T>> instances = Maps.newConcurrentMap();

    private static CloseableExecutorService convertThreadFactory(ThreadFactory threadFactory) {
        Preconditions.checkNotNull((Object)threadFactory, (Object)"threadFactory cannot be null");
        return new CloseableExecutorService(Executors.newSingleThreadExecutor(threadFactory));
    }

    ServiceCacheImpl(ServiceDiscoveryImpl<T> discovery, String name, ThreadFactory threadFactory) {
        this(discovery, name, ServiceCacheImpl.convertThreadFactory(threadFactory));
    }

    ServiceCacheImpl(ServiceDiscoveryImpl<T> discovery, String name, CloseableExecutorService executorService) {
        Preconditions.checkNotNull(discovery, (Object)"discovery cannot be null");
        Preconditions.checkNotNull((Object)name, (Object)"name cannot be null");
        Preconditions.checkNotNull((Object)executorService, (Object)"executorService cannot be null");
        this.discovery = discovery;
        this.cache = new PathChildrenCache(discovery.getClient(), discovery.pathForName(name), true, false, executorService);
        this.cache.getListenable().addListener((Object)this);
    }

    @Override
    public List<ServiceInstance<T>> getInstances() {
        return Lists.newArrayList(this.instances.values());
    }

    @VisibleForTesting
    void startCache() throws Exception {
        Preconditions.checkState((boolean)this.state.compareAndSet(State.LATENT, State.STARTED), (Object)"Cannot be started more than once");
        this.cache.start(true);
    }

    @VisibleForTesting
    void oldLloadCacheData() throws Exception {
        for (ChildData childData : this.cache.getCurrentData()) {
            this.addInstance(childData, true);
        }
        this.discovery.cacheOpened(this);
    }

    @VisibleForTesting
    void loadCacheData() throws Exception {
        for (ChildData childData : this.cache.getCurrentData()) {
            if (childData.getData() == null) continue;
            this.addInstance(childData, true);
        }
        this.discovery.cacheOpened(this);
    }

    @Override
    public void start() throws Exception {
        this.startCache();
        this.loadCacheData();
    }

    @Override
    public void close() throws IOException {
        Preconditions.checkState((boolean)this.state.compareAndSet(State.STARTED, State.STOPPED), (Object)"Already closed or has not been started");
        this.listenerContainer.forEach((Function)new Function<ServiceCacheListener, Void>(){

            public Void apply(ServiceCacheListener listener) {
                ServiceCacheImpl.this.discovery.getClient().getConnectionStateListenable().removeListener((Object)listener);
                return null;
            }
        });
        this.listenerContainer.clear();
        CloseableUtils.closeQuietly((Closeable)this.cache);
        this.discovery.cacheClosed(this);
    }

    public void addListener(ServiceCacheListener listener) {
        this.listenerContainer.addListener((Object)listener);
        this.discovery.getClient().getConnectionStateListenable().addListener((Object)listener);
    }

    public void addListener(ServiceCacheListener listener, Executor executor) {
        this.listenerContainer.addListener((Object)listener, executor);
        this.discovery.getClient().getConnectionStateListenable().addListener((Object)listener, executor);
    }

    public void removeListener(ServiceCacheListener listener) {
        this.listenerContainer.removeListener((Object)listener);
        this.discovery.getClient().getConnectionStateListenable().removeListener((Object)listener);
    }

    public void childEvent(CuratorFramework client, PathChildrenCacheEvent event) throws Exception {
        boolean notifyListeners = false;
        switch (event.getType()) {
            case CHILD_ADDED: 
            case CHILD_UPDATED: {
                this.addInstance(event.getData(), false);
                notifyListeners = true;
                break;
            }
            case CHILD_REMOVED: {
                this.instances.remove(this.instanceIdFromData(event.getData()));
                notifyListeners = true;
            }
        }
        if (notifyListeners) {
            this.listenerContainer.forEach((Function)new Function<ServiceCacheListener, Void>(){

                public Void apply(ServiceCacheListener listener) {
                    listener.cacheChanged();
                    return null;
                }
            });
        }
    }

    private String instanceIdFromData(ChildData childData) {
        return ZKPaths.getNodeFromPath((String)childData.getPath());
    }

    private void addInstance(ChildData childData, boolean onlyIfAbsent) throws Exception {
        String instanceId = this.instanceIdFromData(childData);
        ServiceInstance<T> serviceInstance = this.discovery.getSerializer().deserialize(childData.getData());
        if (onlyIfAbsent) {
            this.instances.putIfAbsent(instanceId, serviceInstance);
        } else {
            this.instances.put(instanceId, serviceInstance);
        }
        this.cache.clearDataBytes(childData.getPath(), childData.getStat().getVersion());
    }

    private static enum State {
        LATENT,
        STARTED,
        STOPPED;

    }
}

