/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.common.exception.code;

import java.util.Locale;
import lombok.Generated;
import org.apache.kylin.common.exception.code.ErrorCode;
import org.apache.kylin.common.exception.code.ErrorCodeProducer;
import org.apache.kylin.common.exception.code.ErrorMsg;
import org.apache.kylin.common.exception.code.ErrorSuggestion;

public enum ErrorCodeCommon implements ErrorCodeProducer
{
    NON_KE_EXCEPTION("KE-060100201");

    private final ErrorCode errorCode;
    private final ErrorMsg errorMsg;
    private final ErrorSuggestion errorSuggestion;

    private ErrorCodeCommon(String keCode) {
        this.errorCode = new ErrorCode(keCode);
        this.errorMsg = new ErrorMsg(this.errorCode.getCode());
        this.errorSuggestion = new ErrorSuggestion(this.errorCode.getCode());
    }

    @Override
    public ErrorSuggestion getErrorSuggest() {
        return this.errorSuggestion;
    }

    @Override
    public String getMsg(Object ... args) {
        return String.format(Locale.ROOT, this.errorMsg.getLocalizedString(), args);
    }

    @Override
    public String getCodeMsg(Object ... args) {
        return String.format(Locale.ROOT, "%s: %s", this.errorCode.getCode(), this.getMsg(args));
    }

    @Override
    @Generated
    public ErrorCode getErrorCode() {
        return this.errorCode;
    }

    @Override
    @Generated
    public ErrorMsg getErrorMsg() {
        return this.errorMsg;
    }

    @Generated
    public ErrorSuggestion getErrorSuggestion() {
        return this.errorSuggestion;
    }
}

