/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.common.mail;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import lombok.Generated;
import org.apache.kylin.common.KylinConfig;

public enum MailNotificationType {
    JOB_LOAD_EMPTY_DATA("Job Load Empty Data", "JOB_LOAD_EMPTY_DATA", null){

        @Override
        public boolean needNotify(KylinConfig kylinconfig) {
            return kylinconfig.getJobDataLoadEmptyNotificationEnabled();
        }
    }
    ,
    JOB_ERROR("Job Error", "JOB_ERROR", "error"){

        @Override
        public boolean needNotify(KylinConfig kylinconfig) {
            return this.needNotifyStates(kylinconfig).stream().anyMatch(item -> this.getCorrespondingJobStates().equalsIgnoreCase((String)item));
        }
    }
    ,
    JOB_FINISHED("Job Finished", "JOB_FINISHED", "finished"){

        @Override
        public boolean needNotify(KylinConfig kylinconfig) {
            return this.needNotifyStates(kylinconfig).stream().anyMatch(item -> this.getCorrespondingJobStates().equalsIgnoreCase((String)item));
        }
    }
    ,
    JOB_DISCARDED("Job Discarded", "JOB_DISCARDED", "discarded"){

        @Override
        public boolean needNotify(KylinConfig kylinconfig) {
            return this.needNotifyStates(kylinconfig).stream().anyMatch(item -> this.getCorrespondingJobStates().equalsIgnoreCase((String)item));
        }
    }
    ,
    OVER_LICENSE_CAPACITY_THRESHOLD("Over License Capacity Threshold", "OVER_LICENSE_CAPACITY_THRESHOLD", null){

        @Override
        public boolean needNotify(KylinConfig kylinconfig) {
            return kylinconfig.isOverCapacityNotificationEnabled();
        }
    };

    private final String displayName;
    private final String correspondingJobStates;
    private final String correspondingTemplateName;

    private MailNotificationType(String displayName, String correspondingTemplateName, String correspondingJobStates) {
        this.displayName = displayName;
        this.correspondingTemplateName = correspondingTemplateName;
        this.correspondingJobStates = correspondingJobStates;
    }

    public abstract boolean needNotify(KylinConfig var1);

    public List<String> needNotifyStates(KylinConfig kylinConfig) {
        String[] specifiedStates;
        ArrayList<String> needNotifyStates = new ArrayList<String>();
        if (kylinConfig.getJobErrorNotificationEnabled()) {
            needNotifyStates.add("error");
        }
        if ((specifiedStates = kylinConfig.getJobNotificationStates()) != null) {
            needNotifyStates.addAll(Arrays.asList(specifiedStates));
        }
        return needNotifyStates;
    }

    @Generated
    public String getDisplayName() {
        return this.displayName;
    }

    @Generated
    public String getCorrespondingJobStates() {
        return this.correspondingJobStates;
    }

    @Generated
    public String getCorrespondingTemplateName() {
        return this.correspondingTemplateName;
    }
}

