/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.common.mail;

import java.nio.charset.StandardCharsets;
import java.util.List;
import org.apache.commons.mail.EmailException;
import org.apache.commons.mail.HtmlEmail;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.util.EncryptUtil;

public class MailService {
    private boolean starttlsEnabled;
    private String host;
    private String port;
    private String username;
    private String password;
    private String sender;

    public MailService(KylinConfig config) {
        this(config.isStarttlsEnabled(), config.getMailHost(), config.getSmtpPort(), config.getMailUsername(), config.getMailPassword(), config.getMailSender());
    }

    private MailService(boolean starttlsEnabled, String host, String port, String username, String password, String sender) {
        this.starttlsEnabled = starttlsEnabled;
        this.host = host;
        this.port = port;
        this.username = username;
        if (EncryptUtil.isEncrypted(password)) {
            password = EncryptUtil.decryptPassInKylin(password);
        }
        this.password = password;
        this.sender = sender;
    }

    public boolean sendMail(List<String> receivers, String subject, String content) throws EmailException {
        return this.sendMail(receivers, subject, content, true);
    }

    public boolean sendMail(List<String> receivers, String subject, String content, boolean isHtmlMsg) throws EmailException {
        HtmlEmail email = new HtmlEmail();
        email.setHostName(this.host);
        email.setStartTLSEnabled(this.starttlsEnabled);
        if (this.starttlsEnabled) {
            if (!this.port.equals("25")) {
                email.setSSLOnConnect(true);
                email.setSSLCheckServerIdentity(true);
            }
            email.setSslSmtpPort(this.port);
        } else {
            email.setSmtpPort(Integer.parseInt(this.port));
        }
        if (this.username != null && this.username.trim().length() > 0) {
            email.setAuthentication(this.username, this.password);
        }
        for (String receiver : receivers) {
            email.addTo(receiver);
        }
        email.setFrom(this.sender);
        email.setSubject(subject);
        email.setCharset(StandardCharsets.UTF_8.toString());
        if (isHtmlMsg) {
            email.setHtmlMsg(content);
        } else {
            email.setTextMsg(content);
        }
        email.send();
        email.getMailSession();
        return true;
    }
}

