/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.common.msg;

import java.util.List;
import java.util.Locale;
import org.apache.kylin.common.Singletons;

public class Message {
    private static final String DISABLE_PUSHDOWN_PROMPT = "You should turn on pushdown button if you want to pushdown.";
    private static final String NON_EXISTEN_MODEL = "Model %s doesn't exist. Please confirm and try again later.";
    private static final String LACK_PROJECT = "Please fill in the project parameters.";
    private static final String NON_EXIST_PROJECT = "Project %s doesn't exist. Please confirm and try again later.";
    private static final String MODIFY_PERMISSION_OF_SUPER_ADMIN = "Super Admin\u2019s permission can\u2019t be modified.";
    private static final String ILLEGAL_AUTHORIZING_USER = "Unable to modify. Only Super Admin or System Admin with query permission can modify query permission.";
    private static final String GRANT_TO_NON_SYSTEM_ADMIN = "Unable to modify. You can only modify the permission of the System Admin.";
    private static final String MODIFY_OWN_PERMISSION_FAILED = "Can\u2019t modify your own permission.";
    private static final String PROFILING_NOT_ENABLED = "Async profiling is not enabled. check parameter '%s'";
    private static final String PROFILING_STATUS_ERROR = "Async profiler status error, ";
    private static final String PROFILING_COLLECT_TIMEOUT = "Async profiler timeout";
    private static final String PARAMETER_EMPTY = "Please enter the value for the parameter '%s'.";
    private static final String PARAMETER_MUST_BE_POSITIVE_NUMBER = "The value of %s must be a positive number.";
    private static final String DDL_UNSUPPORTED = "Unsupported DDL syntax, only support single `create view`, `drop view`,  `alter view`, `show create table`";
    private static final String DDL_VIEW_NAME_ERROR = "View names need to start with KYLIN_";
    private static final String DDL_VIEW_NAME_DUPLICATE_ERROR = "Logical View names is duplicate";
    private static final String DDL_DROP_ERROR = "Only support drop view";
    private static final String DDL_TABLE_NOT_LOADED = "Table '%s' is not loaded into the data source ";
    private static final String DDL_TABLE_NOT_SUPPORT = "Only support hive table, but '%s' is not hive table";
    private static final String DDL_DATABASE_ACCESSN_DENIED = "The user does not have the database permission to which the view belongs.";
    private static final String DDL_LOGICAL_VIEW_HAS_USED = "Table %s has already been loaded in project %s, please unload it before deleting this table.";
    private static final String DDL_LOGICAL_VIEW_SOURCETABLE_ERROR = "Source table %s is a logical view and is not allowed to be used in SQL";
    private static final String DDL_RESTRICT = "Only support %s syntax";
    private static final String LOAD_LOGICAL_VIEW_ERROR = "Can't load table %s, table can only be loaded in project %s";
    public static final String LOAD_GLUTEN_CACHE_EXECUTE_ERROR = "Load gluten cache execute has error. %s";
    public static final String LOAD_GLUTEN_CACHE_ROUTE_ERROR = "route cache request has error, message is [%s]";
    public static final String LOAD_GLUTEN_CACHE_ROUTE_EXECUTE_ERROR = "route cache has error, some query node cache failed";
    public static final String LOAD_GLUTEN_CACHE_ROUTE_RESPONSE_EMPTY = "route cache request has error, response body is empty";

    protected Message() {
    }

    public static Message getInstance() {
        return Singletons.getInstance(Message.class);
    }

    public String getCheckCcAmbiguity() {
        return "The computed column name \"%s\" has been used in the current model. Please rename it.";
    }

    public String getSegNotFound() {
        return "Can\u2018t find segment \"%s\" in model \"%s\". Please try again.";
    }

    public String getAclInfoNotFound() {
        return "Unable to find ACL information for object identity '%s'.";
    }

    public String getAclDomainNotFound() {
        return "Can\u2019t authorize at the moment due to unknown object. Please try again later, or contact technical support.";
    }

    public String getParentAclNotFound() {
        return "Can\u2019t authorize at the moment due to unknown object. Please try again later, or contact technical support.";
    }

    public String getIdentityExistChildren() {
        return "Children exists for '%s'.";
    }

    public String getInitMeasureFailed() {
        return "Can\u2019t initialize metadata at the moment. Please try restarting first. If the problem still exist, please contact technical support.";
    }

    public String getInvalidDimensionName() {
        return "The dimension name \"%s\" is invalid. Please use only characters, numbers, spaces and symbol(_ -()%%?). %s characters at maximum are supported.";
    }

    public String getInvalidMeasureName() {
        return "The measure name \"%s\" is invalid. Please use Chinese or English characters, numbers, spaces or symbol(_ -()%%?.). %s characters at maximum are supported.";
    }

    public String getDuplicateDimensionName() {
        return "Dimension name \"%s\" already exists. Please rename it. ";
    }

    public String getDuplicateMeasureName() {
        return "Measure name \"%s\" already exists. Please rename it. ";
    }

    public String getDuplicateMeasureDefinition() {
        return "The definition of this measure  is the same as measure \"%s\". Please modify it.";
    }

    public String getDuplicateInternalMeasureDefinition() {
        return "The definition of this measure  is the same as internal measure \"%s\". Please modify it.";
    }

    public String getDuplicateJoinConditions() {
        return "Can\u2019t create the join condition between \"%s\" and \"%s\", because a same one already exists.";
    }

    public String getDuplicateModelName() {
        return "Model name '%s' is duplicated, could not be created.";
    }

    public String getBrokenModelOperationDenied() {
        return "BROKEN model \"%s\" cannot be operated.";
    }

    public String getModelModifyAbandon(String table) {
        return String.format(Locale.ROOT, "Model is not support to modify because you do not have permission of '%s'", table);
    }

    public String getEmptyProjectName() {
        return "Can\u2019t find project information. Please select a project.";
    }

    public String getGrantTableWithSidHasNotProjectPermission() {
        return "Failed to add table-level permissions.  User  (group)  [%s] has no project [%s] permissions.  Please grant user (group) project-level permissions first.";
    }

    public String getCheckCCType() {
        return "The actual data type \"{1}\" of computed column \"{0}\" is inconsistent with the defined type \"{2}\". Please modify it.";
    }

    public String getCheckCCExpression() {
        return "Can\u2019t validate the expression \"%s\" (computed column: %s). Please check the expression, or try again later.";
    }

    public String getModelMetadataPackageInvalid() {
        return "Can\u2019t parse the file. Please ensure that the file is complete.";
    }

    public String getExportBrokenModel() {
        return "Can\u2019t export model \"%s\"  as it\u2019s in \"BROKEN\" status. Please re-select and try again.";
    }

    public String getImportBrokenModel() {
        return "Model [%s] is broken, can not export.";
    }

    public String getImportModelException() {
        return "Can\u2019t import the model.";
    }

    public String getUnSuitableImportType(String optionalType) {
        if (optionalType == null) {
            return "Can\u2019t select ImportType \"%s\" for the model \"%s\". Please select \"UN_IMPORT\".";
        }
        return "Can\u2019t select ImportType \"%s\" for the model \"%s\". Please select \"UN_IMPORT\" (or \"" + optionalType + "\").";
    }

    public String getCreateInternalTableFailed() {
        return "Failed to create internal table for table \"%s\". ";
    }

    public String getInvalidInternalTableParameters() {
        return "Invalid internal table parameters.";
    }

    public String getGlutenDisabled() {
        return "Gluten is disabled in query function, please enable it and try again.";
    }

    public String getDatePartitionColumnNotFound() {
        return "Date format partition column must be set in an incremental load table.";
    }

    public String getIncorrectDateformat() {
        return "Date partition format \"%s\" is not correct.";
    }

    public String getPartitionColumnIgnored_WARNING() {
        return "Partition columns are ignored when converting multiple tables to internal tables";
    }

    public String getCanNotOverwriteModel() {
        return "Can\u2019t overwrite the model \"%s\", as it doesn\u2019t exist. Please re-select and try again.";
    }

    public String getIllegalModelMetadataFile() {
        return "Can\u2019t parse the metadata file. Please don\u2019t modify the content or zip the file manually after unzip.";
    }

    public String getExportAtLeastOneModel() {
        return "Please select at least one model to export.";
    }

    public String getComputedColumnExpressionDuplicated() {
        return "The expression of computed column has already been used in model '%s' as '%s'. Please modify the name to keep consistent, or use a different expression.";
    }

    public String getComputedColumnExpressionDuplicatedSingleModel() {
        return "This expression has already been used by other computed columns in this model. Please modify it.";
    }

    public String getComputedColumnNameDuplicated() {
        return "The name of computed column '%s' has already been used in model '%s', and the expression is '%s'. Please modify the expression to keep consistent, or use a different name.";
    }

    public String getComputedColumnNameDuplicatedSingleModel() {
        return "This name has already been used by other computed columns in this model. Please modify it.";
    }

    public String getModelChangePermission() {
        return "Don\u2019t have permission. The model\u2019s owner could only be changed by system or project admin.";
    }

    public String getModelOwnerChangeInvalidUser() {
        return "This user can\u2019t be set as the model\u2019s owner. Please select system admin, project admin or management user.";
    }

    public String getIllegalTimeFilter() {
        return "The selected time filter is invalid. Please select again.";
    }

    public String getJobSortByError() {
        return "The parameter \"sort_by\" only supports 'id', 'project', 'create_time', 'last_modified', 'job_name', 'target_subject', 'duration'.";
    }

    public String getIllegalExecutableState() {
        return "The job status is invalid. Please select again.";
    }

    public String getIllegalJobState() {
        return "The job status is invalid. The value must be \u201cPENDING\u201c, \u201cRUNNING\u201c, \u201cFINISHED\u201c, \u201cERROR\u201d or \u201cDISCARDED\u201c. Please check and try again.";
    }

    public String getIllegalJobAction() {
        return "Invalid value in parameter \u201caction\u201c or \u201cstatuses\u201c or \u201cjob_ids\u201c,  The value of \u201cstatuses\u201c or the status of jobs specified by \u201cjob_ids\u201c contains \u201c%s\u201c, this status of jobs can only perform the following actions: \u201c%s\u201c .";
    }

    public String getIllegalSortByFilter() {
        return "The selected sort filter \"%s\" is invalid. Please select again.";
    }

    public String getUserNotExist() {
        return "User '%s' does not exist. Please make sure the user exists.";
    }

    public String getUserGroupNotExist() {
        return "Invalid values in parameter \u201cgroup_name\u201c. The value %s doesn\u2019t exist.";
    }

    public String getUserGroupExist() {
        return "The user group \"%s\" already exists. Please check and try again.";
    }

    public String getEmptySid() {
        return "User/Group name should not be empty.";
    }

    public String getInvalidQueryName() {
        return "Query name should only contain alphanumerics and underscores.";
    }

    public String getEmptyUserName() {
        return "Username should not be empty.";
    }

    public String getShortPassword() {
        return "The password should contain more than 8 characters!";
    }

    public String getInvalidPassword() {
        return "The password should contain at least one number, letter and special character (~!@#$%^&*(){}|:\"<>?[];\\'\\,./`).";
    }

    public String getPermissionDenied() {
        return "Permission denied!";
    }

    public String getSelfDeleteForbidden() {
        return "Cannot delete yourself!";
    }

    public String getSelfDisableForbidden() {
        return "Cannot disable yourself!";
    }

    public String getSelfEditForbidden() {
        return "The object is invalid. Please check and try again.";
    }

    public String getUserEditNotAllowed() {
        return "User editing operations under the LDAP authentication mechanism are not supported at this time";
    }

    public String getUserEditNotAllowedForCustom() {
        return "User editing is not allowed unless in current custom profile, function '%s' not implemented";
    }

    public String getGroupEditNotAllowed() {
        return "Group editing is not allowed unless in testing profile, please go to LDAP/SAML provider instead";
    }

    public String getGroupEditNotAllowedForCustom() {
        return "Group editing is not allowed unless in current custom profile, function '%s' not implemented";
    }

    public String getOldPasswordWrong() {
        return "Old password is not correct!";
    }

    public String getNewPasswordSameAsOld() {
        return "New password should not be same as old one!";
    }

    public String getInvalidExecuteAsUser() {
        return "User [%s] in the executeAs field does not exist";
    }

    public String getServiceAccountNotAllowed() {
        return "User [%s] does not have permissions for all tables, rows, and columns in the project [%s] and cannot use the executeAs parameter";
    }

    public String getExecuteAsNotEnabled() {
        return "Configuration item \"kylin.query.query-with-execute-as\" is not enabled. So you cannot use the \"executeAs\" parameter now";
    }

    public String getUserBeLocked(long seconds) {
        return "Invalid username or password. Please try again after " + this.formatSeconds(seconds) + ".";
    }

    public String getUserInLockedStatus(long leftSeconds, long nextLockSeconds) {
        return "For security concern, account %s has been locked. Please try again in " + this.formatSeconds(leftSeconds) + ". " + this.formatNextLockDuration(nextLockSeconds) + ".";
    }

    protected String formatNextLockDuration(long nextLockSeconds) {
        if (Long.MAX_VALUE == nextLockSeconds) {
            return "Login failure again will be locked permanently.";
        }
        return "Login failure again will be locked for " + this.formatSeconds(nextLockSeconds) + ".";
    }

    protected String formatSeconds(long seconds) {
        long remainingSeconds = seconds % 60L;
        long remainingMinutes = (seconds - remainingSeconds) / 60L % 60L;
        long remainingHour = (seconds - remainingSeconds - remainingMinutes * 60L) / 3600L % 24L;
        long remainingDay = (seconds - remainingSeconds - remainingMinutes * 60L - remainingHour * 3600L) / 86400L;
        String formatTimeMessage = this.formatTime(remainingDay, remainingHour, remainingMinutes, remainingSeconds);
        return !formatTimeMessage.isEmpty() ? formatTimeMessage.substring(0, formatTimeMessage.length() - 1) : formatTimeMessage;
    }

    protected String formatTime(long day, long hour, long min, long second) {
        StringBuilder stringBuilder = new StringBuilder();
        if (day > 0L) {
            stringBuilder.append(day).append(" days ");
        }
        if (hour > 0L) {
            stringBuilder.append(hour).append(" hours ");
        }
        if (min > 0L) {
            stringBuilder.append(min).append(" minutes ");
        }
        if (second > 0L) {
            stringBuilder.append(second).append(" seconds ");
        }
        return stringBuilder.toString();
    }

    public String getUserInPermanentlyLockedStatus() {
        return "User %s is locked permanently. Please contact to your administrator to reset.";
    }

    public String getOwnerChangeError() {
        return "The change failed. Please try again.";
    }

    public String getInvalidProjectName() {
        return "Please use number, letter, and underline to name your project, and start with a number or a letter.";
    }

    public String getProjectNameIsIllegal() {
        return "The project name can\u2019t exceed 50 characters. Please re-enter.";
    }

    public String getProjectAlreadyExist() {
        return "The project name \"%s\" already exists. Please rename it.";
    }

    public String getProjectDropFailedJobsNotKilled() {
        return "Can't delete project \"%s\", please discard the related job and try again.";
    }

    public String getProjectUnmodifiableReason() {
        return "Model recommendation is not supported for this project at the moment. Please turn on the recommendation mode in project setting, and try again.";
    }

    public String getProjectOngoingOptimization() {
        return "System is optimizing historical queries at the moment. Please try again later. ";
    }

    public String getProjectChangePermission() {
        return "Don\u2019t have permission. The owner of project could only be changed by system admin.";
    }

    public String getProjectOwnerChangeInvalidUser() {
        return "This user can\u2019t be set as the project\u2019s owner. Please select system admin, or the admin of this project.";
    }

    public String getTableParamEmpty() {
        return "Can\u2019t find the table. Please check and try again";
    }

    public String getTableNotFound() {
        return "Can\u2019t find table \"%s\". Please check and try again.";
    }

    public String getInternalTableNotFound() {
        return "Can\u2019t find internal table \"%s\". Please check and try again.";
    }

    public String getInternalTableEmpty() {
        return "Can't update non empty internal table \"%s\", Please check and try again.";
    }

    public String getSameInternalTableNameExist() {
        return "Internal table %s already exists, please choose a different name.";
    }

    public String getInternalTablePath() {
        return "Failed to create internal table location.";
    }

    public String getInternalTableUnpartitioned() {
        return "Incremental build is not supported for unPartitioned table.";
    }

    public String getNonTimeInternalTableIncrementalBuild() {
        return "Non-time partition table do not support incremental partition refresh. Please specify partitions to refresh.";
    }

    public String getTimeOutOfRange() {
        return "current time range is out of data range, please check again.";
    }

    public String getTimeRangeOverlap() {
        return "Unable to submit task, time range overlaps with the task currently being built, please check again.";
    }

    public String getInternalTableNullPartitionFormat() {
        return "date_partition_format can not be null, please check again.";
    }

    public String getInternalTableNoDataCol() {
        return "couldn't find date_col present in partition_cols, please check again. ";
    }

    public String getTimeExceedPartitionRange() {
        return "Refresh time exceed loaded range :\"%s\" ~ \"%s\", Please check and try again. ";
    }

    public String getInternalTablePartitionNotFound() {
        return "Can't find internal table partitions: %s. Please check and try again.";
    }

    public String getFailedReloadNoneEmptyInternalTable() {
        return "Can't reload none empty internal table \"%s\". Please truncate table first and try again.";
    }

    public String getNotInternalTable() {
        return "Table \"%s\" is not an internal table. Please check and try again.";
    }

    public String getInternalTableDisabled() {
        return "InternalTable is disabled, please enable it and try again.";
    }

    public String getSamplingFailedForIllegalTableName() {
        return "The name of table for sampling is invalid. Please enter a table name like \u201cdatabase.table\u201d. ";
    }

    public String getFailedForNoSamplingTable() {
        return "Can\u2019t perform table sampling. Please select at least one table.";
    }

    public String getReloadTableCcRetry() {
        return "%1$s The data type of column %3$s in table %2$s has been changed. Please try deleting the computed column or changing the data type.";
    }

    public String getSameTableNameExist() {
        return "Table %s already exists, please choose a different name.";
    }

    public String getnotSupportedSql() {
        return "This SQL is not supported at the moment. Please try a different SQL.";
    }

    public String getQueryTooManyRunning() {
        return "Can\u2019t submit query at the moment as there are too many ongoing queries. Please try again later, or contact project admin to adjust configuration.";
    }

    public String getGlutenCacheTooManyRunning() {
        return "Can\u2019t submit cache command at the moment as there are too many ongoing commands. Please try again later, or contact project admin to adjust configuration.";
    }

    public String getAsyncQueryTooManyRunning() {
        return "Query failed cause the total number of async queries hit the upper limit set by Admin.Please wait and try again.";
    }

    public String getExportResultNotAllowed() {
        return "Don\u2019t have permission to export the query result. Please contact admin if needed.";
    }

    public String getForbiddenExportAsyncQueryResult() {
        return "Access denied. Only task submitters or admin users can download the query results";
    }

    public String getDuplicateQueryName() {
        return "Query named \"%s\" already exists. Please check and try again.";
    }

    public String getNullEmptySql() {
        return "SQL can\u2019t be empty. Please check and try again.";
    }

    public String getJobStartFailure() {
        return "Can\u2019t start the streaming job of model \"%s\", as it has an ongoing one at the moment. Please check and try again.";
    }

    public String getJobBrokenModelStartFailure() {
        return "Can\u2019t start. Model \"%s\" is currently broken. ";
    }

    public String getAclPermissionRequired() {
        return "Acl permission required.";
    }

    public String getSidRequired() {
        return "Sid required.";
    }

    public String getRevokeAdminPermission() {
        return "Can't revoke admin permission of owner.";
    }

    public String getEmptyPermission() {
        return "Permission should not be empty.";
    }

    public String getInvalidPermission() {
        return "Invalid values in parameter \"permission\". The value should either be \"ADMIN\", \"MANAGEMENT\", \"OPERATION\" or \"QUERY\".";
    }

    public String getUnauthorizedSid() {
        return "The user/group doesn\u2019t have access to this project.";
    }

    public String getAccessDeny() {
        return "The user doesn't have access.";
    }

    public String getQueryResultNotFound() {
        return "Can\u2019t find the query by this query ID in this project. Please check and try again.";
    }

    public String getQueryResultFileNotFound() {
        return "Can\u2019t find the file of query results. Please check and try again.";
    }

    public String getQueryExceptionFileNotFound() {
        return "Can\u2019t get the query status for the failed async query. Please check and try again.";
    }

    public String getCleanFolderFail() {
        return "Can\u2019t clean file folder at the moment. Please ensure that the related file on HDFS could be accessed.";
    }

    public String getUserNotFound() {
        return "User '%s' not found.";
    }

    public String getDiagPackageNotAvailable() {
        return "Diagnostic package is not available in directory: %s.";
    }

    public String getDiagFailed() {
        return "Can\u2019t generate diagnostic package. Please try regenerating it.";
    }

    public String getFrequencyThresholdCanNotEmpty() {
        return "The query frequency threshold cannot be empty";
    }

    public String getRecommendationLimitNotEmpty() {
        return "The limit of recommendations for adding index cannot be empty.";
    }

    public String getDelayThresholdCanNotEmpty() {
        return "The query delay threshold cannot be empty";
    }

    public String getMinHitCountNotEmpty() {
        return "The hits cannot be empty";
    }

    public String getEffectiveDaysNotEmpty() {
        return "The time frame cannot be empty";
    }

    public String getUpdateFrequencyNotEmpty() {
        return "The recommendation frequency cannot be empty";
    }

    public String getAutoCompleteModeNotValid() {
        return "ABSOLUTE or RELATIVE should be selected for auto-completion.";
    }

    public String getSemiAutoNotEnabled() {
        return "You need to enable semi-auto-mode first to enable auto-index-plan";
    }

    public String getAutoIndexPlanNotEnabled() {
        return "You need to enable auto-index-plan before job submission";
    }

    public String getInvalidDateUnit() {
        return "The expected date unit is YEAR/WEEK/MONTH/DAY while the input is %s.";
    }

    public String getWhiteListNotInExistingIndex() {
        return "The indexes %s to be whitelisted is not in the list of existing indexes.";
    }

    public String getIndexesNotInWhiteList() {
        return "The indexes %s to be deleted from the whitelist is not in the whitelist.";
    }

    public String getNotAllowedMultipleAutoIndexPlanJob() {
        return "Multiple auto-index-plan job at the same time.";
    }

    public String getInstantInitNotAllowed() {
        return "The model already has data and is not allowed to set instant-init-index-num.";
    }

    public String getInstantInitTooMuch() {
        return "Quickly create up to %d indexes.";
    }

    public String getInstantInitTooLittle() {
        return "Can't be less than the current index number %d.";
    }

    public String getSqlNumberExceedsLimit() {
        return "Up to %s SQLs could be imported at a time";
    }

    public String getSqlListIsEmpty() {
        return "Please enter the parameter \u201csqls\u201c.";
    }

    public String getConfigMapEmpty() {
        return "The configuration list can\u2019t be empty. Please check and try again.";
    }

    public String getLowLevelLicenseMessage() {
        return "Please upgrade to Kyligence Premium version if you want to use the function.";
    }

    public String getRestartNoticeMessage() {
        return "Some functions need to restart and try again.";
    }

    public String saveModelFail() {
        return "Can\u2019t save model \"%s\". Please ensure that the used column \"%s\" exist in source table \"%s\".";
    }

    public String getViewDateFormatDetectionError() {
        return "It is not supported to obtain the time format of the partition column or the data range of the view table, please manually select or enter.";
    }

    public String getPushdownPartitionFormatError() {
        return "Can\u2019t detect at the moment. Please set the partition format manually.";
    }

    public String getPushdownDatarangeError() {
        return "Can\u2019t detect at the moment. Please set the data range manually.";
    }

    public String getpushdownDatarangeTimeout() {
        return "Can\u2019t detect at the moment. Please set the data range manually.";
    }

    public String getDimensionNotfound() {
        return "The dimension %s is referenced by indexes or aggregate groups. Please go to the Data Asset - Model - Index page to view, delete referenced aggregate groups and indexes.";
    }

    public String getMeasureNotfound() {
        return "The measure %s is referenced by indexes or aggregate groups. Please go to the Data Asset - Model - Index page to view, delete referenced aggregate groups and indexes.";
    }

    public String getNestedCcCascadeError() {
        return "Can\u2019t modify computed column \"%s\". It\u2019s been referenced by a nested computed column \"%s\" in the current model. Please remove it from the nested column first.";
    }

    public String getccOnAntiFlattenLookup() {
        return "Can\u2019t use the columns from dimension table \u201c%s\u201c for computed columns, as the join relationships of this table won\u2019t be precomputed.";
    }

    public String getFilterConditionOnAntiFlattenLookup() {
        return "Can\u2019t use the columns from dimension table \u201c%s\u201c for data filter condition, as the join relationships of this table won\u2019t be precomputed.";
    }

    public String getChangeGlobaladmin() {
        return "You cannot add,modify or remove the system administrator\u2019s rights";
    }

    public String getChangeDefaultadmin() {
        return "Can\u2019t modify the permission of user \u201cADMIN\u201d, as this user is a built-in admin by default.";
    }

    public String getInvalidUserTag() {
        return "Can\u2019t add the tag, as the length exceeds the maximum 256 characters. Please modify it.";
    }

    public String getInvalidId() {
        return "Can\u2019t find ID \"%s\". Please check and try again.";
    }

    public String getNoActiveLeaders() {
        return "There is no active leader node. Please contact system admin to check and fix.";
    }

    public String getPrincipalEmpty() {
        return "Principal name cannot be null.";
    }

    public String getKeytabFileTypeMismatch() {
        return "The suffix of keytab file must be 'keytab'.";
    }

    public String getKerberosInfoError() {
        return "Invalid principal name or keytab file, please check and submit again.";
    }

    public String getProjectHivePermissionError() {
        return "Permission denied. Please confirm the Kerberos account can access all the loaded tables.";
    }

    public String getLeadersHandleOver() {
        return "System is trying to recover service. Please try again later.";
    }

    public String getTableRefreshError() {
        return "Can\u2019t connect to data source due to unexpected error. Please refresh and try again.";
    }

    public String getTableRefreshNotfound() {
        return "Can\u2019t connect to data source due to unexpected error. Please refresh and try again.";
    }

    public String getTableRefreshParamInvalid() {
        return "The \u201ctable\u201c parameter is invalid. Please check and try again.";
    }

    public String getTableRefreshParamMore() {
        return "There exists invalid filed(s) other than the expected \u201ctables\u201c. Please check and try again.";
    }

    public String getTransferFailed() {
        return "Can\u2019t transfer the request at the moment. Please try again later.";
    }

    public String getUserExists() {
        return "Username:[%s] already exists";
    }

    public String getOperationFailedByUserNotExist() {
        return "Operation failed, user:[%s] not exists, please add it first";
    }

    public String getModifyPermissionOfSuperAdminFailed() {
        return MODIFY_PERMISSION_OF_SUPER_ADMIN;
    }

    public String getGrantPermissionFailedByIllegalAuthorizingUser() {
        return ILLEGAL_AUTHORIZING_USER;
    }

    public String getGrantPermissionFailedByNonSystemAdmin() {
        return GRANT_TO_NON_SYSTEM_ADMIN;
    }

    public String getModifyOwnPermissionFailed() {
        return MODIFY_OWN_PERMISSION_FAILED;
    }

    public String getColumuIsNotDimension() {
        return "Please add column \"%s\" as a dimension.";
    }

    public String getModelCanNotPurge() {
        return "Can\u2019t purge data by specifying model \"%s\" under the current project settings.";
    }

    public String getModelSegmentCanNotRemove() {
        return "Can\u2019t delete the segment(s) in model \"%s\" under the current project settings.";
    }

    public String getSegmentCanNotRefresh() {
        return "Can\u2019t refresh some segments, as they are being built at the moment. Please try again later.";
    }

    public String getSegmentCanNotRefreshBySegmentChange() {
        return "Can\u2019t refresh at the moment, as the segment range has changed. Please try again later.";
    }

    public String getCanNotBuildSegment() {
        return "Can\u2019t build segment(s). Please add some indexes first.";
    }

    public String getCanNotBuildIndicesManually() {
        return "Can\u2019t manually build indexes in model \"%s\" under the current project settings.";
    }

    public String getInvalidMergeSegment() {
        return "Can\u2019t merge segments which are not ready yet.";
    }

    public String getInvalidSetTableIncLoading() {
        return "Can\u2018t set table \"%s\" as incremental loading. It\u2019s been used as a dimension table in model \"%s\".";
    }

    public String getInvalidRefreshSegmentByNoSegment() {
        return "There is no ready segment to refresh at the moment. Please try again later.";
    }

    public String getInvalidRefreshSegmentByNotReady() {
        return "Can\u2019t refresh at the moment. Please ensure that all segments within the refresh range is ready.";
    }

    public String getInvalidLoadHiveTableName() {
        return "Can\u2019t operate now. Please set \u201ckap.table.load-hive-tablename-cached.enabled=true\u201d, and try again.";
    }

    public String getInvalidRemoveUserFromAllUser() {
        return "Can not remove user from ALL USERS group.";
    }

    public String getAccessDenyOnlyAdmin() {
        return "Access Denied, only system and project administrators can edit users' tables, columns, and rows permissions";
    }

    public String getAccessDenyOnlyAdminAndProjectAdmin() {
        return "Access Denied, only system administrators can edit users' tables, columns, and rows permissions";
    }

    public String getInvalidRefreshSegment() {
        return "Please select at least one segment to refresh.";
    }

    public String getEmptySegmentParameter() {
        return "Please enter segment ID or name.";
    }

    public String getEmailUsernameCompanyCanNotEmpty() {
        return "Email, username, company can not be empty";
    }

    public String getEmailUsernameCompanyIsIllegal() {
        return "Email, username, company length should be less or equal than 50";
    }

    public String getInvalidComputerColumnNameWithKeyword() {
        return "The computed column name \"%s\" is a SQL keyword. Please choose another name.";
    }

    public String getInvalidComputerColumnName() {
        return "The computed column name \"%s\" is invalid. Please starts with a letter, and use only letters, numbers, and underlines. Please rename it.";
    }

    public String getModelAliasDuplicated() {
        return "Model \"%s\" already exists. Please rename it.";
    }

    public String getIdCannotEmpty() {
        return "ID can\u2019t be empty. Please check and try again.";
    }

    public String getInvalidCreateModel() {
        return "Can\u2019t add model manually under this project.";
    }

    public String getPartitionColumnNotExist() {
        return "Can\u2019t find the partition column. Please check and try again.";
    }

    public String getDatePartitionFormatEmpty() {
        return "Date_partition_format can't be empty when partition columns is not empty. Please check and try again.";
    }

    public String getPartitionColumnStartError() {
        return "Can\u2019t start. Please ensure the time partition column is a timestamp column and the time format is valid.";
    }

    public String getPartitionColumnSaveError() {
        return "Can\u2019t submit. Please ensure the time partition column is a timestamp column and the time format is valid.";
    }

    public String getTimestampColumnNotExist() {
        return "Can\u2019t load. Please ensure the table has at least a timestamp column.";
    }

    public String getTimestampPartitionColumnNotExist() {
        return "Can\u2019t save the model. For fusion model, the time partition column must be added as a dimension.";
    }

    public String getInvalidPartitionColumn() {
        return "Please select an original column (not a computed column) from the fact table as time partition column.";
    }

    public String getTableNameCannotEmpty() {
        return "Table name can\u2019t be empty. Please check and try again.";
    }

    public String getTableOrDatabaseNameCannotEmpty() {
        return "Table or database can not be null, please check again.";
    }

    public String getFileNotExist() {
        return "Cannot find file [%s]";
    }

    public String getDatabaseNotExist() {
        return "Can\u2019t find database \"%s\". Please check and try again.";
    }

    public String getBrokenModelCannotOnoffline() {
        return "Can\u2019t get model \"%s\" online or offline, as it\u2019s in BROKEN state.";
    }

    public String getInvalidNameStartWithDot() {
        return "The user / group names cannot start with a period (.).";
    }

    public String getInvalidNameStartOrEndWithBlank() {
        return "User / group names cannot start or end with a space.";
    }

    public String getInvalidNameLength() {
        return "The username should contain less than 180 characters. Please check and try again.";
    }

    public String getInvalidNameContainsOtherCharacter() {
        return "Only alphanumeric characters can be used in user / group names";
    }

    public String getInvalidNameContainsInlegalCharacter() {
        return "The user / group names cannot contain the following symbols: backslash (\\),  slash mark (/), colon (:), asterisk (*), question mark (?),  quotation mark (\"), less than sign (<), greater than sign (>), vertical bar (|).";
    }

    public String getHiveTableNotFound() {
        return "Can\u2019t load table \"%s\". Please ensure that the table(s) could be found in the data source.";
    }

    public String getDuplicateLayout() {
        return "Can\u2019t add this index, as the same index already exists. Please modify.";
    }

    public String getDefaultReason() {
        return "Something went wrong. %s";
    }

    public String getDefaultSuggest() {
        return "Please contact Community support for more details.";
    }

    public String getUnexpectedToken() {
        return "Syntax error occurred at line %s, column %s: \"%s\". Please modify it.";
    }

    public String getBadSqlReason() {
        return "The SQL has syntax error: %s ";
    }

    public String getBadSqlSuggest() {
        return "Please modify it.";
    }

    public String getBadSqlTableNotFoundReason() {
        return "Can\u2019t find table \"%s\". Please check and try again.";
    }

    public String getBadSqlTableNotFoundSuggest() {
        return "Please add table \"%s\" to data source. If this table does exist, mention it as \"DATABASE.TABLE\".";
    }

    public String getBadSqlColumnNotFoundReason() {
        return "Can\u2019t find column \"%s\". Please check if it exists in the source table or computed columns. If exists, please try reloading the table; if not exist, please contact admin to add it.";
    }

    public String getBadSqlColumnNotFoundSuggest() {
        return this.getBadSqlColumnNotFoundReason();
    }

    public String getBadSqlColumnNotFoundInTableReason() {
        return this.getBadSqlColumnNotFoundReason();
    }

    public String getBadSqlColumnNotFoundInTableSuggestion() {
        return this.getBadSqlColumnNotFoundReason();
    }

    public String getProjectNumOverThreshold() {
        return "Failed to create a new project. The number of projects exceeds the maximum: {%s}. Please delete other abandoned projects before trying to create new ones or contact the administrator to adjust the maximum number of projects.";
    }

    public String getModelNumOverThreshold() {
        return "Failed to create a new model. The number of models exceeds the maximum: {%s}. Please delete other abandoned models before trying to create new ones or contact the administrator to adjust the maximum number of models.";
    }

    public String getAliasConflictOfApprovingRecommendation() {
        return "The name already exists. Please rename and try again.";
    }

    public String getInvalidTimeFormat() {
        return "Can\u2019t set the time partition column. The values of the selected column is not time formatted: {%s}. Please select again.";
    }

    public String getSegmentMergeStorageCheckError() {
        return "During segment merging, the HDFS storage space may exceed the threshold limit, and the system actively terminates the merging job. If you need to remove the above restrictions, please refer to the user manual to adjust the parameter kylin.cube.merge-segment-storage-threshold.";
    }

    public String getDimensionTableUsedInThisModel() {
        return "Can\u2019t set the dimension table of this model, as it has been used as fact table in this model. Please modify and try again.";
    }

    public String getNoDataInTable() {
        return "Can\u2019t get data from table \"%s\". Please check and try again.";
    }

    public String getEffectiveDimensionNotFind() {
        return "The following columns are not added as dimensions to the model. Please delete them before saving or add them to the model.\nColumn ID: %s";
    }

    public String getInvalidNullValue() {
        return "Failed to rewrite the model settings, %s parameter value is null.";
    }

    public String getInvalidIntegerFormat() {
        return "Can\u2019t rewrite the model settings. The value of  \"%s\" must be non-negative integer. Please modify and try again.";
    }

    public String getInvalidMemorySize() {
        return "Can\u2019t rewrite the model settings. The value of \"spark-conf.spark.executor.memory\" must be non-negative integer, with the unit of GB. Please modify and try again.";
    }

    public String getInvalidBooleanFormat() {
        return "Can\u2019t rewrite the model settings. The value of \"%s\" must be either \u201ctrue\u201d or \u201cfalse\u201d. Please modify and try again.";
    }

    public String getInvalidAutoMergeConfig() {
        return "Can\u2019t rewrite the model settings. The automatic merge range can\u2019t be empty. Please modify and try again.";
    }

    public String getInvalidVolatileRangeConfig() {
        return "Can\u2019t rewrite the model settings. The unit of the dynamic interval parameter must be either \"day\", \"week\", \"month\", or \"year\", and the value must be non-negative integer. Please modify and try again.";
    }

    public String getInvalidRetentionRangeConfig() {
        return "Failed to rewrite the model settings, parameter value must be non-negative integer and the unit of parameter must be the coarsest granularity unit in the unit selected for automatic merge.";
    }

    public String getDisabledUser() {
        return "This user is disabled. Please contact admin.";
    }

    public String getInvalidSidType() {
        return "Invalid value for parameter \u2018type\u2019 which should only be \u2018user\u2019 or \u2018group\u2019(case-insensitive).";
    }

    public String getEmptyDatabaseName() {
        return "Invalid value for parameter \u2018database_name\u2019 which should not be empty.";
    }

    public String getEmptyDatabase() {
        return "Please enter the value for the parameter \"Database\". ";
    }

    public String getEmptyTableList() {
        return "Please enter the value for the parameter \"Table\". ";
    }

    public String getEmptyTableName() {
        return "Invalid value for parameter \u2018table_name\u2019 which should not be empty.";
    }

    public String getEmptyColumnList() {
        return "Invalid value for parameter \u2018columns\u2019 which should not be empty.";
    }

    public String getEmptyRowList() {
        return "Invalid value for parameter \u2018rows\u2019 which should not be empty.";
    }

    public String getEmptyColumnName() {
        return "Invalid value for parameter \u2018column_name\u2019 which should not be empty.";
    }

    public String getEmptyItems() {
        return "Invalid value for parameter \u2018items\u2019 which should not be empty.";
    }

    public String getColumnNotExist() {
        return "Column:[%s] is not exist.";
    }

    public String getDatabaseParameterMissing() {
        return "All the databases should be defined and the database below are missing: (%s).";
    }

    public String getTableParameterMissing() {
        return "All the tables should be defined and the table below are missing: (%s).";
    }

    public String getColumnParameterMissing() {
        return "All the columns should be defined and the column below are missing: (%s).";
    }

    public String getColumnParameterInvalid(String column) {
        return String.format(Locale.ROOT, "Can\u2019t assign value(s) for the column \"%s\", as the value(s) doesn\u2019t match the column\u2019s data type. Please check and try again.", column);
    }

    public String getDatabaseParameterDuplicate() {
        return "Database [%s] is duplicated in API requests.";
    }

    public String getTableParameterDuplicate() {
        return "Table [%s] is duplicated in API requests.";
    }

    public String getColumnParameterDuplicate() {
        return "Column [%s] is duplicated in API requests.";
    }

    public String getAddJobCheckFail() {
        return "Can\u2019t submit the job at the moment, as a building job for the same object already exists. Please try again later.";
    }

    public String getAddExportJobFail() {
        return "Can\u2019t submit the job at the moment. There is an ongoing load data job of tiered storage for the same segment(s). Please try again later.";
    }

    public String getAddJobCheckFailWithoutBaseIndex() {
        return "Can\u2019t submit the job at the moment. The segment \u201c%s\u201d doesn\u2019t have base index. Please refresh this segment.";
    }

    public String getAddJobCheckSegmentReadyFail() {
        return "Can\u2019t submit the job, as there are no segments in READY status. Please try again later.";
    }

    public String getTableReloadAddColumnExist(String table, String column) {
        return String.format(Locale.ROOT, "Can\u2019t reload the table at the moment. Column \"%s\" already exists in table \"%s\". Please modify and try again.", table, column);
    }

    public String getColumnUnrecognized() {
        return "Can\u2019t recognize column \"%s\". Please use \"TABLE_ALIAS.COLUMN\" to reference a column.";
    }

    public String getCOMMA() {
        return ", ";
    }

    public String getRecListOutOfDate() {
        return "The recommendation is invalid, as some of the related content was deleted. Please refresh the page and try again.";
    }

    public String getGroupUuidNotExist() {
        return "Can\u2019t operate user group (UUID: %s). Please check and try again.";
    }

    public String getModelOnlineWithEmptySeg() {
        return "This model can\u2019t go online as it doesn\u2019t have segments. Models with no segment couldn\u2019t serve queries. Please add a segment.";
    }

    public String getScd2ModelOnlineWithScd2ConfigOff() {
        return "This model can\u2019t go online as it includes non-equal join conditions(\u2265, <). Please delete those join conditions, or turn on 'Show non-equal join conditions for History table' in project settings.";
    }

    public String getConnectDatabaseError() {
        return "Can\u2019t connect to the RDBMS metastore. Please check if the metastore is working properly.";
    }

    public String getInvalidColumnAccess() {
        return "The current user or user group doesn\u2019t have access to the column \"%s\".";
    }

    public String getInvalidSensitiveDataMaskColumnType() {
        return "Can\u2019t do data masking for the data with type of boolean, map or array.";
    }

    public String getNotSupportNestedDependentCol() {
        return "Can\u2019t set association rules on the column \"%s\". This column has been associated with another column.";
    }

    public String getInvalidRowACLUpdate() {
        return "The parameter \u201crows\u201d or \u201clike_rows\u201d is invalid. Please use the parameter \u201crow_filter\u201d to update the row ACL.";
    }

    public String getSnapshotOperationPermissionDenied() {
        return "Don\u2019t have permission. Please ensure that you have required permission to the table which this snapshot is associated with.";
    }

    public String getSnapshotNotFound() {
        return "Can't find the snapshot \"%s\". Please check and try again.";
    }

    public String getSnapshotManagementNotEnabled() {
        return "Snapshot management is not enabled in the settings. Please check and try again.";
    }

    public String getPartitionsToBuildCannotBeEmpty(List<String> tableDescNames) {
        return "Please select at least one partition for the following snapshots when conducting custom partition value refresh: " + tableDescNames.toString();
    }

    public String getProjectWithoutResourceGroup() {
        return "Can\u2019t use this project properly as no resource group has been allocated yet. Please contact admin.";
    }

    public String getModelOnlineForbidden() {
        return "Can\u2019t get the model online. Please set the configuration \u201ckylin.model.offline\u201c as false first.";
    }

    public String getMultiPartitionMappingReqeustNotValid() {
        return "Can\u2019t update the mapping relationships of the partition column. The value for the parameter \u201cmulti_partition_columns\u201c doesn\u2019t match the partition column defined in the model. Please check and try again.";
    }

    public String getModelIsNotMlp() {
        return "\"%s\" is not a multilevel partitioning model. Please check and try again.";
    }

    public String getInvalidPartitionValue() {
        return "The subpartition(s) \u201c%s\u201c doesn\u2019t exist. Please check and try again.";
    }

    public String getPartitionValueNotSupport() {
        return "Model \"%s\" hasn\u2019t set a partition column yet. Please set it first and try again.";
    }

    public String getAdminPermissionUpdateAbandon() {
        return "Admin is not supported to update permission.";
    }

    public String getRowAclNotStringType() {
        return "The LIKE operator could only be used for the char or varchar data type. Please check and try again.";
    }

    public String getRowFilterExceedLimit() {
        return "The number of filters exceeds the upper limit (%s/%s). Please check and try again.";
    }

    public String getRowFilterItemExceedLimit() {
        return "The number of the included values of a single filter exceeds the upper limit (%s/%s). Please check and try again.";
    }

    public String getStopByUserErrorMessage() {
        return "Stopped by user.";
    }

    public String getExceedMaxAllowedPacket() {
        return "The result packet of MySQL exceeds the limit. Please contact the admin to adjust the value of \u201cmax_allowed_packet\u201c as 256M in MySQL. ";
    }

    public String getQueryHistoryColumnMeta() {
        return "Start Time,Duration,Query ID,SQL Statement,Answered by,Query Status,Query Node,Submitter,Query Message\n";
    }

    public String getJobPauseFailed() {
        return "This type of task does not support pause operation.";
    }

    public String getInvalidBrokerDefinition() {
        return "The broker filed can\u2019t be empty. Please check and try again.";
    }

    public String getBrokerTimeoutMessage() {
        return "Can\u2019t get the cluster information. Please check whether the broker information is correct, or confirm whether the Kafka server status is normal.";
    }

    public String getStreamingTimeoutMessage() {
        return "Can\u2019t get sample data. Please check and try again.";
    }

    public String getEmptyStreamingMessage() {
        return "This topic has no sample data. Please select another one.";
    }

    public String getInvalidStreamingMessageType() {
        return "The format is invalid. Only support json or binary at the moment. Please check and try again.";
    }

    public String getParseStreamingMessageError() {
        return "The parser cannot parse the sample data. Please check the options or modify the parser, and parse again.";
    }

    public String getReadKafkaJaasFileError() {
        return "Can't read Kafka authentication file correctly. Please check and try again.";
    }

    public String getBatchStreamTableNotMatch() {
        return "The columns from table \u201c%s\u201c and the Kafka table are not identical. Please check and try again.";
    }

    public String getStreamingIndexesDelete() {
        return "Can\u2019t delete the streaming indexes. Please stop the streaming job and then delete all the streaming segments.";
    }

    public String getStreamingIndexesEdit() {
        return "Can\u2019t edit the streaming indexes. Please stop the streaming job and then delete all the streaming segments.";
    }

    public String getStreamingIndexesAdd() {
        return "Can\u2019t add the streaming indexes. Please stop the streaming job and then delete all the streaming segments.";
    }

    public String getStreamingIndexesApprove() {
        return "Streaming model can\u2019t accept recommendations at the moment.";
    }

    public String getStreamingIndexesConvert() {
        return "Streaming model can\u2019t convert to recommendations at the moment.";
    }

    public String getCannotForceToBothPushdodwnAndIndex() {
        return "Cannot force the query to pushdown and index at the same time. Only one of the parameter \u201cforcedToPushDown\u201c and \u201cforced_to_index\u201d could be used. Please check and try again.";
    }

    public String getParameterEmpty() {
        return PARAMETER_EMPTY;
    }

    public String getFixStreamingSegment() {
        return "Can\u2019t fix segment in streaming model.";
    }

    public String getStreamingDisabled() {
        return "The Real-time functions is under development.";
    }

    public String getNoStreamingModelFound() {
        return "Can't be queried. As streaming data must be queried through indexes, please ensure there is an index for the query. ";
    }

    public String getStreamingTableNotSupportAutoModeling() {
        return "No support streaming table for auto modeling.";
    }

    public String getSparkFailure() {
        return "Can't complete the operation. Please check the Spark environment and try again. ";
    }

    public String getDownloadQueryHistoryTimeout() {
        return "Export SQL timeout, please try again later.";
    }

    public String getStreamingOperationNotSupport() {
        return "Can\u2019t call this API. API calls related to the streaming data is not supported at the moment.";
    }

    public String getJdbcConnectionInfoWrong() {
        return "Invalid connection info.Please check and try again.";
    }

    public String getJdbcNotSupportPartitionColumnInSnapshot() {
        return "Snapshot can\u2019t use partition column for the current data source.";
    }

    public String getParamTooLarge() {
        return "The parameter '%s' is too large, maximum %s KB.";
    }

    public String getSqlBlacklistItemIdEmpty() {
        return "The id of blacklist item can not be empty.";
    }

    public String getSqlBlacklistItemRegexAndSqlEmpty() {
        return "The regex and sql of blacklist item can not all be empty.";
    }

    public String getSqlBlacklistItemProjectEmpty() {
        return "The project of blacklist item can not be empty.";
    }

    public String getSqlBlacklistItemIdExists() {
        return "Sql blacklist item id already exist.";
    }

    public String getSqlBlacklistItemIdNotExists() {
        return "Sql blacklist item id not exists.";
    }

    public String getSqlBlacklistItemRegexExists() {
        return "Sql blacklist item regex already exist. Blacklist item id: %s .";
    }

    public String getSqlBlacklistItemSqlExists() {
        return "Sql blacklist item sql already exist. Blacklist item id: %s .";
    }

    public String getSqlBlacklistItemIdToDeleteEmpty() {
        return "The id of sql blacklist item to delete can not be empty.";
    }

    public String getSqlBlacklistQueryRejected() {
        return "Query is rejected by blacklist, blacklist item id: %s.";
    }

    public String getSqlBlackListQueryConcurrentLimitExceeded() {
        return "Query is rejected by blacklist because concurrent limit is exceeded, blacklist item id: %s, concurrent limit: {%s}";
    }

    public String getInvalidRange() {
        return "%s is not integer in range [%s - %s] ";
    }

    public String getInvalidDateFormat() {
        return "The expected date format is %s while the input is %s";
    }

    public String getlDapUserDataSourceConnectionFailed() {
        return "The LDAP server is abnormal. Please check the user data source and try again.";
    }

    public String getLdapUserDataSourceConfigError() {
        return "LDAP connection error, please check LDAP configuration!";
    }

    public String getTableNoColumnsPermission() {
        return "Please add permissions to columns in the table!";
    }

    public String getDisablePushDownPrompt() {
        return DISABLE_PUSHDOWN_PROMPT;
    }

    public String getNonExistedModel() {
        return NON_EXISTEN_MODEL;
    }

    public String getLackProject() {
        return LACK_PROJECT;
    }

    public String getNonExistProject() {
        return NON_EXIST_PROJECT;
    }

    public String getInvalidMergeSegmentWithoutDFS() {
        return "The indexes included in the selected segments are not loaded to HDFS storage/object storage. Please ensure the indexes are loaded into HDFS storage and try merging again.";
    }

    public String getProfilingNotEnabled() {
        return PROFILING_NOT_ENABLED;
    }

    public String getProfilingNotStartError() {
        return "Async profiler status error, profiler is not start yet.";
    }

    public String getProfilingStartedError() {
        return "Async profiler status error, profiler is started already.";
    }

    public String getProfilingJobNotStartError() {
        return "Async profiler status error, job does not start yet.";
    }

    public String getProfilingJobFinishedError() {
        return "Async profiler status error, job is finished already.";
    }

    public String getProfilingYarnAppIdError() {
        return "Async profiler status error, yarnAppId entered incorrectly, please try again.";
    }

    public String getProfilingCollectTimeout() {
        return PROFILING_COLLECT_TIMEOUT;
    }

    public String getTargetSegmentNotFoundError(String missingSegIds) {
        return String.format(Locale.ROOT, "Cannot find target segment, and missing segment id: %s", missingSegIds);
    }

    public String getDDLUnSupported() {
        return DDL_UNSUPPORTED;
    }

    public String getDDLViewNameError() {
        return DDL_VIEW_NAME_ERROR;
    }

    public String getDDLViewNameDuplicateError() {
        return DDL_VIEW_NAME_DUPLICATE_ERROR;
    }

    public String getDDLDropError() {
        return DDL_DROP_ERROR;
    }

    public String getDDLTableNotLoad(String table) {
        return String.format(Locale.ROOT, DDL_TABLE_NOT_LOADED, table);
    }

    public String getDDLTableNotSupport(String table) {
        return String.format(Locale.ROOT, DDL_TABLE_NOT_SUPPORT, table);
    }

    public String getDDLDatabaseAccessnDenied() {
        return DDL_DATABASE_ACCESSN_DENIED;
    }

    public String getDDLLogicalViewHasUsed(String table, String project) {
        return String.format(Locale.ROOT, DDL_LOGICAL_VIEW_HAS_USED, table, project);
    }

    public String getDDLLogicalViewSourceTableError(String table) {
        return String.format(Locale.ROOT, DDL_LOGICAL_VIEW_SOURCETABLE_ERROR, table);
    }

    public String getDDLRestrictError(String syntax) {
        return String.format(Locale.ROOT, DDL_RESTRICT, syntax);
    }

    public String getLoadLogicalViewError(String tableName, String project) {
        return String.format(Locale.ROOT, LOAD_LOGICAL_VIEW_ERROR, tableName, project);
    }

    public String getAsyncQueryCancel(String queryId) {
        return String.format(Locale.ROOT, "Async Query\uff08id=%s\uff09 will be canceled", queryId);
    }

    public String getQueryNotRunningError() {
        return "Query is not running, please check.";
    }

    public String getIllegalNegative(String parameter) {
        return String.format(Locale.ROOT, PARAMETER_MUST_BE_POSITIVE_NUMBER, parameter);
    }

    public String getInvalidDataBinderAutoGrowCollectionLimit() {
        return "Operation failed, please increase the value of kylin.web.data-binder.auto-grow-collection-limit and try again.";
    }

    public String getRedisInitFailed() {
        return "Redis init failed";
    }

    public String getModelConfigExist() {
        return "'%s' model config not exist, please check model type.";
    }

    public String getModelConfigKeyNotExist() {
        return "{%s} is not set, please add and try again.";
    }

    public String getModelConfigKeyExist() {
        return "The parameter {%s} already exists, please modify and try again.";
    }

    public String getModelStorageUpdateFailed() {
        return "Update model storage failed, please make sure model not contain segment.";
    }
}

