/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.common.persistence;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.NavigableSet;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.NotImplementedException;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.persistence.ImageDesc;
import org.apache.kylin.common.persistence.InMemResourceStore;
import org.apache.kylin.common.persistence.MetadataType;
import org.apache.kylin.common.persistence.RawResource;
import org.apache.kylin.common.persistence.RawResourceFilter;
import org.apache.kylin.common.persistence.RootPersistentEntity;
import org.apache.kylin.common.persistence.Serializer;
import org.apache.kylin.common.persistence.StringEntity;
import org.apache.kylin.common.persistence.UnitMessages;
import org.apache.kylin.common.persistence.metadata.AuditLogStore;
import org.apache.kylin.common.persistence.metadata.MetadataStore;
import org.apache.kylin.common.util.JsonUtil;
import org.apache.kylin.common.util.RandomUtil;
import org.apache.kylin.guava30.shaded.common.annotations.VisibleForTesting;
import org.apache.kylin.guava30.shaded.common.base.Throwables;
import org.apache.kylin.guava30.shaded.common.cache.Cache;
import org.apache.kylin.guava30.shaded.common.cache.CacheBuilder;
import org.apache.kylin.guava30.shaded.common.cache.CacheLoader;
import org.apache.kylin.guava30.shaded.common.collect.Lists;
import org.apache.kylin.guava30.shaded.common.io.ByteSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ResourceStore
implements AutoCloseable {
    private static final Logger logger = LoggerFactory.getLogger(ResourceStore.class);
    public static final String GLOBAL_PROJECT = "_global";
    public static final String TABLE_EXD_RESOURCE_ROOT = "/table_exd";
    public static final String METASTORE_IMAGE_META_KEY_TAG = "_image";
    public static final String METASTORE_IMAGE = MetadataType.mergeKeyWithType("_image", MetadataType.SYSTEM);
    public static final String METASTORE_UUID_META_KEY_TAG = "UUID";
    public static final String UPGRADE_META_KEY_PREFIX = "/_global/upgrade/";
    public static final String UPGRADE_META_KEY_TAG = "acl_version";
    public static final String METASTORE_UUID_TAG = MetadataType.mergeKeyWithType("UUID", MetadataType.SYSTEM);
    public static final String METASTORE_TRASH_RECORD_KEY = "trash_record";
    public static final String METASTORE_TRASH_RECORD = MetadataType.mergeKeyWithType("trash_record", MetadataType.SYSTEM);
    public static final String REC_FILE = "rec";
    public static final String COMPRESSED_FILE = "metadata.zip";
    public static final String VERSION_FILE_META_KEY_TAG = "VERSION";
    public static final String VERSION_FILE = MetadataType.mergeKeyWithType("VERSION", MetadataType.SYSTEM);
    private static final String KYLIN_PROPS = "kylin.properties";
    private static final Cache<KylinConfig, ResourceStore> META_CACHE = CacheBuilder.newBuilder().maximumSize((long)KylinConfig.getInstanceFromEnv().getMetadataCacheMaxNum()).expireAfterAccess((long)KylinConfig.getInstanceFromEnv().getMetadataCacheMaxDuration(), TimeUnit.MINUTES).build((CacheLoader)new CacheLoader<KylinConfig, ResourceStore>(){

        public ResourceStore load(KylinConfig config) {
            return ResourceStore.createResourceStore(config);
        }
    });
    protected MetadataStore metadataStore;
    long offset;
    Callback<Boolean> checker;
    protected final KylinConfig kylinConfig;

    public static ResourceStore getKylinMetaStore(KylinConfig config) {
        try {
            return (ResourceStore)META_CACHE.get((Object)config, () -> ResourceStore.createResourceStore(config));
        }
        catch (ExecutionException e) {
            throw new RuntimeException(e);
        }
    }

    public static boolean isPotentialMemoryLeak() {
        return META_CACHE.size() > 100L;
    }

    public static void clearCache() {
        META_CACHE.invalidateAll();
    }

    public static void clearCache(KylinConfig config) {
        META_CACHE.invalidate((Object)config);
    }

    public static void setRS(KylinConfig config, ResourceStore rs) {
        META_CACHE.put((Object)config, (Object)rs);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static ResourceStore createResourceStore(KylinConfig config) {
        try (InMemResourceStore resourceStore = new InMemResourceStore(config);){
            MetadataStore snapshotStore = MetadataStore.createMetadataStore(config);
            resourceStore.init(snapshotStore);
            InMemResourceStore inMemResourceStore = resourceStore;
            return inMemResourceStore;
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Failed to create metadata store", e);
        }
    }

    protected ResourceStore(KylinConfig kylinConfig) {
        this.kylinConfig = kylinConfig;
    }

    public final KylinConfig getConfig() {
        return this.kylinConfig;
    }

    public final NavigableSet<String> listResources(String path) {
        return this.listResources(path, new RawResourceFilter());
    }

    public final NavigableSet<String> listResources(String path, RawResourceFilter filter) {
        return this.listResourcesImpl(path, filter, false);
    }

    public final NavigableSet<String> listResourcesRecursively(String type) {
        return this.listResourcesRecursively(type, new RawResourceFilter());
    }

    public final NavigableSet<String> listResourcesRecursivelyByProject(String project) {
        TreeSet<String> resources = new TreeSet<String>();
        RawResourceFilter filter = RawResourceFilter.equalFilter("project", project);
        MetadataType.NON_GLOBAL_METADATA_TYPE.forEach(type -> resources.addAll(this.listResourcesRecursively(type.name(), filter)));
        resources.addAll(this.listResourcesRecursively(MetadataType.PROJECT.name(), RawResourceFilter.equalFilter("metaKey", project)));
        return resources;
    }

    public final NavigableSet<String> listResourcesRecursively(String folderPath, RawResourceFilter filter) {
        return this.listResourcesImpl(folderPath, filter, true);
    }

    protected abstract NavigableSet<String> listResourcesImpl(String var1, RawResourceFilter var2, boolean var3);

    protected void init(MetadataStore metadataStore) throws Exception {
        this.metadataStore = metadataStore;
        this.reload();
    }

    public String getMetaStoreUUID() {
        StringEntity entity = this.getResource(METASTORE_UUID_TAG, StringEntity.serializer);
        return String.valueOf(entity);
    }

    public final boolean exists(String resPath) {
        return this.existsImpl(resPath);
    }

    protected abstract boolean existsImpl(String var1);

    public abstract int batchLock(MetadataType var1, RawResourceFilter var2);

    public final <T extends RootPersistentEntity> T getResource(String resPath, Serializer<T> serializer) {
        return this.getResource(resPath, serializer, false);
    }

    public final <T extends RootPersistentEntity> T getResource(String resPath, Serializer<T> serializer, boolean needLock) {
        RawResource res = this.getResourceImpl(resPath, needLock);
        if (res == null) {
            return null;
        }
        return this.getResourceFromRawResource(res, serializer);
    }

    /*
     * Exception decompiling
     */
    private <T extends RootPersistentEntity> T getResourceFromRawResource(RawResource res, Serializer<T> serializer) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 1[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public final RawResource getResource(String resPath) {
        return this.getResource(resPath, false);
    }

    public final RawResource getResource(String resPath, boolean needLock) {
        return this.getResourceImpl(resPath, needLock);
    }

    public final <T extends RootPersistentEntity> List<T> getAllResources(String folderPath, Serializer<T> serializer) {
        return this.getAllResources(folderPath, Long.MIN_VALUE, Long.MAX_VALUE, serializer);
    }

    public final <T extends RootPersistentEntity> List<T> getAllResources(String folderPath, long timeStart, long timeEndExclusive, Serializer<T> serializer) {
        List<RawResource> allResources = this.getMatchedResourcesWithoutContent(folderPath, new RawResourceFilter());
        if (allResources == null || allResources.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<T> result = new ArrayList<T>();
        for (RawResource rawResource : allResources) {
            T element = this.getResourceFromRawResource(rawResource, serializer);
            if (null == element || timeStart > ((RootPersistentEntity)element).getCreateTime() || ((RootPersistentEntity)element).getCreateTime() >= timeEndExclusive) continue;
            result.add(element);
        }
        return result;
    }

    @VisibleForTesting
    public List<RawResource> getMatchedResourcesWithoutContent(String folderPath, RawResourceFilter filter) {
        NavigableSet<String> resources = this.listResources(folderPath, filter);
        if (resources == null) {
            return Collections.emptyList();
        }
        ArrayList result = Lists.newArrayListWithCapacity((int)resources.size());
        for (String res : resources) {
            RawResource nullAbleResource = this.getResourceImpl(res, false);
            if (nullAbleResource == null) continue;
            result.add(nullAbleResource);
        }
        return result;
    }

    protected abstract RawResource getResourceImpl(String var1, boolean var2);

    public final <T extends RootPersistentEntity> void checkAndPutResource(String resPath, T obj, Serializer<T> serializer) {
        long oldMvcc = obj.getMvcc();
        obj.setMvcc(oldMvcc + 1L);
        ByteArrayOutputStream buf = new ByteArrayOutputStream();
        DataOutputStream dout = new DataOutputStream(buf);
        try {
            serializer.serialize(obj, dout);
            dout.close();
            buf.close();
        }
        catch (IOException e) {
            Throwables.propagate((Throwable)e);
        }
        ByteSource byteSource = ByteSource.wrap((byte[])buf.toByteArray());
        RawResource x = this.checkAndPutResource(resPath, byteSource, oldMvcc);
        obj.setLastModified(x.getTs());
    }

    public abstract RawResource checkAndPutResource(String var1, ByteSource var2, long var3);

    public abstract RawResource checkAndPutResource(String var1, ByteSource var2, long var3, long var5);

    public final void deleteResource(String resPath) {
        logger.trace("Deleting resource {}", (Object)resPath);
        this.deleteResourceImpl(resPath);
    }

    protected abstract void deleteResourceImpl(String var1);

    public final String getReadableResourcePath(String resPath) {
        return this.getReadableResourcePathImpl(resPath);
    }

    protected abstract String getReadableResourcePathImpl(String var1);

    public void putResourceWithoutCheck(String resPath, ByteSource bs, long timeStamp, long newMvcc) {
        this.putResourceWithoutCheck(resPath, bs, timeStamp, newMvcc, false);
    }

    public void putResourceWithoutCheck(String resPath, ByteSource bs, long timeStamp, long newMvcc, boolean force) {
        throw new NotImplementedException("Only implemented in InMemoryResourceStore");
    }

    public void catchup() {
        AuditLogStore auditLogStore = this.getAuditLogStore();
        RawResource raw = this.getResource(METASTORE_IMAGE);
        try {
            long restoreOffset = this.offset;
            if (raw != null) {
                ImageDesc imageDesc = JsonUtil.readValue(raw.getByteSource().read(), ImageDesc.class);
                restoreOffset = imageDesc.getOffset();
            }
            auditLogStore.restore(restoreOffset);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public abstract void reload() throws IOException;

    public List<String> collectResourceRecursively(MetadataType type, RawResourceFilter filter) {
        if (filter.getConditions().isEmpty()) {
            return new ArrayList<String>(this.listResourcesRecursively(type.name()));
        }
        List<RawResource> matchedResources = this.getMatchedResourcesWithoutContent(type.name(), filter);
        return matchedResources.stream().map(RawResource::generateKeyWithType).collect(Collectors.toList());
    }

    @Override
    public void close() {
        ResourceStore.clearCache(this.getConfig());
    }

    public static void dumpResourceMaps(File metaDir, Map<String, RawResource> dumpMap) {
        long startTime = System.currentTimeMillis();
        if (!metaDir.exists()) {
            metaDir.mkdirs();
        }
        for (Map.Entry<String, RawResource> entry : dumpMap.entrySet()) {
            RawResource res = entry.getValue();
            if (res == null) {
                throw new IllegalStateException("No resource found at -- " + entry.getKey());
            }
            try {
                File f = Paths.get(metaDir.getAbsolutePath(), res.generateKeyWithType()).toFile();
                f.getParentFile().mkdirs();
                FileOutputStream out = new FileOutputStream(f);
                Throwable throwable = null;
                try {
                    InputStream input = res.getByteSource().openStream();
                    Throwable throwable2 = null;
                    try {
                        IOUtils.copy((InputStream)input, (OutputStream)out);
                        if (f.setLastModified(res.getTs())) continue;
                        logger.info("{} modified time change failed", (Object)f);
                    }
                    catch (Throwable throwable3) {
                        throwable2 = throwable3;
                        throw throwable3;
                    }
                    finally {
                        if (input == null) continue;
                        if (throwable2 != null) {
                            try {
                                input.close();
                            }
                            catch (Throwable throwable4) {
                                throwable2.addSuppressed(throwable4);
                            }
                            continue;
                        }
                        input.close();
                    }
                }
                catch (Throwable throwable5) {
                    throwable = throwable5;
                    throw throwable5;
                }
                finally {
                    if (out == null) continue;
                    if (throwable != null) {
                        try {
                            out.close();
                        }
                        catch (Throwable throwable6) {
                            throwable.addSuppressed(throwable6);
                        }
                        continue;
                    }
                    out.close();
                }
            }
            catch (IOException e) {
                throw new IllegalStateException("dump " + res.generateKeyWithType() + " failed", e);
            }
        }
        logger.debug("Dump resources to {} took {} ms", (Object)metaDir, (Object)(System.currentTimeMillis() - startTime));
    }

    public static void dumpResources(KylinConfig kylinConfig, File metaDir, Set<String> dumpList, Properties properties) {
        long startTime = System.currentTimeMillis();
        metaDir.mkdirs();
        ResourceStore from = ResourceStore.getKylinMetaStore(kylinConfig);
        if (dumpList == null) {
            dumpList = from.listResourcesRecursively(MetadataType.ALL.name());
        }
        for (String path : dumpList) {
            RawResource res = from.getResource(path);
            if (res == null) {
                throw new IllegalStateException("No resource found at -- " + path);
            }
            try {
                File f = Paths.get(metaDir.getAbsolutePath(), res.generateFilePath()).toFile();
                f.getParentFile().mkdirs();
                FileOutputStream out = new FileOutputStream(f);
                Throwable throwable = null;
                try {
                    InputStream in = res.getByteSource().openStream();
                    Throwable throwable2 = null;
                    try {
                        IOUtils.copy((InputStream)in, (OutputStream)out);
                        if (f.setLastModified(res.getTs())) continue;
                        logger.info("{} modified time change failed", (Object)f);
                    }
                    catch (Throwable throwable3) {
                        throwable2 = throwable3;
                        throw throwable3;
                    }
                    finally {
                        if (in == null) continue;
                        if (throwable2 != null) {
                            try {
                                in.close();
                            }
                            catch (Throwable throwable4) {
                                throwable2.addSuppressed(throwable4);
                            }
                            continue;
                        }
                        in.close();
                    }
                }
                catch (Throwable throwable5) {
                    throwable = throwable5;
                    throw throwable5;
                }
                finally {
                    if (out == null) continue;
                    if (throwable != null) {
                        try {
                            out.close();
                        }
                        catch (Throwable throwable6) {
                            throwable.addSuppressed(throwable6);
                        }
                        continue;
                    }
                    out.close();
                }
            }
            catch (IOException e) {
                throw new IllegalStateException("dump " + res.getMetaKey() + " failed", e);
            }
        }
        if (properties != null) {
            File kylinPropsFile = new File(metaDir, KYLIN_PROPS);
            try (FileOutputStream os = new FileOutputStream(kylinPropsFile);){
                properties.store(os, kylinPropsFile.getAbsolutePath());
            }
            catch (Exception e) {
                throw new IllegalStateException("save kylin.properties failed", e);
            }
        }
        logger.debug("Dump resources to {} took {} ms", (Object)metaDir, (Object)(System.currentTimeMillis() - startTime));
    }

    public static void dumpResources(KylinConfig kylinConfig, File metaDir, Set<String> dumpList) {
        ResourceStore.dumpResources(kylinConfig, metaDir, dumpList, null);
    }

    public static void dumpResources(KylinConfig kylinConfig, String dumpDir) {
        ResourceStore.dumpResources(kylinConfig, new File(dumpDir), null, null);
    }

    public static void dumpKylinProps(File metaDir, Properties props) {
        if (Objects.isNull(metaDir)) {
            return;
        }
        if (!metaDir.exists()) {
            metaDir.mkdirs();
        }
        if (Objects.isNull(props)) {
            return;
        }
        File propsFile = new File(metaDir, KYLIN_PROPS);
        try (FileOutputStream os = new FileOutputStream(propsFile);){
            props.store(os, propsFile.getAbsolutePath());
        }
        catch (Exception e) {
            throw new IllegalStateException("dump kylin props failed", e);
        }
    }

    public void copy(String resPath, ResourceStore destRS) {
        RawResource resource = this.getResource(resPath);
        if (resource != null) {
            destRS.putResourceWithoutCheck(resPath, resource.getByteSource(), resource.getTs(), resource.getMvcc());
        } else {
            if (!MetadataType.ALL_TYPE_STR.contains(resPath)) {
                return;
            }
            NavigableSet<String> resources = this.listResourcesRecursively(resPath);
            if (resources == null || resources.isEmpty()) {
                return;
            }
            for (String res : resources) {
                RawResource rawResource = this.getResource(res);
                if (rawResource == null) {
                    logger.warn("The resource {} doesn't exists,there may be transaction problems here", (Object)res);
                    continue;
                }
                destRS.putResourceWithoutCheck(res, rawResource.getByteSource(), rawResource.getTs(), rawResource.getMvcc());
            }
        }
    }

    public AuditLogStore getAuditLogStore() {
        return this.getMetadataStore().getAuditLogStore();
    }

    public void createMetaStoreUuidIfNotExist() {
        if (!this.exists(METASTORE_UUID_TAG)) {
            this.checkAndPutResource(METASTORE_UUID_TAG, new StringEntity(METASTORE_UUID_META_KEY_TAG, RandomUtil.randomUUIDStr()), StringEntity.serializer);
        }
    }

    @Generated
    public MetadataStore getMetadataStore() {
        return this.metadataStore;
    }

    @Generated
    public void setOffset(long offset) {
        this.offset = offset;
    }

    @Generated
    public long getOffset() {
        return this.offset;
    }

    @Generated
    public void setChecker(Callback<Boolean> checker) {
        this.checker = checker;
    }

    @Generated
    public Callback<Boolean> getChecker() {
        return this.checker;
    }

    public static interface Callback<T> {
        public T check(UnitMessages var1);
    }
}

