/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.common.persistence;

import java.util.concurrent.atomic.AtomicLong;
import lombok.Generated;
import org.apache.kylin.common.persistence.RawResource;
import org.apache.kylin.common.persistence.VersionConflictException;

public class VersionedRawResource {
    private RawResource rawResource;
    private AtomicLong mvcc;

    public VersionedRawResource(RawResource rawResource) {
        this.mvcc = new AtomicLong(rawResource.getMvcc());
        this.rawResource = rawResource;
    }

    public void update(RawResource r) {
        if (!this.mvcc.compareAndSet(r.getMvcc() - 1L, r.getMvcc())) {
            throw new VersionConflictException(this.rawResource, r, "Overwriting conflict " + r.getMetaKey() + ", expect old mvcc: " + (r.getMvcc() - 1L) + ", but found: " + this.mvcc.get());
        }
        this.rawResource = r;
    }

    public long getMvcc() {
        return this.mvcc.get();
    }

    @Generated
    public RawResource getRawResource() {
        return this.rawResource;
    }
}

