/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.common.util;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.temporal.ChronoField;
import java.util.Date;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.FastDateFormat;
import org.apache.kylin.common.exception.CommonErrorCode;
import org.apache.kylin.common.exception.ErrorCodeSupplier;
import org.apache.kylin.common.exception.KylinException;
import org.apache.kylin.common.msg.MsgPicker;
import org.apache.kylin.guava30.shaded.common.annotations.VisibleForTesting;
import org.apache.kylin.guava30.shaded.common.base.Preconditions;
import org.apache.kylin.guava30.shaded.common.collect.Maps;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DateFormat {
    public static final String COMPACT_DATE_PATTERN = "yyyyMMdd";
    public static final String DEFAULT_DATE_PATTERN = "yyyy-MM-dd";
    public static final String DEFAULT_DATE_PATTERN_WITH_SLASH = "yyyy/MM/dd";
    public static final String DEFAULT_DATE_PATTERN_WITH_DOT = "yyyy.MM.dd";
    public static final String COMPACT_MONTH_PATTERN = "yyyyMM";
    public static final String DEFAULT_MONTH_PATTERN = "yyyy-MM";
    public static final String DEFAULT_TIME_PATTERN = "HH:mm:ss";
    public static final String DEFAULT_TIME_PATTERN_WITHOUT_SECONDS = "HH:mm";
    public static final String DEFAULT_TIME_PATTERN_WITH_MILLISECONDS_P1 = "HH:mm:ss.SSS";
    public static final String DEFAULT_TIME_PATTERN_WITH_MILLISECONDS_P2 = "HH:mm:ss:SSS";
    public static final String DEFAULT_TIME_PATTERN_WITH_MILLISECONDS_P3 = "HH:mm:ss.SSS'Z'";
    public static final String DEFAULT_TIME_PATTERN_WITH_MILLISECONDS_P4 = "HH:mm:ss.SSSXXX";
    public static final String DEFAULT_DATETIME_PATTERN_WITHOUT_MILLISECONDS = "yyyy-MM-dd HH:mm:ss";
    public static final String DEFAULT_DATETIME_PATTERN_WITH_MILLISECONDS = "yyyy-MM-dd HH:mm:ss.SSS";
    public static final String DEFAULT_DATETIME_PATTERN_WITH_TIMEZONE = "yyyy-MM-dd'T'HH:mm:ss.SSS'Z'";
    private static final int NANOS_TIMESTAMP_LENGTH = 16;
    private static final int MILLIS_TIMESTAMP_LENGTH = 13;
    private static final int SECONDS_TIMESTAMP_LENGTH = 10;
    private static final Map<String, FastDateFormat> formatMap = new ConcurrentHashMap<String, FastDateFormat>();
    private static final Map<String, FastDateFormat> formatMapForEpochDays = new ConcurrentHashMap<String, FastDateFormat>();
    private static final Map<String, String> dateFormatRegex = Maps.newHashMap();
    private static final Logger logger = LoggerFactory.getLogger(DateFormat.class);

    public static FastDateFormat getDateFormat(String datePattern) {
        return DateFormat.getDateFormat(datePattern, false);
    }

    public static FastDateFormat getDateFormat(String datePattern, boolean forEpochDays) {
        FastDateFormat r = DateFormat.getFormatMap(forEpochDays).get(datePattern);
        if (r == null) {
            TimeZone timeZone = forEpochDays ? TimeZone.getTimeZone("GMT") : TimeZone.getDefault();
            r = FastDateFormat.getInstance((String)datePattern, (TimeZone)timeZone);
            DateFormat.getFormatMap(forEpochDays).put(datePattern, r);
        }
        return r;
    }

    private static Map<String, FastDateFormat> getFormatMap(boolean forEpochDays) {
        return forEpochDays ? formatMapForEpochDays : formatMap;
    }

    public static FastDateFormat getDateFormat(String datePattern, TimeZone timeZone) {
        return FastDateFormat.getInstance((String)datePattern, (TimeZone)timeZone);
    }

    public static String formatToCompactDateStr(long millis) {
        return DateFormat.formatToDateStr(millis, COMPACT_DATE_PATTERN);
    }

    public static String formatToDateStr(long millis) {
        return DateFormat.formatToDateStr(millis, DEFAULT_DATE_PATTERN);
    }

    public static String formatToDateStr(long millis, String pattern) {
        return DateFormat.getDateFormat(pattern).format(new Date(millis));
    }

    public static String formatToDateStr(long millis, String pattern, TimeZone timeZone) {
        return DateFormat.getDateFormat(pattern, timeZone).format(new Date(millis));
    }

    public static String formatToTimeStr(long millis) {
        return DateFormat.formatToTimeStr(millis, DEFAULT_DATETIME_PATTERN_WITH_MILLISECONDS);
    }

    public static String formatToTimeStr(long millis, String pattern, TimeZone timeZone) {
        return DateFormat.getDateFormat(pattern, timeZone).format(new Date(millis));
    }

    public static String formatToTimeWithoutMilliStr(long millis) {
        return DateFormat.formatToTimeStr(millis, DEFAULT_DATETIME_PATTERN_WITHOUT_MILLISECONDS);
    }

    public static String castTimestampToString(long millis, TimeZone timeZone) {
        String formatted = DateFormat.formatToTimeStr(millis, DEFAULT_DATETIME_PATTERN_WITH_MILLISECONDS, timeZone);
        while (formatted.endsWith("0")) {
            formatted = StringUtils.removeEnd((String)formatted, (String)"0");
        }
        formatted = StringUtils.removeEnd((String)formatted, (String)".");
        return formatted;
    }

    public static String castTimestampToString(long millis) {
        return DateFormat.castTimestampToString(millis, null);
    }

    public static String formatToTimeStr(long millis, String pattern) {
        return DateFormat.getDateFormat(pattern).format(new Date(millis));
    }

    public static String formatDayToEpochToDateStr(long daysToEpoch, TimeZone timeZone) {
        return DateFormat.formatToDateStr(daysToEpoch * 24L * 60L * 60L * 1000L, DEFAULT_DATE_PATTERN, timeZone);
    }

    public static String dateToString(Date date, String pattern) {
        return DateFormat.getDateFormat(pattern).format(date);
    }

    public static Date stringToDate(String str) {
        return DateFormat.stringToDate(str, DEFAULT_DATE_PATTERN);
    }

    public static Date stringToDate(String str, String pattern) {
        return DateFormat.stringToDate(str, pattern, false);
    }

    public static Date stringToDate(String str, String pattern, boolean forEpochDays) {
        Date date;
        try {
            date = DateFormat.getDateFormat(pattern, forEpochDays).parse(str);
        }
        catch (ParseException e) {
            throw new IllegalArgumentException("'" + str + "' is not a valid date of pattern '" + pattern + "'", e);
        }
        return date;
    }

    public static long stringToMillis(String str) {
        return DateFormat.stringToMillis(str, false);
    }

    public static long stringToMillis(String str, boolean forEpochDays) {
        for (Map.Entry<String, String> regexToPattern : dateFormatRegex.entrySet()) {
            if (!str.matches(regexToPattern.getKey())) continue;
            return DateFormat.stringToDate(str, regexToPattern.getValue(), forEpochDays).getTime();
        }
        try {
            long strToDigit = Long.parseLong(str);
            if (strToDigit > 0L) {
                if (str.length() == 16) {
                    return strToDigit / 1000L;
                }
                if (str.length() == 13) {
                    return strToDigit;
                }
                if (str.length() == 10) {
                    return strToDigit * 1000L;
                }
                return strToDigit * 24L * 60L * 60L * 1000L;
            }
        }
        catch (NumberFormatException e) {
            throw new KylinException((ErrorCodeSupplier)CommonErrorCode.INVALID_TIME_PARTITION_COLUMN, String.format(Locale.ROOT, MsgPicker.getMsg().getInvalidTimeFormat(), str), e);
        }
        throw new KylinException((ErrorCodeSupplier)CommonErrorCode.INVALID_TIME_PARTITION_COLUMN, String.format(Locale.ROOT, MsgPicker.getMsg().getInvalidTimeFormat(), str));
    }

    public static boolean isSupportedDateFormat(String dateStr) {
        Preconditions.checkArgument((dateStr != null ? 1 : 0) != 0);
        for (Map.Entry<String, String> regexToPattern : dateFormatRegex.entrySet()) {
            if (!dateStr.matches(regexToPattern.getKey())) continue;
            return true;
        }
        return false;
    }

    public static boolean isDatePattern(String ptn) {
        return COMPACT_DATE_PATTERN.equals(ptn) || DEFAULT_DATE_PATTERN.equals(ptn) || DEFAULT_DATE_PATTERN_WITH_SLASH.equals(ptn) || DEFAULT_DATE_PATTERN_WITH_DOT.equals(ptn);
    }

    public static boolean isMonthPatten(String ptn) {
        return COMPACT_MONTH_PATTERN.equals(ptn) || DEFAULT_MONTH_PATTERN.equals(ptn);
    }

    public static String proposeDateFormat(String sampleData) {
        Preconditions.checkArgument((boolean)StringUtils.isNotEmpty((CharSequence)sampleData));
        for (Map.Entry<String, String> patternMap : dateFormatRegex.entrySet()) {
            if (!sampleData.matches(patternMap.getKey())) continue;
            return patternMap.getValue();
        }
        throw new KylinException((ErrorCodeSupplier)CommonErrorCode.INVALID_TIME_PARTITION_COLUMN, String.format(Locale.ROOT, MsgPicker.getMsg().getInvalidTimeFormat(), sampleData));
    }

    public static String getFormattedDate(String date, String datePattern) {
        DateTimeFormatter formatter = new DateTimeFormatterBuilder().append(DateTimeFormatter.ofPattern(datePattern, Locale.getDefault(Locale.Category.FORMAT))).parseDefaulting(ChronoField.DAY_OF_MONTH, 1L).parseDefaulting(ChronoField.HOUR_OF_DAY, 0L).parseDefaulting(ChronoField.MINUTE_OF_HOUR, 0L).parseDefaulting(ChronoField.SECOND_OF_MINUTE, 0L).toFormatter();
        LocalDateTime localDateTime = LocalDateTime.parse(date, formatter);
        ZonedDateTime zonedDateTime = ZonedDateTime.of(localDateTime, ZoneId.systemDefault());
        return String.valueOf(zonedDateTime.toInstant().toEpochMilli());
    }

    @VisibleForTesting
    public static void cleanCache() {
        formatMap.clear();
        formatMapForEpochDays.clear();
    }

    public static Long getFormatTimeStamp(String time, String pattern) {
        try {
            if (StringUtils.isNotBlank((CharSequence)time) && StringUtils.isNotBlank((CharSequence)pattern)) {
                SimpleDateFormat sdf = new SimpleDateFormat(pattern, Locale.getDefault(Locale.Category.FORMAT));
                sdf.setTimeZone(TimeZone.getDefault());
                String timeFormat = sdf.format(new Date(Long.parseLong(time)));
                time = Long.toString(sdf.parse(timeFormat).getTime());
            }
        }
        catch (Exception e) {
            logger.warn("format time error", (Throwable)e);
        }
        return Long.parseLong(time);
    }

    public static boolean isTimestampFormat(String format) {
        return DEFAULT_DATETIME_PATTERN_WITHOUT_MILLISECONDS.equals(format) || DEFAULT_DATETIME_PATTERN_WITH_MILLISECONDS.equals(format) || DEFAULT_DATETIME_PATTERN_WITH_TIMEZONE.equals(format);
    }

    static {
        dateFormatRegex.put("^\\d{8}$", COMPACT_DATE_PATTERN);
        dateFormatRegex.put("^\\d{4}-\\d{2}-\\d{2}$", DEFAULT_DATE_PATTERN);
        dateFormatRegex.put("^\\d{4}/\\d{2}/\\d{2}$", DEFAULT_DATE_PATTERN_WITH_SLASH);
        dateFormatRegex.put("^\\d{4}\\.\\d{2}\\.\\d{2}$", DEFAULT_DATE_PATTERN_WITH_DOT);
        dateFormatRegex.put("^\\d{8}\\s\\d{2}:\\d{2}$", "yyyyMMdd HH:mm");
        dateFormatRegex.put("^\\d{4}-\\d{2}-\\d{2}\\s\\d{2}:\\d{2}$", "yyyy-MM-dd HH:mm");
        dateFormatRegex.put("^\\d{4}/\\d{2}/\\d{2}\\s\\d{2}:\\d{2}$", "yyyy/MM/dd HH:mm");
        dateFormatRegex.put("^\\d{4}\\.\\d{2}\\.\\d{2}\\s\\d{2}:\\d{2}$", "yyyy.MM.dd HH:mm");
        dateFormatRegex.put("^\\d{8}\\s\\d{2}:\\d{2}:\\d{2}$", "yyyyMMdd HH:mm:ss");
        dateFormatRegex.put("^\\d{4}-\\d{2}-\\d{2}\\s\\d{2}:\\d{2}:\\d{2}$", DEFAULT_DATETIME_PATTERN_WITHOUT_MILLISECONDS);
        dateFormatRegex.put("^\\d{4}/\\d{2}/\\d{2}\\s\\d{2}:\\d{2}:\\d{2}$", "yyyy/MM/dd HH:mm:ss");
        dateFormatRegex.put("^\\d{4}\\.\\d{2}\\.\\d{2}\\s\\d{2}:\\d{2}:\\d{2}$", "yyyy.MM.dd HH:mm:ss");
        dateFormatRegex.put("^\\d{8}\\s\\d{2}:\\d{2}:\\d{2}\\.\\d{3}$", "yyyyMMdd HH:mm:ss.SSS");
        dateFormatRegex.put("^\\d{4}-\\d{2}-\\d{2}\\s\\d{2}:\\d{2}:\\d{2}\\.\\d+$", DEFAULT_DATETIME_PATTERN_WITH_MILLISECONDS);
        dateFormatRegex.put("^\\d{4}/\\d{2}/\\d{2}\\s\\d{2}:\\d{2}:\\d{2}\\.\\d+$", "yyyy/MM/dd HH:mm:ss.SSS");
        dateFormatRegex.put("^\\d{4}\\.\\d{2}\\.\\d{2}\\s\\d{2}:\\d{2}:\\d{2}\\.\\d+$", "yyyy.MM.dd HH:mm:ss.SSS");
        dateFormatRegex.put("^\\d{8}\\s\\d{2}:\\d{2}:\\d{2}:\\d{3}$", "yyyyMMdd HH:mm:ss:SSS");
        dateFormatRegex.put("^\\d{4}-\\d{2}-\\d{2}\\s\\d{2}:\\d{2}:\\d{2}:\\d+$", "yyyy-MM-dd HH:mm:ss:SSS");
        dateFormatRegex.put("^\\d{4}/\\d{2}/\\d{2}\\s\\d{2}:\\d{2}:\\d{2}:\\d+$", "yyyy/MM/dd HH:mm:ss:SSS");
        dateFormatRegex.put("^\\d{4}\\.\\d{2}\\.\\d{2}\\s\\d{2}:\\d{2}:\\d{2}:\\d+$", "yyyy.MM.dd HH:mm:ss:SSS");
        dateFormatRegex.put("^\\d{8}T\\d{2}:\\d{2}:\\d{2}.\\d{3}Z$", "yyyyMMdd'T'HH:mm:ss.SSS'Z'");
        dateFormatRegex.put("^\\d{4}-\\d{2}-\\d{2}T\\d{2}:\\d{2}:\\d{2}.\\d+Z$", DEFAULT_DATETIME_PATTERN_WITH_TIMEZONE);
        dateFormatRegex.put("^\\d{4}-\\d{2}-\\d{2}T\\d{2}:\\d{2}:\\d{2}.\\d+\\+\\d{2}:\\d{2}$", "yyyy-MM-dd'T'HH:mm:ss.SSSXXX");
        dateFormatRegex.put("^\\d{4}/\\d{2}/\\d{2}T\\d{2}:\\d{2}:\\d{2}.\\d+Z$", "yyyy/MM/dd'T'HH:mm:ss.SSS'Z'");
        dateFormatRegex.put("^\\d{4}\\.\\d{2}\\.\\d{2}T\\d{2}:\\d{2}:\\d{2}.\\d+Z$", "yyyy.MM.dd'T'HH:mm:ss.SSS'Z'");
        dateFormatRegex.put("^\\d{6}$", COMPACT_MONTH_PATTERN);
        dateFormatRegex.put("^\\d{4}-\\d{2}$", DEFAULT_MONTH_PATTERN);
    }
}

