/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.common.util;

import lombok.Generated;

public class HeadBuilder {
    private StringBuilder builder;
    private final int maxCapacity;

    public HeadBuilder(int initialCapacity, int maxCapacity) {
        if (initialCapacity < 0) {
            throw new IllegalArgumentException("initialCapacity must greater than 0");
        }
        if (maxCapacity < 0) {
            throw new IllegalArgumentException("maxCapacity must greater than 0");
        }
        this.builder = new StringBuilder(Math.min(initialCapacity, maxCapacity));
        this.maxCapacity = maxCapacity;
    }

    public HeadBuilder(int maxCapacity) {
        this(16, maxCapacity);
    }

    private int ensureCapacity(int appendLen) {
        if (this.builder.capacity() >= this.maxCapacity) {
            return Math.min(this.builder.capacity() - this.builder.length(), appendLen);
        }
        if (this.builder.capacity() > this.builder.length() + appendLen) {
            return appendLen;
        }
        int newCapacity = this.builder.length() << 3;
        if (newCapacity > this.maxCapacity) {
            String origin = this.builder.toString();
            this.builder = new StringBuilder(this.maxCapacity);
            this.builder.append(origin);
        } else {
            this.builder.ensureCapacity(Math.max(newCapacity, this.builder.length() + appendLen));
        }
        return Math.min(this.builder.capacity() - this.builder.length(), appendLen);
    }

    public int capacity() {
        return this.builder.capacity();
    }

    public int length() {
        return this.builder.length();
    }

    public HeadBuilder append(String str) {
        return this.append(str, 0, str.length());
    }

    public HeadBuilder append(CharSequence csq) {
        return this.append(csq, 0, csq.length());
    }

    public HeadBuilder append(CharSequence csq, int start, int end) {
        int appendSize = this.ensureCapacity(end - start);
        if (appendSize == 0) {
            return this;
        }
        this.builder.append(csq, start, start + appendSize);
        return this;
    }

    public HeadBuilder append(char c) {
        if (this.ensureCapacity(1) == 0) {
            return this;
        }
        this.builder.append(c);
        return this;
    }

    public String toString() {
        return this.builder.toString();
    }

    @Generated
    public int getMaxCapacity() {
        return this.maxCapacity;
    }
}

