/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.common.util;

import java.io.File;
import java.nio.file.Paths;
import java.util.List;
import java.util.NavigableSet;
import java.util.Set;
import lombok.Generated;
import org.apache.kylin.common.persistence.MetadataType;
import org.apache.kylin.common.persistence.ResourceStore;
import org.apache.kylin.common.persistence.metadata.MetadataStore;
import org.apache.kylin.guava30.shaded.common.collect.Sets;

public class MetadataChecker {
    private final MetadataStore metadataStore;
    private static final String LINE_BREAK = "\n";

    public MetadataChecker(MetadataStore metadataStore) {
        this.metadataStore = metadataStore;
    }

    public static boolean verifyNonMetadataFile(String resourcePath) {
        return resourcePath.endsWith(".DS_Store") || resourcePath.endsWith("kylin.properties") || resourcePath.endsWith("_image");
    }

    public VerifyResult verify() {
        VerifyResult verifyResult = new VerifyResult();
        NavigableSet<String> allFiles = this.metadataStore.listAll();
        for (String file : allFiles) {
            if (MetadataChecker.verifyNonMetadataFile(file)) continue;
            if (file.equals(ResourceStore.METASTORE_UUID_TAG)) {
                verifyResult.existUUIDFile = true;
                continue;
            }
            if (file.equals(ResourceStore.VERSION_FILE)) {
                verifyResult.existVersionFile = true;
                continue;
            }
            if (file.startsWith(MetadataType.USER_GROUP.name())) {
                verifyResult.existUserGroupFile = true;
                continue;
            }
            if (file.startsWith(MetadataType.USER_INFO.name())) {
                verifyResult.existUserDir = true;
                continue;
            }
            if (file.startsWith(MetadataType.OBJECT_ACL.name())) {
                verifyResult.existACLDir = true;
                continue;
            }
            if (file.equals(ResourceStore.METASTORE_IMAGE)) {
                verifyResult.existImageFile = true;
                continue;
            }
            if (file.startsWith("metadata.zip")) {
                verifyResult.existCompressedFile = true;
                continue;
            }
            if (File.separator.equals(Paths.get(file, new String[0]).toFile().getParent())) {
                verifyResult.illegalFiles.add(file);
                continue;
            }
            String tableName = Paths.get(file, new String[0]).getName(0).toString();
            if (MetadataType.ALL_TYPE_STR.contains(tableName)) continue;
            verifyResult.illegalTables.add(tableName);
            verifyResult.illegalFiles.add(file);
        }
        return verifyResult;
    }

    public VerifyResult verifyModelMetadata(List<String> resourcePath) {
        VerifyResult verifyResult = new VerifyResult();
        for (String resoucePath : resourcePath) {
            if (resoucePath.equals(ResourceStore.METASTORE_UUID_TAG)) {
                verifyResult.existUUIDFile = true;
                continue;
            }
            if (resoucePath.equals(ResourceStore.VERSION_FILE)) {
                verifyResult.existVersionFile = true;
                continue;
            }
            if (resoucePath.startsWith(MetadataType.MODEL.name())) {
                verifyResult.existModelDescFile = true;
                continue;
            }
            if (resoucePath.contains(MetadataType.INDEX_PLAN.name())) {
                verifyResult.existIndexPlanFile = true;
                continue;
            }
            if (resoucePath.contains(MetadataType.TABLE_INFO.name())) {
                verifyResult.existTable = true;
                continue;
            }
            if (resoucePath.contains("/")) continue;
            verifyResult.illegalFiles.add(resoucePath);
        }
        return verifyResult;
    }

    public static class VerifyResult {
        boolean existUUIDFile = false;
        boolean existImageFile = false;
        boolean existACLDir = false;
        boolean existUserDir = false;
        boolean existUserGroupFile = false;
        boolean existCompressedFile = false;
        boolean existModelDescFile = false;
        boolean existIndexPlanFile = false;
        boolean existTable = false;
        boolean existVersionFile = false;
        private final Set<String> illegalTables = Sets.newHashSet();
        private final Set<String> illegalFiles = Sets.newHashSet();

        public boolean isQualified() {
            return this.illegalTables.isEmpty() && this.illegalFiles.isEmpty();
        }

        public boolean isModelMetadataQualified() {
            return this.illegalFiles.isEmpty() && this.existUUIDFile && this.existModelDescFile && this.existIndexPlanFile && this.existTable;
        }

        public String getResultMessage() {
            StringBuilder resultMessage = new StringBuilder();
            resultMessage.append("the uuid file exists : ").append(this.existUUIDFile).append(MetadataChecker.LINE_BREAK);
            resultMessage.append("the image file exists : ").append(this.existImageFile).append(MetadataChecker.LINE_BREAK);
            resultMessage.append("the user_group file exists : ").append(this.existUserGroupFile).append(MetadataChecker.LINE_BREAK);
            resultMessage.append("the user dir exist : ").append(this.existUserDir).append(MetadataChecker.LINE_BREAK);
            resultMessage.append("the acl dir exist : ").append(this.existACLDir).append(MetadataChecker.LINE_BREAK);
            if (!this.illegalTables.isEmpty()) {
                resultMessage.append("illegal projects : ").append(MetadataChecker.LINE_BREAK);
                for (String illegalTable : this.illegalTables) {
                    resultMessage.append("\t").append(illegalTable).append(MetadataChecker.LINE_BREAK);
                }
            }
            if (!this.illegalFiles.isEmpty()) {
                resultMessage.append("illegal files : ").append(MetadataChecker.LINE_BREAK);
                for (String illegalFile : this.illegalFiles) {
                    resultMessage.append("\t").append(illegalFile).append(MetadataChecker.LINE_BREAK);
                }
            }
            return resultMessage.toString();
        }

        @Generated
        public boolean isExistUUIDFile() {
            return this.existUUIDFile;
        }

        @Generated
        public boolean isExistImageFile() {
            return this.existImageFile;
        }

        @Generated
        public boolean isExistACLDir() {
            return this.existACLDir;
        }

        @Generated
        public boolean isExistUserDir() {
            return this.existUserDir;
        }

        @Generated
        public boolean isExistUserGroupFile() {
            return this.existUserGroupFile;
        }

        @Generated
        public boolean isExistCompressedFile() {
            return this.existCompressedFile;
        }

        @Generated
        public boolean isExistModelDescFile() {
            return this.existModelDescFile;
        }

        @Generated
        public boolean isExistIndexPlanFile() {
            return this.existIndexPlanFile;
        }

        @Generated
        public boolean isExistTable() {
            return this.existTable;
        }

        @Generated
        public boolean isExistVersionFile() {
            return this.existVersionFile;
        }

        @Generated
        public Set<String> getIllegalTables() {
            return this.illegalTables;
        }

        @Generated
        public Set<String> getIllegalFiles() {
            return this.illegalFiles;
        }
    }
}

